/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.txn.TxnHandler;
import org.apache.hadoop.hive.ql.txn.compactor.HouseKeeperServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcidHouseKeeperService
extends HouseKeeperServiceBase {
    private static final Logger LOG = LoggerFactory.getLogger(AcidHouseKeeperService.class);

    @Override
    protected long getStartDelayMs() {
        return this.hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_TIMEDOUT_TXN_REAPER_START, TimeUnit.MILLISECONDS);
    }

    @Override
    protected long getIntervalMs() {
        return this.hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_TIMEDOUT_TXN_REAPER_INTERVAL, TimeUnit.MILLISECONDS);
    }

    @Override
    protected Runnable getScheduedAction(HiveConf hiveConf, AtomicInteger isAliveCounter) {
        return new TimedoutTxnReaper(hiveConf, isAliveCounter);
    }

    @Override
    public String getServiceDescription() {
        return "Abort expired transactions";
    }

    private static final class TimedoutTxnReaper
    implements Runnable {
        private final TxnHandler txnHandler;
        private final AtomicInteger isAliveCounter;

        private TimedoutTxnReaper(HiveConf hiveConf, AtomicInteger isAliveCounter) {
            this.txnHandler = new TxnHandler(hiveConf);
            this.isAliveCounter = isAliveCounter;
        }

        @Override
        public void run() {
            try {
                long startTime = System.currentTimeMillis();
                this.txnHandler.performTimeOuts();
                int count = this.isAliveCounter.incrementAndGet();
                LOG.info("timeout reaper ran for " + (System.currentTimeMillis() - startTime) / 1000L + "seconds.  isAliveCounter=" + count);
            }
            catch (Throwable t) {
                LOG.error("Serious error in {}", new Object[]{Thread.currentThread().getName(), ": {}" + t.getMessage(), t});
            }
        }
    }
}

