/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class VectorPartitionDesc {
    private static long serialVersionUID = 1L;
    private final VectorMapOperatorReadType vectorMapOperatorReadType;
    private final boolean needsDataTypeConversionCheck;
    private boolean[] conversionFlags;
    private TypeInfo[] typeInfos;

    private VectorPartitionDesc(VectorMapOperatorReadType vectorMapOperatorReadType, boolean needsDataTypeConversionCheck) {
        this.vectorMapOperatorReadType = vectorMapOperatorReadType;
        this.needsDataTypeConversionCheck = needsDataTypeConversionCheck;
        this.conversionFlags = null;
        this.typeInfos = null;
    }

    public static VectorPartitionDesc createVectorizedInputFileFormat() {
        return new VectorPartitionDesc(VectorMapOperatorReadType.VECTORIZED_INPUT_FILE_FORMAT, true);
    }

    public VectorPartitionDesc clone() {
        VectorPartitionDesc result = new VectorPartitionDesc(this.vectorMapOperatorReadType, this.needsDataTypeConversionCheck);
        result.conversionFlags = this.conversionFlags == null ? null : Arrays.copyOf(this.conversionFlags, this.conversionFlags.length);
        result.typeInfos = Arrays.copyOf(this.typeInfos, this.typeInfos.length);
        return result;
    }

    public VectorMapOperatorReadType getVectorMapOperatorReadType() {
        return this.vectorMapOperatorReadType;
    }

    public boolean getNeedsDataTypeConversionCheck() {
        return this.needsDataTypeConversionCheck;
    }

    public void setConversionFlags(boolean[] conversionFlags) {
        this.conversionFlags = conversionFlags;
    }

    public boolean[] getConversionFlags() {
        return this.conversionFlags;
    }

    public TypeInfo[] getTypeInfos() {
        return this.typeInfos;
    }

    public void setTypeInfos(List<TypeInfo> typeInfoList) {
        this.typeInfos = typeInfoList.toArray(new TypeInfo[0]);
    }

    public int getNonPartColumnCount() {
        return this.typeInfos.length;
    }

    public static enum VectorMapOperatorReadType {
        NONE,
        VECTORIZED_INPUT_FILE_FORMAT;

    }
}

