/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class VectorPartitionConversion {
    private static long serialVersionUID = 1L;
    private boolean validConversion;
    private boolean[] resultConversionFlags;
    private TypeInfo invalidFromTypeInfo;
    private TypeInfo invalidToTypeInfo;
    private static HashMap<PrimitiveObjectInspector.PrimitiveCategory, PrimitiveObjectInspector.PrimitiveCategory[]> validFromPrimitiveMap = new HashMap();

    public boolean getValidConversion() {
        return this.validConversion;
    }

    public boolean[] getResultConversionFlags() {
        return this.resultConversionFlags;
    }

    public TypeInfo getInvalidFromTypeInfo() {
        return this.invalidFromTypeInfo;
    }

    public TypeInfo getInvalidToTypeInfo() {
        return this.invalidToTypeInfo;
    }

    private boolean validateOne(TypeInfo fromTypeInfo, TypeInfo toTypeInfo) {
        if (fromTypeInfo.equals(toTypeInfo)) {
            return false;
        }
        if (fromTypeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE && toTypeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            PrimitiveObjectInspector.PrimitiveCategory fromPrimitiveCategory = ((PrimitiveTypeInfo)fromTypeInfo).getPrimitiveCategory();
            PrimitiveObjectInspector.PrimitiveCategory toPrimitiveCategory = ((PrimitiveTypeInfo)toTypeInfo).getPrimitiveCategory();
            PrimitiveObjectInspector.PrimitiveCategory[] toPrimitiveCategories = validFromPrimitiveMap.get((Object)fromPrimitiveCategory);
            if (toPrimitiveCategories == null || !ArrayUtils.contains((Object[])toPrimitiveCategories, (Object)toPrimitiveCategory)) {
                this.invalidFromTypeInfo = fromTypeInfo;
                this.invalidToTypeInfo = toTypeInfo;
                this.validConversion = false;
                return false;
            }
        }
        return true;
    }

    public void validateConversion(List<TypeInfo> fromTypeInfoList, List<TypeInfo> toTypeInfoList) {
        int columnCount = fromTypeInfoList.size();
        this.resultConversionFlags = new boolean[columnCount];
        this.validConversion = true;
        boolean atLeastOneConversion = false;
        for (int i = 0; i < columnCount; ++i) {
            TypeInfo fromTypeInfo = fromTypeInfoList.get(i);
            TypeInfo toTypeInfo = toTypeInfoList.get(i);
            this.resultConversionFlags[i] = this.validateOne(fromTypeInfo, toTypeInfo);
            if (this.validConversion) continue;
            return;
        }
        if (!atLeastOneConversion) {
            this.resultConversionFlags = null;
        }
    }

    public void validateConversion(TypeInfo[] fromTypeInfos, TypeInfo[] toTypeInfos) {
        int columnCount = fromTypeInfos.length;
        this.resultConversionFlags = new boolean[columnCount];
        this.validConversion = true;
        boolean atLeastOneConversion = false;
        for (int i = 0; i < columnCount; ++i) {
            TypeInfo fromTypeInfo = fromTypeInfos[i];
            TypeInfo toTypeInfo = toTypeInfos[i];
            this.resultConversionFlags[i] = this.validateOne(fromTypeInfo, toTypeInfo);
            if (!this.validConversion) {
                return;
            }
            if (!this.resultConversionFlags[i]) continue;
            atLeastOneConversion = true;
        }
        if (!atLeastOneConversion) {
            this.resultConversionFlags = null;
        }
    }

    static {
        validFromPrimitiveMap.put(PrimitiveObjectInspector.PrimitiveCategory.SHORT, new PrimitiveObjectInspector.PrimitiveCategory[]{PrimitiveObjectInspector.PrimitiveCategory.INT, PrimitiveObjectInspector.PrimitiveCategory.LONG});
        validFromPrimitiveMap.put(PrimitiveObjectInspector.PrimitiveCategory.INT, new PrimitiveObjectInspector.PrimitiveCategory[]{PrimitiveObjectInspector.PrimitiveCategory.LONG});
    }
}

