/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class LongColModuloDoubleColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum1;
    private int colNum2;
    private int outputColumn;

    public LongColModuloDoubleColumn(int colNum1, int colNum2, int outputColumn) {
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
        this.outputColumn = outputColumn;
    }

    public LongColModuloDoubleColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector1 = (LongColumnVector)batch.cols[this.colNum1];
        DoubleColumnVector inputColVector2 = (DoubleColumnVector)batch.cols[this.colNum2];
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        int n = batch.size;
        long[] vector1 = inputColVector1.vector;
        double[] vector2 = inputColVector2.vector;
        double[] outputVector = outputColVector.vector;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = inputColVector1.isRepeating && inputColVector2.isRepeating || inputColVector1.isRepeating && !inputColVector1.noNulls && inputColVector1.isNull[0] || inputColVector2.isRepeating && !inputColVector2.noNulls && inputColVector2.isNull[0];
        NullUtil.propagateNullsColCol(inputColVector1, inputColVector2, outputColVector, sel, n, batch.selectedInUse);
        boolean hasDivBy0 = false;
        if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
            double denom = vector2[0];
            outputVector[0] = (double)vector1[0] % denom;
            hasDivBy0 = hasDivBy0 || denom == 0.0;
        } else if (inputColVector1.isRepeating) {
            long vector1Value = vector1[0];
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    double denom = vector2[i];
                    outputVector[i] = (double)vector1Value % denom;
                    hasDivBy0 = hasDivBy0 || denom == 0.0;
                }
            } else {
                int i;
                for (i = 0; i != n; ++i) {
                    outputVector[i] = (double)vector1Value % vector2[i];
                }
                for (i = 0; i != n; ++i) {
                    hasDivBy0 = hasDivBy0 || vector2[i] == 0.0;
                }
            }
        } else if (inputColVector2.isRepeating) {
            double vector2Value = vector2[0];
            if (vector2Value == 0.0) {
                outputColVector.noNulls = false;
                outputColVector.isRepeating = true;
                outputColVector.isNull[0] = true;
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = (double)vector1[i] % vector2Value;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = (double)vector1[i] % vector2Value;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                double denom = vector2[i];
                outputVector[i] = (double)vector1[i] % denom;
                hasDivBy0 = hasDivBy0 || denom == 0.0;
            }
        } else {
            int i;
            for (i = 0; i != n; ++i) {
                outputVector[i] = (double)vector1[i] % vector2[i];
            }
            for (i = 0; i != n; ++i) {
                hasDivBy0 = hasDivBy0 || vector2[i] == 0.0;
            }
        }
        if (!hasDivBy0) {
            NullUtil.setNullDataEntriesDouble(outputColVector, batch.selectedInUse, sel, n);
        } else {
            NullUtil.setNullAndDivBy0DataEntriesDouble(outputColVector, batch.selectedInUse, sel, n, inputColVector2);
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "double";
    }

    public int getColNum1() {
        return this.colNum1;
    }

    public void setColNum1(int colNum1) {
        this.colNum1 = colNum1;
    }

    public int getColNum2() {
        return this.colNum2;
    }

    public void setColNum2(int colNum2) {
        this.colNum2 = colNum2;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("long"), VectorExpressionDescriptor.ArgumentType.getType("double")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

