/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.serde2.io.DateWritable;

public abstract class VectorUDFTimestampFieldLong
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    protected int colNum;
    protected int outputColumn;
    protected int field;
    protected final transient Calendar calendar = Calendar.getInstance();
    protected final transient Timestamp ts = new Timestamp(0L);

    public VectorUDFTimestampFieldLong(int field, int colNum, int outputColumn) {
        this();
        this.colNum = colNum;
        this.outputColumn = outputColumn;
        this.field = field;
    }

    public VectorUDFTimestampFieldLong() {
    }

    protected final Timestamp getTimestamp(long nanos) {
        long ms = nanos / 1000000000L * 1000L;
        long ns = nanos % 1000000000L;
        if (ns < 0L) {
            ms -= 1000L;
            ns += 1000000000L;
        }
        this.ts.setTime(ms);
        this.ts.setNanos((int)ns);
        return this.ts;
    }

    protected long getTimestampField(long time) {
        this.calendar.setTime(this.getTimestamp(time));
        return this.calendar.get(this.field);
    }

    protected long getDateField(long days) {
        this.calendar.setTimeInMillis(DateWritable.daysToMillis((int)days));
        return this.calendar.get(this.field);
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        boolean selectedInUse;
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector outV = (LongColumnVector)batch.cols[this.outputColumn];
        LongColumnVector inputCol = (LongColumnVector)batch.cols[this.colNum];
        int n = inputCol.isRepeating ? 1 : batch.size;
        int[] sel = batch.selected;
        boolean bl = selectedInUse = !inputCol.isRepeating && batch.selectedInUse;
        if (batch.size == 0) {
            return;
        }
        outV.isRepeating = inputCol.isRepeating;
        switch (this.inputTypes[0]) {
            case TIMESTAMP: {
                if (inputCol.noNulls) {
                    outV.noNulls = true;
                    if (selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            outV.vector[i] = this.getTimestampField(inputCol.vector[i]);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outV.vector[i] = this.getTimestampField(inputCol.vector[i]);
                        }
                    }
                } else {
                    outV.noNulls = false;
                    if (selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            outV.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            outV.vector[i] = this.getTimestampField(inputCol.vector[i]);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outV.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            outV.vector[i] = this.getTimestampField(inputCol.vector[i]);
                        }
                    }
                }
                break;
            }
            case DATE: {
                if (inputCol.noNulls) {
                    outV.noNulls = true;
                    if (selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            outV.vector[i] = this.getDateField(inputCol.vector[i]);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outV.vector[i] = this.getDateField(inputCol.vector[i]);
                        }
                    }
                } else {
                    outV.noNulls = false;
                    if (selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            outV.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            outV.vector[i] = this.getDateField(inputCol.vector[i]);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outV.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            outV.vector[i] = this.getDateField(inputCol.vector[i]);
                        }
                    }
                }
                break;
            }
            default: {
                throw new Error("Unsupported input type " + this.inputTypes[0].name());
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "long";
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public int getField() {
        return this.field;
    }

    public void setField(int field) {
        this.field = field;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.DATETIME_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

