/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.BucketMatcher;
import org.apache.hadoop.hive.ql.exec.DummyStoreOperator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.FetchOperator;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.persistence.RowContainer;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.BucketMapJoinContext;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.SMBJoinDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.PriorityQueue;
import org.apache.hive.common.util.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMBMapJoinOperator
extends AbstractMapJoinOperator<SMBJoinDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)SMBMapJoinOperator.class.getName());
    private MapredLocalWork localWork = null;
    private Map<String, MergeQueue> aliasToMergeQueue = Collections.emptyMap();
    transient List<Object>[] keyWritables;
    transient List<Object>[] nextKeyWritables;
    RowContainer<List<Object>>[] nextGroupStorage;
    RowContainer<List<Object>>[] candidateStorage;
    transient String[] tagToAlias;
    private transient boolean[] fetchDone;
    private transient boolean[] foundNextKeyGroup;
    transient boolean firstFetchHappened = false;
    private transient boolean inputFileChanged = false;
    transient boolean localWorkInited = false;
    transient boolean initDone = false;
    private transient boolean convertedAutomaticallySMBJoin = false;
    transient boolean closeCalled = false;

    protected SMBMapJoinOperator() {
    }

    public SMBMapJoinOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public SMBMapJoinOperator(AbstractMapJoinOperator<? extends MapJoinDesc> mapJoinOp) {
        super(mapJoinOp);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        byte pos;
        this.initDone = true;
        super.initializeOp(hconf);
        this.closeCalled = false;
        this.firstFetchHappened = false;
        this.inputFileChanged = false;
        int maxAlias = 0;
        for (int pos2 = 0; pos2 < this.order.length; pos2 = (int)((byte)(pos2 + 1))) {
            if (pos2 <= maxAlias) continue;
            maxAlias = pos2;
        }
        this.nextGroupStorage = new RowContainer[++maxAlias];
        this.candidateStorage = new RowContainer[maxAlias];
        this.keyWritables = new ArrayList[maxAlias];
        this.nextKeyWritables = new ArrayList[maxAlias];
        this.fetchDone = new boolean[maxAlias];
        this.foundNextKeyGroup = new boolean[maxAlias];
        int oldVar = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEMAPJOINBUCKETCACHESIZE);
        int bucketSize = oldVar != 100 ? oldVar : HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVESMBJOINCACHEROWS);
        for (pos = 0; pos < this.order.length; pos = (byte)(pos + 1)) {
            RowContainer<List<Object>> rc = JoinUtil.getRowContainer(hconf, this.rowContainerStandardObjectInspectors[pos], pos, bucketSize, this.spillTableDesc, (JoinDesc)this.conf, !this.hasFilter(pos), this.reporter);
            this.nextGroupStorage[pos] = rc;
            RowContainer<List<Object>> candidateRC = JoinUtil.getRowContainer(hconf, this.rowContainerStandardObjectInspectors[pos], pos, bucketSize, this.spillTableDesc, (JoinDesc)this.conf, !this.hasFilter(pos), this.reporter);
            this.candidateStorage[pos] = candidateRC;
        }
        this.tagToAlias = ((SMBJoinDesc)this.conf).convertToArray(((SMBJoinDesc)this.conf).getTagToAlias(), String.class);
        for (pos = 0; pos < this.order.length; pos = (byte)(pos + 1)) {
            if (pos != this.posBigTable) {
                this.fetchDone[pos] = false;
            }
            this.foundNextKeyGroup[pos] = false;
        }
    }

    @Override
    public void initializeLocalWork(Configuration hconf) throws HiveException {
        this.initializeMapredLocalWork((MapJoinDesc)this.getConf(), hconf, ((SMBJoinDesc)this.getConf()).getLocalWork(), LOG);
        super.initializeLocalWork(hconf);
    }

    public void initializeMapredLocalWork(MapJoinDesc mjConf, Configuration hconf, MapredLocalWork localWork, Logger l4j) throws HiveException {
        if (localWork == null || this.localWorkInited) {
            return;
        }
        this.localWorkInited = true;
        this.localWork = localWork;
        this.aliasToMergeQueue = new HashMap<String, MergeQueue>();
        LinkedHashMap<String, FetchWork> aliasToFetchWork = localWork.getAliasToFetchWork();
        LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork = localWork.getAliasToWork();
        Map<String, DummyStoreOperator> aliasToSinkWork = ((SMBJoinDesc)this.conf).getAliasToSink();
        for (Map.Entry entry : aliasToFetchWork.entrySet()) {
            String alias = (String)entry.getKey();
            FetchWork fetchWork = (FetchWork)entry.getValue();
            JobConf jobClone = new JobConf(hconf);
            TableScanOperator ts = (TableScanOperator)aliasToWork.get(alias);
            ColumnProjectionUtils.appendReadColumns((Configuration)jobClone, ts.getNeededColumnIDs(), ts.getNeededColumns());
            HiveInputFormat.pushFilters(jobClone, ts);
            ts.passExecContext(this.getExecContext());
            FetchOperator fetchOp = new FetchOperator(fetchWork, jobClone);
            ts.initialize((Configuration)jobClone, new ObjectInspector[]{fetchOp.getOutputObjectInspector()});
            fetchOp.clearFetchContext();
            DummyStoreOperator sinkOp = aliasToSinkWork.get(alias);
            MergeQueue mergeQueue = new MergeQueue(alias, fetchWork, jobClone, ts, sinkOp);
            this.aliasToMergeQueue.put(alias, mergeQueue);
            l4j.info("fetch operators for " + alias + " initialized");
        }
    }

    private byte tagForAlias(String alias) {
        for (byte tag = 0; tag < this.tagToAlias.length; tag = (byte)(tag + 1)) {
            if (!alias.equals(this.tagToAlias[tag])) continue;
            return tag;
        }
        return -1;
    }

    @Override
    public void cleanUpInputFileChangedOp() throws HiveException {
        this.inputFileChanged = true;
    }

    protected List<Object> smbJoinComputeKeys(Object row, byte alias) throws HiveException {
        return JoinUtil.computeKeys(row, this.joinKeys[alias], this.joinKeysObjectInspectors[alias]);
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        if (tag == this.posBigTable && this.inputFileChanged) {
            if (this.firstFetchHappened) {
                this.joinFinalLeftData();
            }
            for (Map.Entry<String, MergeQueue> entry : this.aliasToMergeQueue.entrySet()) {
                String alias = entry.getKey();
                MergeQueue mergeQueue = entry.getValue();
                this.setUpFetchContexts(alias, mergeQueue);
            }
            this.firstFetchHappened = false;
            this.inputFileChanged = false;
        }
        if (!this.firstFetchHappened) {
            this.firstFetchHappened = true;
            for (byte pos = 0; pos < this.order.length; pos = (byte)(pos + 1)) {
                if (pos == this.posBigTable) continue;
                this.fetchNextGroup(pos);
            }
        }
        byte alias = (byte)tag;
        List<Object> key = this.smbJoinComputeKeys(row, alias);
        List<Object> value = this.getFilteredValue(alias, row);
        boolean nextKeyGroup = this.processKey(alias, key);
        if (nextKeyGroup) {
            this.nextGroupStorage[alias].addRow(value);
            this.foundNextKeyGroup[tag] = true;
            if (tag != this.posBigTable) {
                return;
            }
        }
        this.reportProgress();
        ++this.numMapRowsRead;
        if (nextKeyGroup) {
            assert (tag == this.posBigTable);
            List<Byte> smallestPos = null;
            while ((smallestPos = this.joinOneGroup()) != null && smallestPos.size() > 0 && !smallestPos.contains(this.posBigTable)) {
            }
            return;
        }
        assert (!nextKeyGroup);
        this.candidateStorage[tag].addRow(value);
    }

    private void joinFinalLeftData() throws HiveException {
        List<Byte> ret;
        RowContainer<List<Object>> bigTblRowContainer = this.candidateStorage[this.posBigTable];
        boolean allFetchDone = this.allFetchDone();
        while (bigTblRowContainer != null && bigTblRowContainer.rowCount() > 0 && !allFetchDone) {
            this.joinOneGroup();
            bigTblRowContainer = this.candidateStorage[this.posBigTable];
            allFetchDone = this.allFetchDone();
        }
        while (!allFetchDone && (ret = this.joinOneGroup()) != null && ret.size() != 0) {
            this.reportProgress();
            ++this.numMapRowsRead;
            allFetchDone = this.allFetchDone();
        }
        boolean dataInCache = true;
        block2: while (dataInCache) {
            byte pos;
            for (pos = 0; pos < this.order.length; pos = (byte)((byte)(pos + 1))) {
                if (!this.foundNextKeyGroup[pos] || this.nextKeyWritables[pos] == null) continue;
                this.promoteNextGroupToCandidate(pos);
            }
            this.joinOneGroup();
            dataInCache = false;
            for (pos = 0; pos < this.order.length; pos = (byte)(pos + 1)) {
                if (!this.candidateStorage[pos].hasRows()) continue;
                dataInCache = true;
                continue block2;
            }
        }
    }

    private boolean allFetchDone() {
        boolean allFetchDone = true;
        for (int pos = 0; pos < this.order.length; pos = (int)((byte)(pos + 1))) {
            if (pos == this.posBigTable) continue;
            allFetchDone = allFetchDone && this.fetchDone[pos];
        }
        return allFetchDone;
    }

    private List<Byte> joinOneGroup() throws HiveException {
        int[] smallestPos = this.findSmallestKey();
        List<Byte> listOfNeedFetchNext = null;
        if (smallestPos != null && (listOfNeedFetchNext = this.joinObject(smallestPos)).size() > 0) {
            for (Byte b : listOfNeedFetchNext) {
                this.fetchNextGroup(b);
            }
        }
        return listOfNeedFetchNext;
    }

    private List<Byte> joinObject(int[] smallestPos) throws HiveException {
        byte index;
        ArrayList<Byte> needFetchList = new ArrayList<Byte>();
        for (index = (byte)(smallestPos.length - 1); index >= 0; index = (byte)(index - 1)) {
            if (smallestPos[index] > 0 || this.keyWritables[index] == null) {
                this.putDummyOrEmpty(index);
                continue;
            }
            this.storage[index] = this.candidateStorage[index];
            needFetchList.add(index);
            if (smallestPos[index] < 0) break;
        }
        for (index = (byte)(index - 1); index >= 0; index = (byte)(index - 1)) {
            this.putDummyOrEmpty(index);
        }
        this.checkAndGenObject();
        for (Byte pos : needFetchList) {
            this.candidateStorage[pos].clearRows();
            this.keyWritables[pos.byteValue()] = null;
        }
        return needFetchList;
    }

    private void fetchNextGroup(Byte t) throws HiveException {
        if (this.foundNextKeyGroup[t]) {
            if (this.nextKeyWritables[t] != null) {
                this.promoteNextGroupToCandidate(t);
            } else {
                this.keyWritables[t.byteValue()] = null;
                this.candidateStorage[t.byteValue()] = null;
                this.nextGroupStorage[t.byteValue()] = null;
            }
            this.foundNextKeyGroup[t.byteValue()] = false;
        }
        if (t == this.posBigTable) {
            return;
        }
        while (!this.foundNextKeyGroup[t] && !this.fetchDone[t]) {
            this.fetchOneRow(t);
        }
        if (!this.foundNextKeyGroup[t] && this.fetchDone[t]) {
            this.nextKeyWritables[t.byteValue()] = null;
        }
    }

    private void promoteNextGroupToCandidate(Byte t) throws HiveException {
        this.keyWritables[t.byteValue()] = this.nextKeyWritables[t];
        this.nextKeyWritables[t.byteValue()] = null;
        RowContainer<List<Object>> oldRowContainer = this.candidateStorage[t];
        oldRowContainer.clearRows();
        this.candidateStorage[t.byteValue()] = this.nextGroupStorage[t];
        this.nextGroupStorage[t.byteValue()] = oldRowContainer;
    }

    private int compareKeys(List<Object> k1, List<Object> k2) {
        int ret = 0;
        ret = k1.size() - k2.size();
        if (ret != 0) {
            return ret;
        }
        for (int i = 0; i < k1.size(); ++i) {
            WritableComparable key_1 = (WritableComparable)k1.get(i);
            WritableComparable key_2 = (WritableComparable)k2.get(i);
            if (key_1 == null && key_2 == null) {
                return this.nullsafes != null && this.nullsafes[i] ? 0 : -1;
            }
            if (key_1 == null) {
                return -1;
            }
            if (key_2 == null) {
                return 1;
            }
            ret = WritableComparator.get(key_1.getClass()).compare(key_1, key_2);
            if (ret == 0) continue;
            return ret;
        }
        return ret;
    }

    private void putDummyOrEmpty(Byte i) {
        this.storage[i.byteValue()] = this.noOuterJoin ? this.emptyList : this.dummyObjVectors[i];
    }

    private int[] findSmallestKey() {
        int[] result = new int[this.order.length];
        List<Object> smallestOne = null;
        for (int pos = 0; pos < this.order.length; pos = (int)((byte)(pos + 1))) {
            List<Object> key = this.keyWritables[pos];
            if (key == null) continue;
            if (smallestOne == null) {
                smallestOne = key;
                result[pos] = -1;
                continue;
            }
            result[pos] = this.compareKeys(key, smallestOne);
            if (result[pos] >= 0) continue;
            smallestOne = key;
        }
        return smallestOne == null ? null : result;
    }

    private boolean processKey(byte alias, List<Object> key) throws HiveException {
        List<Object> keyWritable = this.keyWritables[alias];
        if (keyWritable == null) {
            this.keyWritables[alias] = key;
            return false;
        }
        int cmp = this.compareKeys(key, keyWritable);
        if (cmp != 0) {
            this.nextKeyWritables[alias] = key;
            return true;
        }
        return false;
    }

    private void setUpFetchContexts(String alias, MergeQueue mergeQueue) throws HiveException {
        mergeQueue.clearFetchContext();
        Path currentInputPath = this.getExecContext().getCurrentInputPath();
        BucketMapJoinContext bucketMatcherCxt = this.localWork.getBucketMapjoinContext();
        Class<? extends BucketMatcher> bucketMatcherCls = bucketMatcherCxt.getBucketMatcherClass();
        BucketMatcher bucketMatcher = ReflectionUtil.newInstance(bucketMatcherCls, null);
        this.getExecContext().setFileId(bucketMatcherCxt.createFileId(currentInputPath.toString()));
        if (this.isLogInfoEnabled) {
            LOG.info("set task id: " + this.getExecContext().getFileId());
        }
        bucketMatcher.setAliasBucketFileNameMapping(bucketMatcherCxt.getAliasBucketFileNameMapping());
        List<Path> aliasFiles = bucketMatcher.getAliasBucketFiles(currentInputPath.toString(), bucketMatcherCxt.getMapJoinBigTableAlias(), alias);
        mergeQueue.setupContext(aliasFiles);
    }

    private void fetchOneRow(byte tag) {
        String table = this.tagToAlias[tag];
        MergeQueue mergeQueue = this.aliasToMergeQueue.get(table);
        Operator<OperatorDesc> forwardOp = ((SMBJoinDesc)this.conf).getAliasToSink().get(table).getChildOperators().get(0);
        try {
            InspectableObject row = mergeQueue.getNextRow();
            if (row == null) {
                this.fetchDone[tag] = true;
                return;
            }
            forwardOp.process(row.o, tag);
            if (forwardOp.getDone()) {
                this.fetchDone[tag] = true;
            }
        }
        catch (Throwable e) {
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            throw new RuntimeException("Map local work failed", e);
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        byte pos;
        MergeQueue mergeQueue;
        String alias;
        if (this.closeCalled) {
            return;
        }
        this.closeCalled = true;
        if (!this.initDone) {
            return;
        }
        if (this.inputFileChanged || !this.firstFetchHappened) {
            for (Map.Entry<String, MergeQueue> entry : this.aliasToMergeQueue.entrySet()) {
                alias = entry.getKey();
                mergeQueue = entry.getValue();
                this.setUpFetchContexts(alias, mergeQueue);
            }
            this.firstFetchHappened = true;
            for (pos = 0; pos < this.order.length; pos = (byte)(pos + 1)) {
                if (pos == this.posBigTable) continue;
                this.fetchNextGroup(pos);
            }
            this.inputFileChanged = false;
        }
        this.joinFinalLeftData();
        for (pos = 0; pos < this.order.length; ++pos) {
            if (pos != this.posBigTable) {
                this.fetchDone[pos] = false;
            }
            this.foundNextKeyGroup[pos] = false;
        }
        this.localWorkInited = false;
        super.closeOp(abort);
        for (Map.Entry<String, MergeQueue> entry : this.aliasToMergeQueue.entrySet()) {
            alias = entry.getKey();
            mergeQueue = entry.getValue();
            Operator<? extends OperatorDesc> forwardOp = this.localWork.getAliasToWork().get(alias);
            forwardOp.close(abort);
            mergeQueue.clearFetchContext();
        }
    }

    @Override
    protected boolean allInitializedParentsAreClosed() {
        return true;
    }

    @Override
    public String getName() {
        return SMBMapJoinOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "MAPJOIN";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.MAPJOIN;
    }

    public boolean isConvertedAutomaticallySMBJoin() {
        return this.convertedAutomaticallySMBJoin;
    }

    public void setConvertedAutomaticallySMBJoin(boolean convertedAutomaticallySMBJoin) {
        this.convertedAutomaticallySMBJoin = convertedAutomaticallySMBJoin;
    }

    @Override
    public boolean opAllowedConvertMapJoin() {
        return false;
    }

    private class MergeQueue
    extends PriorityQueue<Integer> {
        private final String alias;
        private final FetchWork fetchWork;
        private final JobConf jobConf;
        transient int counter;
        transient FetchOperator[] segments;
        transient List<ExprNodeEvaluator> keyFields;
        transient List<ObjectInspector> keyFieldOIs;
        transient Operator<? extends OperatorDesc> forwardOp;
        transient DummyStoreOperator sinkOp;
        transient Integer currentMinSegment;
        transient ObjectPair<List<Object>, InspectableObject>[] keys;

        public MergeQueue(String alias, FetchWork fetchWork, JobConf jobConf, Operator<? extends OperatorDesc> forwardOp, DummyStoreOperator sinkOp) {
            this.alias = alias;
            this.fetchWork = fetchWork;
            this.jobConf = jobConf;
            this.forwardOp = forwardOp;
            this.sinkOp = sinkOp;
        }

        public void setupContext(List<Path> paths) throws HiveException {
            int i;
            int segmentLen = paths.size();
            FetchOperator.setFetchOperatorContext(this.jobConf, this.fetchWork.getPartDir());
            FetchOperator[] segments = this.segmentsForSize(segmentLen);
            for (i = 0; i < segmentLen; ++i) {
                Path path = paths.get(i);
                if (segments[i] == null) {
                    segments[i] = new FetchOperator(this.fetchWork, new JobConf((Configuration)this.jobConf));
                }
                segments[i].setupContext(Arrays.asList(path));
            }
            this.initialize(segmentLen);
            for (i = 0; i < segmentLen; ++i) {
                if (!this.nextHive(i)) continue;
                this.put(i);
            }
            this.counter = 0;
        }

        private FetchOperator[] segmentsForSize(int segmentLen) {
            if (this.segments == null || this.segments.length < segmentLen) {
                FetchOperator[] newSegments = new FetchOperator[segmentLen];
                ObjectPair[] newKeys = new ObjectPair[segmentLen];
                if (this.segments != null) {
                    System.arraycopy(this.segments, 0, newSegments, 0, this.segments.length);
                    System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
                }
                this.segments = newSegments;
                this.keys = newKeys;
            }
            return this.segments;
        }

        public void clearFetchContext() throws HiveException {
            if (this.segments != null) {
                for (FetchOperator op : this.segments) {
                    if (op == null) continue;
                    op.clearFetchContext();
                }
            }
        }

        protected boolean lessThan(Object a, Object b) {
            return SMBMapJoinOperator.this.compareKeys(this.keys[(Integer)a].getFirst(), this.keys[(Integer)b].getFirst()) < 0;
        }

        public final InspectableObject getNextRow() throws IOException {
            Integer current;
            if (this.currentMinSegment != null) {
                this.adjustPriorityQueue(this.currentMinSegment);
            }
            if ((current = (Integer)this.top()) == null) {
                if (SMBMapJoinOperator.this.isLogInfoEnabled) {
                    LOG.info("MergeQueue forwarded " + this.counter + " rows");
                }
                return null;
            }
            ++this.counter;
            this.currentMinSegment = current;
            return this.keys[this.currentMinSegment].getSecond();
        }

        private void adjustPriorityQueue(Integer current) throws IOException {
            if (this.nextIO(current)) {
                this.adjustTop();
            } else {
                this.pop();
            }
        }

        private boolean nextHive(Integer current) throws HiveException {
            try {
                return this.next(current);
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
        }

        private boolean nextIO(Integer current) throws IOException {
            try {
                return this.next(current);
            }
            catch (HiveException e) {
                throw new IOException(e);
            }
        }

        private boolean next(Integer current) throws IOException, HiveException {
            if (this.keyFields == null) {
                byte tag = SMBMapJoinOperator.this.tagForAlias(this.alias);
                this.keyFields = SMBMapJoinOperator.this.joinKeys[tag];
                this.keyFieldOIs = SMBMapJoinOperator.this.joinKeysObjectInspectors[tag];
            }
            InspectableObject nextRow = this.segments[current].getNextRow();
            while (nextRow != null) {
                this.sinkOp.reset();
                if (this.keys[current] == null) {
                    this.keys[current.intValue()] = new ObjectPair();
                }
                this.forwardOp.process(nextRow.o, 0);
                nextRow = this.sinkOp.getResult();
                if (nextRow.o != null) {
                    this.keys[current].setFirst(JoinUtil.computeKeys(nextRow.o, this.keyFields, this.keyFieldOIs));
                    this.keys[current].setSecond(nextRow);
                    return true;
                }
                nextRow = this.segments[current].getNextRow();
            }
            this.keys[current.intValue()] = null;
            return false;
        }
    }
}

