/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.AbstractFileMergeOperator;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcFileKeyWrapper;
import org.apache.hadoop.hive.ql.io.orc.OrcFileValueWrapper;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OrcFileMergeDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.shims.CombineHiveKey;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcFileMergeOperator
extends AbstractFileMergeOperator<OrcFileMergeDesc> {
    public static final Logger LOG = LoggerFactory.getLogger((String)"OrcFileMergeOperator");
    CompressionKind compression = null;
    int compressBuffSize = 0;
    OrcFile.Version version;
    int columnCount = 0;
    int rowIndexStride = 0;
    Writer outWriter;
    Path prevPath;
    private Reader reader;
    private FSDataInputStream fdis;

    protected OrcFileMergeOperator() {
    }

    public OrcFileMergeOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        Object[] keyValue = (Object[])row;
        this.processKeyValuePairs(keyValue[0], keyValue[1]);
    }

    private void processKeyValuePairs(Object key, Object value) throws HiveException {
        String filePath;
        block45: {
            OrcFileValueWrapper v;
            OrcFileKeyWrapper k;
            block42: {
                block43: {
                    block39: {
                        block40: {
                            filePath = "";
                            k = key instanceof CombineHiveKey ? (OrcFileKeyWrapper)((CombineHiveKey)key).getKey() : (OrcFileKeyWrapper)key;
                            if (!k.isIncompatFile()) break block39;
                            LOG.warn("Incompatible ORC file merge! Stripe statistics is missing. " + k.getInputPath());
                            this.incompatFileSet.add(k.getInputPath());
                            if (!this.exception) break block40;
                            this.closeOp(true);
                        }
                        if (this.fdis != null) {
                            try {
                                this.fdis.close();
                            }
                            catch (IOException e) {
                                throw new HiveException(String.format("Unable to close file %s", filePath), e);
                            }
                            finally {
                                this.fdis = null;
                            }
                        }
                        return;
                    }
                    filePath = k.getInputPath().toUri().getPath();
                    this.fixTmpPath(k.getInputPath().getParent());
                    v = (OrcFileValueWrapper)value;
                    if (this.prevPath == null) {
                        this.prevPath = k.getInputPath();
                        this.reader = OrcFile.createReader(this.fs, k.getInputPath());
                        if (this.isLogInfoEnabled) {
                            LOG.info("ORC merge file input path: " + k.getInputPath());
                        }
                    }
                    if (this.outWriter == null) {
                        this.compression = k.getCompression();
                        this.compressBuffSize = k.getCompressBufferSize();
                        this.version = k.getVersion();
                        this.columnCount = k.getTypes().get(0).getSubtypesCount();
                        this.rowIndexStride = k.getRowIndexStride();
                        OrcFile.WriterOptions options = OrcFile.writerOptions((Configuration)this.jc).compress(this.compression).version(this.version).rowIndexStride(this.rowIndexStride).inspector(this.reader.getObjectInspector());
                        if (this.compression != CompressionKind.NONE) {
                            options.bufferSize(this.compressBuffSize);
                        }
                        this.outWriter = OrcFile.createWriter(this.outPath, options);
                        if (this.isLogDebugEnabled) {
                            LOG.info("ORC merge file output path: " + this.outPath);
                        }
                    }
                    if (this.checkCompatibility(k)) break block42;
                    this.incompatFileSet.add(k.getInputPath());
                    if (!this.exception) break block43;
                    this.closeOp(true);
                }
                if (this.fdis != null) {
                    try {
                        this.fdis.close();
                    }
                    catch (IOException e) {
                        throw new HiveException(String.format("Unable to close file %s", filePath), e);
                    }
                    finally {
                        this.fdis = null;
                    }
                }
                return;
            }
            try {
                if (!k.getInputPath().equals((Object)this.prevPath)) {
                    this.reader = OrcFile.createReader(this.fs, k.getInputPath());
                }
                byte[] buffer = new byte[(int)v.getStripeInformation().getLength()];
                this.fdis = this.fs.open(k.getInputPath());
                this.fdis.readFully(v.getStripeInformation().getOffset(), buffer, 0, (int)v.getStripeInformation().getLength());
                this.outWriter.appendStripe(buffer, 0, buffer.length, v.getStripeInformation(), v.getStripeStatistics());
                if (this.isLogInfoEnabled) {
                    LOG.info("Merged stripe from file " + k.getInputPath() + " [ offset : " + v.getStripeInformation().getOffset() + " length: " + v.getStripeInformation().getLength() + " row: " + v.getStripeStatistics().getColStats(0).getNumberOfValues() + " ]");
                }
                if (v.isLastStripeInFile()) {
                    this.outWriter.appendUserMetadata(v.getUserMetadata());
                }
                if (!this.exception) break block45;
            }
            catch (Throwable e) {
                try {
                    this.exception = true;
                    LOG.error("Closing operator..Exception: " + ExceptionUtils.getStackTrace(e));
                    throw new HiveException(e);
                }
                catch (Throwable throwable) {
                    if (this.exception) {
                        this.closeOp(true);
                    }
                    if (this.fdis != null) {
                        try {
                            this.fdis.close();
                        }
                        catch (IOException e2) {
                            throw new HiveException(String.format("Unable to close file %s", filePath), e2);
                        }
                        finally {
                            this.fdis = null;
                        }
                    }
                    throw throwable;
                }
            }
            this.closeOp(true);
        }
        if (this.fdis != null) {
            try {
                this.fdis.close();
            }
            catch (IOException e) {
                throw new HiveException(String.format("Unable to close file %s", filePath), e);
            }
            finally {
                this.fdis = null;
            }
        }
    }

    private boolean checkCompatibility(OrcFileKeyWrapper k) {
        if (k.getTypes().get(0).getSubtypesCount() != this.columnCount) {
            LOG.warn("Incompatible ORC file merge! Column counts mismatch for " + k.getInputPath());
            return false;
        }
        if (!k.getCompression().equals((Object)this.compression)) {
            LOG.warn("Incompatible ORC file merge! Compression codec mismatch for " + k.getInputPath());
            return false;
        }
        if (k.getCompressBufferSize() != this.compressBuffSize) {
            LOG.warn("Incompatible ORC file merge! Compression buffer size mismatch for " + k.getInputPath());
            return false;
        }
        if (!k.getVersion().equals((Object)this.version)) {
            LOG.warn("Incompatible ORC file merge! Version mismatch for " + k.getInputPath());
            return false;
        }
        if (k.getRowIndexStride() != this.rowIndexStride) {
            LOG.warn("Incompatible ORC file merge! Row index stride mismatch for " + k.getInputPath());
            return false;
        }
        return true;
    }

    @Override
    public OperatorType getType() {
        return OperatorType.ORCFILEMERGE;
    }

    @Override
    public String getName() {
        return OrcFileMergeOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "OFM";
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (this.outWriter == null) {
            return;
        }
        try {
            if (this.fdis != null) {
                this.fdis.close();
                this.fdis = null;
            }
            this.outWriter.close();
            this.outWriter = null;
        }
        catch (Exception e) {
            throw new HiveException("Unable to close OrcFileMergeOperator", e);
        }
        super.closeOp(abort);
    }
}

