/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.terasort;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.util.Progressable;

public class TeraOutputFormatWithCRC
extends TextOutputFormat<Text, Text> {
    static final String FINAL_SYNC_ATTRIBUTE = "terasort.final.sync";

    public static void setFinalSync(JobConf conf, boolean newValue) {
        conf.setBoolean(FINAL_SYNC_ATTRIBUTE, newValue);
    }

    public static boolean getFinalSync(JobConf conf) {
        return conf.getBoolean(FINAL_SYNC_ATTRIBUTE, false);
    }

    public RecordWriter<Text, Text> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        Path dir = TeraOutputFormatWithCRC.getWorkOutputPath((JobConf)job);
        FileSystem fs = dir.getFileSystem((Configuration)job);
        FSDataOutputStream fileOut = fs.create(new Path(dir, name), progress);
        return new TeraRecordWriter((DataOutputStream)fileOut, job);
    }

    static class TeraRecordWriter
    extends TextOutputFormat.LineRecordWriter<Text, Text> {
        private static final byte[] newLine = "\r\n".getBytes();
        private boolean finalSync = false;
        private String space = "";
        private int CRC_LEN = 20;

        public TeraRecordWriter(DataOutputStream out, JobConf conf) {
            super(out);
            this.finalSync = TeraOutputFormatWithCRC.getFinalSync(conf);
        }

        public synchronized void write(Text key, Text value) throws IOException {
            this.out.write(key.getBytes(), 0, key.getLength());
            StringBuffer spaces = new StringBuffer(this.CRC_LEN);
            byte[] valueToCksum = value.toString().getBytes();
            CRC32 checksum = new CRC32();
            checksum.update(key.toString().getBytes());
            checksum.update(valueToCksum, 0, valueToCksum.length);
            long cksum = checksum.getValue();
            byte[] cksum_bytes = Long.toString(cksum).getBytes();
            int padspaces = this.CRC_LEN - cksum_bytes.length;
            if (padspaces > 0) {
                for (int i = 0; i < padspaces; ++i) {
                    spaces.append(" ");
                }
                value.append(spaces.toString().getBytes(), 0, spaces.toString().getBytes().length);
            }
            value.append(cksum_bytes, 0, cksum_bytes.length);
            this.out.write(value.getBytes());
            this.out.write(newLine, 0, newLine.length);
        }

        public void close() throws IOException {
            if (this.finalSync) {
                ((FSDataOutputStream)this.out).sync();
            }
            super.close(null);
        }
    }
}

