/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tracing;

import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.tracing.SpanReceiverInfo;
import org.apache.hadoop.tracing.TraceUtils;
import org.apache.htrace.HTraceConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class TestTraceUtils {
    @Test
    public void testWrappedHadoopConf() {
        String key = "sampler";
        String value = "ProbabilitySampler";
        Configuration conf = new Configuration();
        conf.set("hadoop.htrace." + key, value);
        HTraceConfiguration wrapped = TraceUtils.wrapHadoopConf((Configuration)conf);
        Assert.assertEquals((Object)value, (Object)wrapped.get(key));
    }

    @Test
    public void testExtraConfig() {
        String key = "test.extra.config";
        String oldValue = "old value";
        String newValue = "new value";
        Configuration conf = new Configuration();
        conf.set("hadoop.htrace." + key, oldValue);
        LinkedList<SpanReceiverInfo.ConfigurationPair> extraConfig = new LinkedList<SpanReceiverInfo.ConfigurationPair>();
        extraConfig.add(new SpanReceiverInfo.ConfigurationPair(key, newValue));
        HTraceConfiguration wrapped = TraceUtils.wrapHadoopConf((Configuration)conf, extraConfig);
        Assert.assertEquals((Object)newValue, (Object)wrapped.get(key));
    }
}

