/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Test;

public abstract class FCStatisticsBaseTest {
    protected static int blockSize = 512;
    protected static int numBlocks = 1;
    protected final FileContextTestHelper fileContextTestHelper = new FileContextTestHelper();
    protected static FileContext fc = null;

    @Test(timeout=60000L)
    public void testStatisticsOperations() throws Exception {
        final FileSystem.Statistics stats = new FileSystem.Statistics("file");
        Assert.assertEquals((long)0L, (long)stats.getBytesRead());
        Assert.assertEquals((long)0L, (long)stats.getBytesWritten());
        Assert.assertEquals((long)0L, (long)stats.getWriteOps());
        Assert.assertEquals((long)0L, (long)stats.getNumWriteOps());
        stats.incrementBytesWritten(1000L);
        Assert.assertEquals((long)1000L, (long)stats.getBytesWritten());
        Assert.assertEquals((long)0L, (long)stats.getWriteOps());
        Assert.assertEquals((long)0L, (long)stats.getNumWriteOps());
        stats.incrementWriteOps(123);
        Assert.assertEquals((long)123L, (long)stats.getWriteOps());
        Assert.assertEquals((long)123L, (long)stats.getNumWriteOps());
        Thread thread = new Thread(){

            @Override
            public void run() {
                stats.incrementWriteOps(1);
            }
        };
        thread.start();
        Uninterruptibles.joinUninterruptibly((Thread)thread);
        Assert.assertEquals((long)124L, (long)stats.getWriteOps());
        Assert.assertEquals((long)124L, (long)stats.getNumWriteOps());
        FileSystem.Statistics stats2 = new FileSystem.Statistics(stats);
        stats.reset();
        Assert.assertEquals((long)0L, (long)stats.getWriteOps());
        Assert.assertEquals((long)0L, (long)stats.getNumWriteOps());
        Assert.assertEquals((long)0L, (long)stats.getBytesWritten());
        Assert.assertEquals((long)0L, (long)stats.getBytesRead());
        Assert.assertEquals((long)124L, (long)stats2.getWriteOps());
        Assert.assertEquals((long)124L, (long)stats2.getNumWriteOps());
        Assert.assertEquals((long)1000L, (long)stats2.getBytesWritten());
        Assert.assertEquals((long)0L, (long)stats2.getBytesRead());
    }

    @Test
    public void testStatistics() throws IOException, URISyntaxException {
        URI fsUri = this.getFsUri();
        FileSystem.Statistics stats = FileContext.getStatistics((URI)fsUri);
        Assert.assertEquals((long)0L, (long)stats.getBytesRead());
        Path filePath = this.fileContextTestHelper.getTestRootPath(fc, "file1");
        FileContextTestHelper.createFile(fc, filePath, numBlocks, blockSize);
        Assert.assertEquals((long)0L, (long)stats.getBytesRead());
        this.verifyWrittenBytes(stats);
        FSDataInputStream fstr = fc.open(filePath);
        byte[] buf = new byte[blockSize];
        int bytesRead = fstr.read(buf, 0, blockSize);
        fstr.read(0L, buf, 0, blockSize);
        Assert.assertEquals((long)blockSize, (long)bytesRead);
        this.verifyReadBytes(stats);
        this.verifyWrittenBytes(stats);
        this.verifyReadBytes(FileContext.getStatistics((URI)this.getFsUri()));
        Map statsMap = FileContext.getAllStatistics();
        URI exactUri = this.getSchemeAuthorityUri();
        this.verifyWrittenBytes((FileSystem.Statistics)statsMap.get(exactUri));
        fc.delete(filePath, true);
    }

    protected abstract void verifyReadBytes(FileSystem.Statistics var1);

    protected abstract void verifyWrittenBytes(FileSystem.Statistics var1);

    protected abstract URI getFsUri();

    protected URI getSchemeAuthorityUri() {
        URI uri = this.getFsUri();
        String SchemeAuthString = uri.getScheme() + "://";
        SchemeAuthString = uri.getAuthority() == null ? SchemeAuthString + "/" : SchemeAuthString + uri.getAuthority();
        return URI.create(SchemeAuthString);
    }
}

