/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.kite.policy;

import java.util.Arrays;
import org.apache.flume.Context;
import org.apache.flume.sink.kite.DatasetSinkConstants;
import org.apache.flume.sink.kite.policy.FailurePolicy;
import org.apache.flume.sink.kite.policy.RetryPolicy;
import org.apache.flume.sink.kite.policy.SavePolicy;

public class FailurePolicyFactory {
    public FailurePolicy newPolicy(Context config) {
        FailurePolicy policy;
        String policyType = config.getString("kite.failurePolicy", "retry");
        if (policyType.equals("retry")) {
            policy = new RetryPolicy.Builder().build(config);
        } else if (policyType.equals("save")) {
            policy = new SavePolicy.Builder().build(config);
        } else {
            FailurePolicy.Builder builder;
            Class<?> c;
            try {
                c = Class.forName(policyType);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("FailurePolicy.Builder class " + policyType + " not found. Must set " + "kite.failurePolicy" + " to a class that implements FailurePolicy.Builder or to a builtin" + " policy: " + Arrays.toString(DatasetSinkConstants.AVAILABLE_POLICIES), ex);
            }
            if (c == null || !FailurePolicy.Builder.class.isAssignableFrom(c)) {
                throw new IllegalArgumentException("Class " + policyType + " does not" + " implement FailurePolicy.Builder. Must set " + "kite.failurePolicy" + " to a class that extends" + " FailurePolicy.Builder or to a builtin policy: " + Arrays.toString(DatasetSinkConstants.AVAILABLE_POLICIES));
            }
            Class<?> builderClass = c;
            try {
                builder = (FailurePolicy.Builder)builderClass.newInstance();
            }
            catch (InstantiationException ex) {
                throw new IllegalArgumentException("Can't instantiate class " + policyType + ". Must set " + "kite.failurePolicy" + " to a class" + " that extends FailurePolicy.Builder or to a builtin policy: " + Arrays.toString(DatasetSinkConstants.AVAILABLE_POLICIES), ex);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException("Can't instantiate class " + policyType + ". Must set " + "kite.failurePolicy" + " to a class" + " that extends FailurePolicy.Builder or to a builtin policy: " + Arrays.toString(DatasetSinkConstants.AVAILABLE_POLICIES), ex);
            }
            policy = builder.build(config);
        }
        return policy;
    }
}

