/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.metrics.prometheus;

import io.prometheus.client.CollectorRegistry;
import java.util.Properties;
import org.apache.zookeeper.metrics.MetricsProviderLifeCycleException;
import org.apache.zookeeper.metrics.prometheus.PrometheusMetricsProvider;
import org.junit.Assert;
import org.junit.Test;

public class PrometheusMetricsProviderConfigTest {
    @Test
    public void testInvalidPort() {
        Assert.assertThrows(MetricsProviderLifeCycleException.class, () -> {
            CollectorRegistry.defaultRegistry.clear();
            PrometheusMetricsProvider provider = new PrometheusMetricsProvider();
            Properties configuration = new Properties();
            configuration.setProperty("httpPort", "65536");
            configuration.setProperty("exportJvmInfo", "false");
            provider.configure(configuration);
            provider.start();
        });
    }

    @Test
    public void testInvalidAddr() {
        Assert.assertThrows(MetricsProviderLifeCycleException.class, () -> {
            CollectorRegistry.defaultRegistry.clear();
            PrometheusMetricsProvider provider = new PrometheusMetricsProvider();
            Properties configuration = new Properties();
            configuration.setProperty("httpHost", "master");
            provider.configure(configuration);
            provider.start();
        });
    }

    @Test
    public void testValidConfig() throws MetricsProviderLifeCycleException {
        CollectorRegistry.defaultRegistry.clear();
        PrometheusMetricsProvider provider = new PrometheusMetricsProvider();
        Properties configuration = new Properties();
        configuration.setProperty("httpHost", "0.0.0.0");
        configuration.setProperty("httpPort", "0");
        provider.configure(configuration);
        provider.start();
    }
}

