/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jute;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.TestCheckWriterReader;
import org.apache.jute.TestReader;
import org.apache.jute.TestWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BinaryInputArchiveTest {
    @Test
    public void testReadStringCheckLength() {
        byte[] buf = new byte[]{127, 127, 127, 127};
        ByteArrayInputStream is = new ByteArrayInputStream(buf);
        BinaryInputArchive ia = BinaryInputArchive.getArchive((InputStream)is);
        try {
            ia.readString("");
            Assertions.fail((String)"Should have thrown an IOException");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Unreasonable length = "), () -> "Not 'Unreasonable length' exception: " + e);
        }
    }

    private void checkWriterAndReader(TestWriter writer, TestReader reader) {
        TestCheckWriterReader.checkWriterAndReader(BinaryOutputArchive::getArchive, BinaryInputArchive::getArchive, writer, reader);
    }

    @Test
    public void testInt() {
        int expected = 4;
        String tag = "tag1";
        this.checkWriterAndReader(oa -> oa.writeInt(4, "tag1"), ia -> {
            int actual = ia.readInt("tag1");
            Assertions.assertEquals((int)4, (int)actual);
        });
    }

    @Test
    public void testBool() {
        boolean expected = false;
        String tag = "tag1";
        this.checkWriterAndReader(oa -> oa.writeBool(false, "tag1"), ia -> {
            boolean actual = ia.readBool("tag1");
            Assertions.assertEquals((Object)false, (Object)actual);
        });
    }

    @Test
    public void testString() {
        String expected = "hello";
        String tag = "tag1";
        this.checkWriterAndReader(oa -> oa.writeString("hello", "tag1"), ia -> {
            String actual = ia.readString("tag1");
            Assertions.assertEquals((Object)"hello", (Object)actual);
        });
    }

    @Test
    public void testFloat() {
        float expected = 3.14159f;
        String tag = "tag1";
        float delta = 1.0E-10f;
        this.checkWriterAndReader(oa -> oa.writeFloat(3.14159f, "tag1"), ia -> {
            float actual = ia.readFloat("tag1");
            Assertions.assertEquals((float)3.14159f, (float)actual, (float)1.0E-10f);
        });
    }

    @Test
    public void testDouble() {
        double expected = 3.14159f;
        String tag = "tag1";
        float delta = 1.0E-20f;
        this.checkWriterAndReader(oa -> oa.writeDouble((double)3.14159f, "tag1"), ia -> {
            double actual = ia.readDouble("tag1");
            Assertions.assertEquals((double)3.14159f, (double)actual, (double)1.0E-20f);
        });
    }

    @Test
    public void testBuffer() {
        byte[] expected = "hello-world".getBytes(StandardCharsets.UTF_8);
        String tag = "tag1";
        this.checkWriterAndReader(oa -> oa.writeBuffer(expected, "tag1"), ia -> {
            byte[] actual = ia.readBuffer("tag1");
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        });
    }

    @Test
    public void testReadStringForRecordsHavingLengthMoreThanMaxAllowedSize() {
        int maxBufferSize = 2000;
        int extraMaxBufferSize = 1025;
        int recordSize = maxBufferSize + extraMaxBufferSize + 100;
        BinaryInputArchive ia = this.getBinaryInputArchive(recordSize, maxBufferSize, extraMaxBufferSize);
        try {
            ia.readString("");
            Assertions.fail((String)"Should have thrown an IOException");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Unreasonable length = "), () -> "Not 'Unreasonable length' exception: " + e);
        }
    }

    @Test
    public void testReadStringForRecordsHavingLengthLessThanMaxAllowedSize() throws IOException {
        int maxBufferSize = 2000;
        int extraMaxBufferSize = 1025;
        int recordSize = maxBufferSize + extraMaxBufferSize - 100;
        BinaryInputArchive ia = this.getBinaryInputArchive(recordSize, maxBufferSize, extraMaxBufferSize);
        String s = ia.readString("");
        Assertions.assertNotNull((Object)s);
        Assertions.assertEquals((int)recordSize, (int)s.getBytes().length);
    }

    private BinaryInputArchive getBinaryInputArchive(int recordSize, int maxBufferSize, int extraMaxBufferSize) {
        byte[] data = this.getData(recordSize);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
        return new BinaryInputArchive((DataInput)dis, maxBufferSize, extraMaxBufferSize);
    }

    private byte[] getData(int recordSize) {
        ByteBuffer buf = ByteBuffer.allocate(recordSize + 4);
        buf.putInt(recordSize);
        byte[] bytes = new byte[recordSize];
        for (int i = 0; i < recordSize; ++i) {
            bytes[i] = 97;
        }
        buf.put(bytes);
        return buf.array();
    }
}

