/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.cartesianproduct;

import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.List;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductCombination;
import org.junit.Assert;
import org.junit.Test;

public class TestCartesianProductCombination {
    private void verifyCombination(CartesianProductCombination combination, int[] result, int taskId) {
        Assert.assertArrayEquals((int[])result, (int[])Ints.toArray((Collection)combination.getCombination()));
        Assert.assertEquals((long)taskId, (long)combination.getTaskId());
    }

    private void testCombinationTwoWayVertex0() {
        CartesianProductCombination combination = new CartesianProductCombination(new int[]{2, 3}, 0);
        combination.firstTaskWithFixedChunk(1);
        this.verifyCombination(combination, new int[]{1, 0}, 3);
        Assert.assertTrue((boolean)combination.nextTaskWithFixedChunk());
        this.verifyCombination(combination, new int[]{1, 1}, 4);
        Assert.assertTrue((boolean)combination.nextTaskWithFixedChunk());
        this.verifyCombination(combination, new int[]{1, 2}, 5);
        Assert.assertFalse((boolean)combination.nextTaskWithFixedChunk());
    }

    private void testCombinationTwoWayVertex1() {
        CartesianProductCombination combination = new CartesianProductCombination(new int[]{2, 3}, 1);
        combination.firstTaskWithFixedChunk(1);
        this.verifyCombination(combination, new int[]{0, 1}, 1);
        Assert.assertTrue((boolean)combination.nextTaskWithFixedChunk());
        this.verifyCombination(combination, new int[]{1, 1}, 4);
        Assert.assertFalse((boolean)combination.nextTaskWithFixedChunk());
    }

    private void testCombinationThreeWay() {
        CartesianProductCombination combination = new CartesianProductCombination(new int[]{2, 2, 2}, 1);
        combination.firstTaskWithFixedChunk(1);
        this.verifyCombination(combination, new int[]{0, 1, 0}, 2);
        Assert.assertTrue((boolean)combination.nextTaskWithFixedChunk());
        this.verifyCombination(combination, new int[]{0, 1, 1}, 3);
        Assert.assertTrue((boolean)combination.nextTaskWithFixedChunk());
        this.verifyCombination(combination, new int[]{1, 1, 0}, 6);
        Assert.assertTrue((boolean)combination.nextTaskWithFixedChunk());
        this.verifyCombination(combination, new int[]{1, 1, 1}, 7);
        Assert.assertFalse((boolean)combination.nextTaskWithFixedChunk());
    }

    @Test(timeout=5000L)
    public void testCombinationWithFixedPartition() {
        this.testCombinationTwoWayVertex0();
        this.testCombinationTwoWayVertex1();
        this.testCombinationThreeWay();
    }

    @Test(timeout=5000L)
    public void testCombination() {
        CartesianProductCombination combination = new CartesianProductCombination(new int[]{2, 3});
        List list = combination.getCombination();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (i == 0 && j == 0) {
                    combination.firstTask();
                } else {
                    Assert.assertTrue((boolean)combination.nextTask());
                }
                Assert.assertTrue(((Integer)list.get(0) == i ? 1 : 0) != 0);
                Assert.assertTrue(((Integer)list.get(1) == j ? 1 : 0) != 0);
            }
        }
        Assert.assertFalse((boolean)combination.nextTask());
    }

    @Test(timeout=5000L)
    public void testFromTaskId() {
        for (int i = 0; i < 6; ++i) {
            List list = CartesianProductCombination.fromTaskId((int[])new int[]{2, 3}, (int)i).getCombination();
            Assert.assertTrue(((Integer)list.get(0) == i / 3 ? 1 : 0) != 0);
            Assert.assertTrue(((Integer)list.get(1) == i % 3 ? 1 : 0) != 0);
        }
    }

    @Test(timeout=5000L)
    public void testRejectZero() {
        int[] numChunk = new int[]{0, 1};
        try {
            new CartesianProductCombination(numChunk);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

