/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.testutils;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

public class KVDataGen {
    static Random rnd = new Random();

    public static List<KVPair> generateTestData(boolean repeatKeys) {
        return KVDataGen.generateTestData(true, rnd.nextInt(100));
    }

    public static List<KVPair> generateTestData(boolean sorted, int repeatCount) {
        return KVDataGen.generateTestDataOfKeySize(sorted, 5, repeatCount);
    }

    public static List<KVPair> generateTestDataOfKeySize(boolean sorted, int keys, int repeatCount) {
        LinkedList<KVPair> data = new LinkedList<KVPair>();
        Random rnd = new Random();
        KVPair kvp = null;
        for (int i = 0; i < keys; ++i) {
            String keyStr = sorted ? "key" + i : rnd.nextLong() + "key" + i;
            Text key = new Text(keyStr);
            IntWritable value = new IntWritable(i + repeatCount);
            kvp = new KVPair(key, value);
            data.add(kvp);
            if (repeatCount <= 0 || i % 2 != 0) continue;
            int count = rnd.nextInt(5);
            for (int j = 0; j < count; ++j) {
                ++repeatCount;
                value.set(i + rnd.nextInt());
                kvp = new KVPair(key, value);
                data.add(kvp);
            }
        }
        if (repeatCount > 0 && kvp != null) {
            data.add(kvp);
            data.add(kvp);
        }
        return data;
    }

    public static class KVPair {
        private Text key;
        private IntWritable value;

        public KVPair(Text key, IntWritable value) {
            this.key = key;
            this.value = value;
        }

        public Text getKey() {
            return this.key;
        }

        public IntWritable getvalue() {
            return this.value;
        }
    }
}

