/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.task;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.TezExecutors;
import org.apache.tez.common.TezSharedExecutor;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.FileSystemCounter;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.TezReflectionException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.hadoop.shim.DefaultHadoopShim;
import org.apache.tez.hadoop.shim.HadoopShim;
import org.apache.tez.runtime.LogicalIOProcessorRuntimeTask;
import org.apache.tez.runtime.api.ExecutionContext;
import org.apache.tez.runtime.api.ObjectRegistry;
import org.apache.tez.runtime.api.TaskFailureType;
import org.apache.tez.runtime.api.impl.ExecutionContextImpl;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.runtime.common.resources.ScalingAllocator;
import org.apache.tez.runtime.internals.api.TaskReporterInterface;
import org.apache.tez.runtime.task.EndReason;
import org.apache.tez.runtime.task.TaskExecutionTestHelpers;
import org.apache.tez.runtime.task.TaskReporter;
import org.apache.tez.runtime.task.TaskRunner2Callable;
import org.apache.tez.runtime.task.TaskRunner2Result;
import org.apache.tez.runtime.task.TezTaskRunner2;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTaskExecution2 {
    private static final Logger LOG = LoggerFactory.getLogger(TestTaskExecution2.class);
    private static final Configuration defaultConf = new Configuration();
    private static final FileSystem localFs;
    private static final Path workDir;
    private static final String FAILURE_START_STRING = "Error while running task ( failure )";
    private static final String KILL_START_STRING = "Error while running task ( kill )";
    private static final ExecutorService taskExecutor;

    @Before
    public void reset() {
        TaskExecutionTestHelpers.TestProcessor.reset();
    }

    @AfterClass
    public static void shutdown() {
        taskExecutor.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testSingleSuccessfulTask() throws IOException, InterruptedException, TezException, ExecutionException {
        ListeningExecutorService executor = null;
        try {
            ExecutorService rawExecutor = Executors.newFixedThreadPool(1);
            executor = MoreExecutors.listeningDecorator((ExecutorService)rawExecutor);
            ApplicationId appId = ApplicationId.newInstance((long)10000L, (int)1);
            TaskExecutionTestHelpers.TezTaskUmbilicalForTest umbilical = new TaskExecutionTestHelpers.TezTaskUmbilicalForTest();
            TaskReporter taskReporter = TaskExecutionTestHelpers.createTaskReporter(appId, umbilical);
            TezTaskRunner2 taskRunner = this.createTaskRunner(appId, umbilical, taskReporter, executor, TaskExecutionTestHelpers.TestProcessor.CONF_EMPTY);
            Future<TaskRunner2Result> taskRunnerFuture = taskExecutor.submit(new TaskRunnerCallable2ForTest(taskRunner));
            TaskExecutionTestHelpers.TestProcessor.signal();
            TaskRunner2Result result = taskRunnerFuture.get();
            this.verifyTaskRunnerResult(result, EndReason.SUCCESS, null, false, null);
            Assert.assertNull((Object)taskReporter.currentCallable);
            umbilical.verifyTaskSuccessEvent();
            Assert.assertFalse((boolean)TaskExecutionTestHelpers.TestProcessor.wasAborted());
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testMultipleSuccessfulTasks() throws IOException, InterruptedException, TezException, ExecutionException {
        ListeningExecutorService executor = null;
        try {
            ExecutorService rawExecutor = Executors.newFixedThreadPool(1);
            executor = MoreExecutors.listeningDecorator((ExecutorService)rawExecutor);
            ApplicationId appId = ApplicationId.newInstance((long)10000L, (int)1);
            TaskExecutionTestHelpers.TezTaskUmbilicalForTest umbilical = new TaskExecutionTestHelpers.TezTaskUmbilicalForTest();
            TaskReporter taskReporter = TaskExecutionTestHelpers.createTaskReporter(appId, umbilical);
            TezTaskRunner2 taskRunner = this.createTaskRunner(appId, umbilical, taskReporter, executor, TaskExecutionTestHelpers.TestProcessor.CONF_EMPTY, true);
            LogicalIOProcessorRuntimeTask runtimeTask = taskRunner.task;
            Future<TaskRunner2Result> taskRunnerFuture = taskExecutor.submit(new TaskRunnerCallable2ForTest(taskRunner));
            TaskExecutionTestHelpers.TestProcessor.signal();
            TaskRunner2Result result = taskRunnerFuture.get();
            this.verifyTaskRunnerResult(result, EndReason.SUCCESS, null, false, null);
            Assert.assertNull((Object)taskReporter.currentCallable);
            umbilical.verifyTaskSuccessEvent();
            Assert.assertFalse((boolean)TaskExecutionTestHelpers.TestProcessor.wasAborted());
            umbilical.resetTrackedEvents();
            TezCounters tezCounters = runtimeTask.getCounters();
            this.verifySysCounters(tezCounters, 5, 5);
            taskRunner = this.createTaskRunner(appId, umbilical, taskReporter, executor, TaskExecutionTestHelpers.TestProcessor.CONF_EMPTY, false);
            runtimeTask = taskRunner.task;
            taskRunnerFuture = taskExecutor.submit(new TaskRunnerCallable2ForTest(taskRunner));
            TaskExecutionTestHelpers.TestProcessor.signal();
            result = taskRunnerFuture.get();
            this.verifyTaskRunnerResult(result, EndReason.SUCCESS, null, false, null);
            Assert.assertNull((Object)taskReporter.currentCallable);
            umbilical.verifyTaskSuccessEvent();
            Assert.assertFalse((boolean)TaskExecutionTestHelpers.TestProcessor.wasAborted());
            tezCounters = runtimeTask.getCounters();
            this.verifySysCounters(tezCounters, -1, -1);
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testFailedTaskTezException() throws IOException, InterruptedException, TezException, ExecutionException {
        ListeningExecutorService executor = null;
        try {
            ExecutorService rawExecutor = Executors.newFixedThreadPool(1);
            executor = MoreExecutors.listeningDecorator((ExecutorService)rawExecutor);
            ApplicationId appId = ApplicationId.newInstance((long)10000L, (int)1);
            TaskExecutionTestHelpers.TezTaskUmbilicalForTest umbilical = new TaskExecutionTestHelpers.TezTaskUmbilicalForTest();
            TaskReporter taskReporter = TaskExecutionTestHelpers.createTaskReporter(appId, umbilical);
            TezTaskRunner2 taskRunner = this.createTaskRunner(appId, umbilical, taskReporter, executor, TaskExecutionTestHelpers.TestProcessor.CONF_THROW_TEZ_EXCEPTION);
            Future<TaskRunner2Result> taskRunnerFuture = taskExecutor.submit(new TaskRunnerCallable2ForTest(taskRunner));
            TaskExecutionTestHelpers.TestProcessor.awaitStart();
            TaskExecutionTestHelpers.TestProcessor.signal();
            TaskRunner2Result result = taskRunnerFuture.get();
            this.verifyTaskRunnerResult(result, EndReason.TASK_ERROR, (Throwable)TaskExecutionTestHelpers.createProcessorTezException(), false, TaskFailureType.NON_FATAL);
            Assert.assertNull((Object)taskReporter.currentCallable);
            umbilical.verifyTaskFailedEvent(FAILURE_START_STRING, TezException.class.getName() + ": " + TezException.class.getSimpleName());
            Assert.assertFalse((boolean)TaskExecutionTestHelpers.TestProcessor.wasAborted());
            Assert.assertTrue((taskRunner.task.getCounters().countCounters() != 0 ? 1 : 0) != 0);
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testFailedTask2() throws IOException, InterruptedException, TezException, ExecutionException {
        ListeningExecutorService executor = null;
        try {
            ExecutorService rawExecutor = Executors.newFixedThreadPool(1);
            executor = MoreExecutors.listeningDecorator((ExecutorService)rawExecutor);
            ApplicationId appId = ApplicationId.newInstance((long)10000L, (int)1);
            TaskExecutionTestHelpers.TezTaskUmbilicalForTest umbilical = new TaskExecutionTestHelpers.TezTaskUmbilicalForTest();
            TaskReporter taskReporter = TaskExecutionTestHelpers.createTaskReporter(appId, umbilical);
            TezTaskRunner2 taskRunner = this.createTaskRunner(appId, umbilical, taskReporter, executor, "NotExitedProcessor", TaskExecutionTestHelpers.TestProcessor.CONF_EMPTY, false, true);
            Future<TaskRunner2Result> taskRunnerFuture = taskExecutor.submit(new TaskRunnerCallable2ForTest(taskRunner));
            TaskRunner2Result result = taskRunnerFuture.get();
            this.verifyTaskRunnerResult(result, EndReason.TASK_ERROR, (Throwable)new TezReflectionException("TezReflectionException"), false, TaskFailureType.NON_FATAL);
            Assert.assertNull((Object)taskReporter.currentCallable);
            umbilical.verifyTaskFailedEvent(FAILURE_START_STRING, ":org.apache.tez.dag.api.TezReflectionException: Unable to load class: NotExitedProcessor");
            Assert.assertFalse((boolean)TaskExecutionTestHelpers.TestProcessor.wasAborted());
            Assert.assertTrue((taskRunner.task.getCounters().countCounters() != 0 ? 1 : 0) != 0);
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testFailedTaskIOException() throws IOException, InterruptedException, TezException, ExecutionException {
        ListeningExecutorService executor = null;
        try {
            ExecutorService rawExecutor = Executors.newFixedThreadPool(1);
            executor = MoreExecutors.listeningDecorator((ExecutorService)rawExecutor);
            ApplicationId appId = ApplicationId.newInstance((long)10000L, (int)1);
            TaskExecutionTestHelpers.TezTaskUmbilicalForTest umbilical = new TaskExecutionTestHelpers.TezTaskUmbilicalForTest();
            TaskReporter taskReporter = TaskExecutionTestHelpers.createTaskReporter(appId, umbilical);
            TezTaskRunner2 taskRunner = this.createTaskRunner(appId, umbilical, taskReporter, executor, TaskExecutionTestHelpers.TestProcessor.CONF_THROW_IO_EXCEPTION);
            Future<TaskRunner2Result> taskRunnerFuture = taskExecutor.submit(new TaskRunnerCallable2ForTest(taskRunner));
            TaskExecutionTestHelpers.TestProcessor.awaitStart();
            TaskExecutionTestHelpers.TestProcessor.signal();
            TaskRunner2Result result = taskRunnerFuture.get();
            this.verifyTaskRunnerResult(result, EndReason.TASK_ERROR, TaskExecutionTestHelpers.createProcessorIOException(), false, TaskFailureType.NON_FATAL);
            Assert.assertNull((Object)taskReporter.currentCallable);
            umbilical.verifyTaskFailedEvent(FAILURE_START_STRING, IOException.class.getName() + ": " + IOException.class.getSimpleName());
            Assert.assertFalse((boolean)TaskExecutionTestHelpers.TestProcessor.wasAborted());
            Assert.assertTrue((taskRunner.task.getCounters().countCounters() != 0 ? 1 : 0) != 0);
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testIgnoreErrorsDuringFailure() throws IOException, InterruptedException, TezException, ExecutionException {
        ListeningExecutorService executor = null;
        try {
            ExecutorService rawExecutor = Executors.newFixedThreadPool(1);
            executor = MoreExecutors.listeningDecorator((ExecutorService)rawExecutor);
            ApplicationId appId = ApplicationId.newInstance((long)10000L, (int)1);
            TaskExecutionTestHelpers.TezTaskUmbilicalForTest umbilical = new TaskExecutionTestHelpers.TezTaskUmbilicalForTest();
            TaskReporter taskReporter = new TaskReporter(umbilical, 100L, 1000L, 100, new AtomicLong(0L), TaskExecutionTestHelpers.createContainerId(appId).toString()){

                protected boolean isShuttingDown() {
                    return true;
                }
            };
            TezTaskRunner2 taskRunner = this.createTaskRunner(appId, umbilical, taskReporter, executor, TaskExecutionTestHelpers.TestProcessor.CONF_THROW_IO_EXCEPTION);
            taskExecutor.submit(new TaskRunnerCallable2ForTest(taskRunner));
            TaskExecutionTestHelpers.TestProcessor.awaitStart();
            TaskExecutionTestHelpers.TestProcessor.signal();
            umbilical.verifyNoCompletionEvents();
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testHeartbeatException() throws IOException, InterruptedException, TezException, ExecutionException {
        ListeningExecutorService executor = null;
        try {
            ExecutorService rawExecutor = Executors.newFixedThreadPool(1);
            executor = MoreExecutors.listeningDecorator((ExecutorService)rawExecutor);
            ApplicationId appId = ApplicationId.newInstance((long)10000L, (int)1);
            TaskExecutionTestHelpers.TezTaskUmbilicalForTest umbilical = new TaskExecutionTestHelpers.TezTaskUmbilicalForTest();
            TaskReporter taskReporter = TaskExecutionTestHelpers.createTaskReporter(appId, umbilical);
            TezTaskRunner2 taskRunner = this.createTaskRunner(appId, umbilical, taskReporter, executor, TaskExecutionTestHelpers.TestProcessor.CONF_EMPTY);
            Future<TaskRunner2Result> taskRunnerFuture = taskExecutor.submit(new TaskRunnerCallable2ForTest(taskRunner));
            TaskExecutionTestHelpers.TestProcessor.awaitStart();
            umbilical.signalThrowException();
            umbilical.awaitRegisteredEvent();
            TaskRunner2Result result = taskRunnerFuture.get();
            this.verifyTaskRunnerResult(result, EndReason.COMMUNICATION_FAILURE, new IOException("IOException"), "HeartbeatException", false, TaskFailureType.NON_FATAL);
            TaskExecutionTestHelpers.TestProcessor.awaitCompletion();
            Assert.assertTrue((boolean)TaskExecutionTestHelpers.TestProcessor.wasInterrupted());
            Assert.assertNull((Object)taskReporter.currentCallable);
            umbilical.verifyNoCompletionEvents();
            Assert.assertTrue((boolean)TaskExecutionTestHelpers.TestProcessor.wasAborted());
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testHeartbeatShouldDie() throws IOException, InterruptedException, TezException, ExecutionException {
        ListeningExecutorService executor = null;
        try {
            ExecutorService rawExecutor = Executors.newFixedThreadPool(1);
            executor = MoreExecutors.listeningDecorator((ExecutorService)rawExecutor);
            ApplicationId appId = ApplicationId.newInstance((long)10000L, (int)1);
            TaskExecutionTestHelpers.TezTaskUmbilicalForTest umbilical = new TaskExecutionTestHelpers.TezTaskUmbilicalForTest();
            TaskReporter taskReporter = TaskExecutionTestHelpers.createTaskReporter(appId, umbilical);
            TezTaskRunner2 taskRunner = this.createTaskRunner(appId, umbilical, taskReporter, executor, TaskExecutionTestHelpers.TestProcessor.CONF_EMPTY);
            Future<TaskRunner2Result> taskRunnerFuture = taskExecutor.submit(new TaskRunnerCallable2ForTest(taskRunner));
            TaskExecutionTestHelpers.TestProcessor.awaitStart();
            umbilical.signalSendShouldDie();
            umbilical.awaitRegisteredEvent();
            TaskRunner2Result result = taskRunnerFuture.get();
            this.verifyTaskRunnerResult(result, EndReason.CONTAINER_STOP_REQUESTED, null, true, null);
            TaskExecutionTestHelpers.TestProcessor.awaitCompletion();
            Assert.assertTrue((boolean)TaskExecutionTestHelpers.TestProcessor.wasInterrupted());
            Assert.assertNull((Object)taskReporter.currentCallable);
            umbilical.verifyNoCompletionEvents();
            Assert.assertTrue((boolean)TaskExecutionTestHelpers.TestProcessor.wasAborted());
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testSignalDeprecatedFatalErrorAndLoop() throws IOException, InterruptedException, TezException, ExecutionException {
        ListeningExecutorService executor = null;
        try {
            ExecutorService rawExecutor = Executors.newFixedThreadPool(1);
            executor = MoreExecutors.listeningDecorator((ExecutorService)rawExecutor);
            ApplicationId appId = ApplicationId.newInstance((long)10000L, (int)1);
            TaskExecutionTestHelpers.TezTaskUmbilicalForTest umbilical = new TaskExecutionTestHelpers.TezTaskUmbilicalForTest();
            TaskReporter taskReporter = TaskExecutionTestHelpers.createTaskReporter(appId, umbilical);
            TezTaskRunner2 taskRunner = this.createTaskRunner(appId, umbilical, taskReporter, executor, TaskExecutionTestHelpers.TestProcessor.CONF_SIGNAL_DEPRECATEDFATAL_AND_LOOP);
            Future<TaskRunner2Result> taskRunnerFuture = taskExecutor.submit(new TaskRunnerCallable2ForTest(taskRunner));
            TaskExecutionTestHelpers.TestProcessor.awaitStart();
            TaskExecutionTestHelpers.TestProcessor.signal();
            TaskExecutionTestHelpers.TestProcessor.awaitLoop();
            TaskRunner2Result result = taskRunnerFuture.get();
            this.verifyTaskRunnerResult(result, EndReason.TASK_ERROR, TaskExecutionTestHelpers.createProcessorIOException(), false, TaskFailureType.NON_FATAL);
            TaskExecutionTestHelpers.TestProcessor.awaitCompletion();
            Assert.assertTrue((boolean)TaskExecutionTestHelpers.TestProcessor.wasInterrupted());
            Assert.assertNull((Object)taskReporter.currentCallable);
            umbilical.verifyTaskFailedEvent(FAILURE_START_STRING, IOException.class.getName() + ": " + IOException.class.getSimpleName());
            Assert.assertTrue((boolean)TaskExecutionTestHelpers.TestProcessor.wasAborted());
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testSignalFatalAndThrow() throws IOException, InterruptedException, TezException, ExecutionException {
        ListeningExecutorService executor = null;
        try {
            ExecutorService rawExecutor = Executors.newFixedThreadPool(1);
            executor = MoreExecutors.listeningDecorator((ExecutorService)rawExecutor);
            ApplicationId appId = ApplicationId.newInstance((long)10000L, (int)1);
            TaskExecutionTestHelpers.TezTaskUmbilicalForTest umbilical = new TaskExecutionTestHelpers.TezTaskUmbilicalForTest();
            TaskReporter taskReporter = TaskExecutionTestHelpers.createTaskReporter(appId, umbilical);
            TezTaskRunner2 taskRunner = this.createTaskRunner(appId, umbilical, taskReporter, executor, TaskExecutionTestHelpers.TestProcessor.CONF_SIGNAL_FATAL_AND_THROW);
            Future<TaskRunner2Result> taskRunnerFuture = taskExecutor.submit(new TaskRunnerCallable2ForTest(taskRunner));
            TaskExecutionTestHelpers.TestProcessor.awaitStart();
            TaskExecutionTestHelpers.TestProcessor.signal();
            TaskRunner2Result result = taskRunnerFuture.get();
            this.verifyTaskRunnerResult(result, EndReason.TASK_ERROR, TaskExecutionTestHelpers.createProcessorIOException(), false, TaskFailureType.FATAL);
            TaskExecutionTestHelpers.TestProcessor.awaitCompletion();
            Assert.assertNull((Object)taskReporter.currentCallable);
            umbilical.verifyTaskFailedEvent(FAILURE_START_STRING, IOException.class.getName() + ": " + IOException.class.getSimpleName(), TaskFailureType.FATAL);
            Assert.assertTrue((boolean)TaskExecutionTestHelpers.TestProcessor.wasAborted());
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testSignalNonFatalAndThrow() throws IOException, InterruptedException, TezException, ExecutionException {
        ListeningExecutorService executor = null;
        try {
            ExecutorService rawExecutor = Executors.newFixedThreadPool(1);
            executor = MoreExecutors.listeningDecorator((ExecutorService)rawExecutor);
            ApplicationId appId = ApplicationId.newInstance((long)10000L, (int)1);
            TaskExecutionTestHelpers.TezTaskUmbilicalForTest umbilical = new TaskExecutionTestHelpers.TezTaskUmbilicalForTest();
            TaskReporter taskReporter = TaskExecutionTestHelpers.createTaskReporter(appId, umbilical);
            TezTaskRunner2 taskRunner = this.createTaskRunner(appId, umbilical, taskReporter, executor, TaskExecutionTestHelpers.TestProcessor.CONF_SIGNAL_NON_FATAL_AND_THROW);
            Future<TaskRunner2Result> taskRunnerFuture = taskExecutor.submit(new TaskRunnerCallable2ForTest(taskRunner));
            TaskExecutionTestHelpers.TestProcessor.awaitStart();
            TaskExecutionTestHelpers.TestProcessor.signal();
            TaskRunner2Result result = taskRunnerFuture.get();
            this.verifyTaskRunnerResult(result, EndReason.TASK_ERROR, TaskExecutionTestHelpers.createProcessorIOException(), false, TaskFailureType.NON_FATAL);
            TaskExecutionTestHelpers.TestProcessor.awaitCompletion();
            Assert.assertNull((Object)taskReporter.currentCallable);
            umbilical.verifyTaskFailedEvent(FAILURE_START_STRING, IOException.class.getName() + ": " + IOException.class.getSimpleName(), TaskFailureType.NON_FATAL);
            Assert.assertTrue((boolean)TaskExecutionTestHelpers.TestProcessor.wasAborted());
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testTaskSelfKill() throws IOException, InterruptedException, TezException, ExecutionException {
        ListeningExecutorService executor = null;
        try {
            ExecutorService rawExecutor = Executors.newFixedThreadPool(1);
            executor = MoreExecutors.listeningDecorator((ExecutorService)rawExecutor);
            ApplicationId appId = ApplicationId.newInstance((long)10000L, (int)1);
            TaskExecutionTestHelpers.TezTaskUmbilicalForTest umbilical = new TaskExecutionTestHelpers.TezTaskUmbilicalForTest();
            TaskReporter taskReporter = TaskExecutionTestHelpers.createTaskReporter(appId, umbilical);
            TezTaskRunner2 taskRunner = this.createTaskRunner(appId, umbilical, taskReporter, executor, TaskExecutionTestHelpers.TestProcessor.CONF_SELF_KILL_AND_COMPLETE);
            Future<TaskRunner2Result> taskRunnerFuture = taskExecutor.submit(new TaskRunnerCallable2ForTest(taskRunner));
            TaskExecutionTestHelpers.TestProcessor.awaitStart();
            TaskExecutionTestHelpers.TestProcessor.signal();
            TaskRunner2Result result = taskRunnerFuture.get();
            this.verifyTaskRunnerResult(result, EndReason.TASK_KILL_REQUEST, TaskExecutionTestHelpers.createProcessorIOException(), false, null);
            TaskExecutionTestHelpers.TestProcessor.awaitCompletion();
            Assert.assertNull((Object)taskReporter.currentCallable);
            umbilical.verifyTaskKilledEvent(KILL_START_STRING, IOException.class.getName() + ": " + IOException.class.getSimpleName());
            Assert.assertTrue((boolean)TaskExecutionTestHelpers.TestProcessor.wasAborted());
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testTaskKilled() throws IOException, InterruptedException, TezException, ExecutionException {
        ListeningExecutorService executor = null;
        try {
            ExecutorService rawExecutor = Executors.newFixedThreadPool(1);
            executor = MoreExecutors.listeningDecorator((ExecutorService)rawExecutor);
            ApplicationId appId = ApplicationId.newInstance((long)10000L, (int)1);
            TaskExecutionTestHelpers.TezTaskUmbilicalForTest umbilical = new TaskExecutionTestHelpers.TezTaskUmbilicalForTest();
            TaskReporter taskReporter = TaskExecutionTestHelpers.createTaskReporter(appId, umbilical);
            TezTaskRunner2 taskRunner = this.createTaskRunner(appId, umbilical, taskReporter, executor, TaskExecutionTestHelpers.TestProcessor.CONF_EMPTY);
            Future<TaskRunner2Result> taskRunnerFuture = taskExecutor.submit(new TaskRunnerCallable2ForTest(taskRunner));
            TaskExecutionTestHelpers.TestProcessor.awaitStart();
            taskRunner.killTask();
            TaskRunner2Result result = taskRunnerFuture.get();
            this.verifyTaskRunnerResult(result, EndReason.KILL_REQUESTED, null, false, null);
            TaskExecutionTestHelpers.TestProcessor.awaitCompletion();
            Assert.assertTrue((boolean)TaskExecutionTestHelpers.TestProcessor.wasInterrupted());
            Assert.assertNull((Object)taskReporter.currentCallable);
            umbilical.verifyNoCompletionEvents();
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testKilledAfterComplete() throws IOException, InterruptedException, TezException, ExecutionException {
        ListeningExecutorService executor = null;
        try {
            ExecutorService rawExecutor = Executors.newFixedThreadPool(1);
            executor = MoreExecutors.listeningDecorator((ExecutorService)rawExecutor);
            ApplicationId appId = ApplicationId.newInstance((long)10000L, (int)1);
            TaskExecutionTestHelpers.TezTaskUmbilicalForTest umbilical = new TaskExecutionTestHelpers.TezTaskUmbilicalForTest();
            TaskReporter taskReporter = TaskExecutionTestHelpers.createTaskReporter(appId, umbilical);
            TezTaskRunner2ForTest taskRunner = this.createTaskRunnerForTest(appId, umbilical, taskReporter, executor, TaskExecutionTestHelpers.TestProcessor.CONF_EMPTY);
            Future<TaskRunner2Result> taskRunnerFuture = taskExecutor.submit(new TaskRunnerCallable2ForTest(taskRunner));
            TaskExecutionTestHelpers.TestProcessor.awaitStart();
            TaskExecutionTestHelpers.TestProcessor.signal();
            TaskExecutionTestHelpers.TestProcessor.awaitCompletion();
            taskRunner.awaitCallableCompletion();
            taskRunner.killTask();
            TaskRunner2Result result = taskRunnerFuture.get();
            this.verifyTaskRunnerResult(result, EndReason.SUCCESS, null, false, null);
            Assert.assertFalse((boolean)TaskExecutionTestHelpers.TestProcessor.wasInterrupted());
            Assert.assertNull((Object)taskReporter.currentCallable);
            umbilical.verifyTaskSuccessEvent();
        }
        finally {
            executor.shutdownNow();
        }
    }

    private void verifySysCounters(TezCounters tezCounters, int minTaskCounterCount, int minFsCounterCount) {
        Preconditions.checkArgument((minTaskCounterCount > 0 && minFsCounterCount > 0 || minTaskCounterCount <= 0 && minFsCounterCount <= 0 ? 1 : 0) != 0, (Object)"Both targetCounter counts should be postitive or negative. A mix is not expected");
        int numTaskCounters = 0;
        int numFsCounters = 0;
        for (CounterGroup counterGroup : tezCounters) {
            if (counterGroup.getName().equals(TaskCounter.class.getName())) {
                for (TezCounter ignored : counterGroup) {
                    ++numTaskCounters;
                }
                continue;
            }
            if (!counterGroup.getName().equals(FileSystemCounter.class.getName())) continue;
            for (TezCounter ignored : counterGroup) {
                ++numFsCounters;
            }
        }
        if (minTaskCounterCount <= 0) {
            Assert.assertEquals((String)tezCounters.toString(), (long)0L, (long)numTaskCounters);
            Assert.assertEquals((String)tezCounters.toString(), (long)0L, (long)numFsCounters);
        } else {
            Assert.assertTrue((numTaskCounters >= minTaskCounterCount ? 1 : 0) != 0);
            Assert.assertTrue((numFsCounters >= minFsCounterCount ? 1 : 0) != 0);
        }
    }

    private void verifyTaskRunnerResult(TaskRunner2Result taskRunner2Result, EndReason expectedEndReason, Throwable expectedThrowable, boolean wasShutdownRequested, TaskFailureType taskFailureType) {
        this.verifyTaskRunnerResult(taskRunner2Result, expectedEndReason, expectedThrowable, null, wasShutdownRequested, taskFailureType);
    }

    private void verifyTaskRunnerResult(TaskRunner2Result taskRunner2Result, EndReason expectedEndReason, Throwable expectedThrowable, String expectedExceptionMessage, boolean wasShutdownRequested, TaskFailureType taskFailureType) {
        Assert.assertEquals((Object)expectedEndReason, (Object)taskRunner2Result.getEndReason());
        if (expectedThrowable == null) {
            Assert.assertNull((Object)taskRunner2Result.getError());
        } else {
            Assert.assertNotNull((Object)taskRunner2Result.getError());
            Throwable cause = taskRunner2Result.getError();
            LOG.info(cause.getClass().getName());
            Assert.assertTrue((boolean)cause.getClass().isAssignableFrom(expectedThrowable.getClass()));
            if (expectedExceptionMessage != null) {
                Assert.assertTrue((boolean)cause.getMessage().contains(expectedExceptionMessage));
            }
        }
        Assert.assertEquals((Object)taskFailureType, (Object)taskRunner2Result.getTaskFailureType());
        Assert.assertEquals((Object)wasShutdownRequested, (Object)taskRunner2Result.isContainerShutdownRequested());
    }

    private TezTaskRunner2 createTaskRunner(ApplicationId appId, TaskExecutionTestHelpers.TezTaskUmbilicalForTest umbilical, TaskReporter taskReporter, ListeningExecutorService executor, byte[] processorConf) throws IOException {
        return this.createTaskRunner(appId, umbilical, taskReporter, executor, processorConf, true);
    }

    private TezTaskRunner2 createTaskRunner(ApplicationId appId, TaskExecutionTestHelpers.TezTaskUmbilicalForTest umbilical, TaskReporter taskReporter, ListeningExecutorService executor, byte[] processorConf, boolean updateSysCounters) throws IOException {
        return this.createTaskRunner(appId, umbilical, taskReporter, executor, TaskExecutionTestHelpers.TestProcessor.class.getName(), processorConf, false, updateSysCounters);
    }

    private TezTaskRunner2ForTest createTaskRunnerForTest(ApplicationId appId, TaskExecutionTestHelpers.TezTaskUmbilicalForTest umbilical, TaskReporter taskReporter, ListeningExecutorService executor, byte[] processorConf) throws IOException {
        return (TezTaskRunner2ForTest)this.createTaskRunner(appId, umbilical, taskReporter, executor, TaskExecutionTestHelpers.TestProcessor.class.getName(), processorConf, true, true);
    }

    private TezTaskRunner2 createTaskRunner(ApplicationId appId, TaskExecutionTestHelpers.TezTaskUmbilicalForTest umbilical, TaskReporter taskReporter, ListeningExecutorService executor, String processorClass, byte[] processorConf, boolean testRunner, boolean updateSysCounters) throws IOException {
        TezConfiguration tezConf = new TezConfiguration(defaultConf);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        Path testDir = new Path(workDir, UUID.randomUUID().toString());
        String[] localDirs = new String[]{testDir.toString()};
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexId = TezVertexID.getInstance((TezDAGID)dagId, (int)1);
        TezTaskID taskId = TezTaskID.getInstance((TezVertexID)vertexId, (int)1);
        TezTaskAttemptID taskAttemptId = TezTaskAttemptID.getInstance((TezTaskID)taskId, (int)1);
        ProcessorDescriptor processorDescriptor = (ProcessorDescriptor)ProcessorDescriptor.create((String)processorClass).setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap(processorConf)));
        TaskSpec taskSpec = new TaskSpec(taskAttemptId, "dagName", "vertexName", -1, processorDescriptor, new ArrayList(), new ArrayList(), null, null);
        TezSharedExecutor sharedExecutor = new TezSharedExecutor((Configuration)tezConf);
        TezTaskRunner2ForTest taskRunner = testRunner ? new TezTaskRunner2ForTest((Configuration)tezConf, ugi, localDirs, taskSpec, 1, new HashMap<String, ByteBuffer>(), new HashMap<String, String>(), (Multimap<String, String>)HashMultimap.create(), (TaskReporterInterface)taskReporter, executor, null, "", (ExecutionContext)new ExecutionContextImpl("localhost"), Runtime.getRuntime().maxMemory(), updateSysCounters, (TezExecutors)sharedExecutor) : new TezTaskRunner2((Configuration)tezConf, ugi, localDirs, taskSpec, 1, new HashMap(), new HashMap(), (Multimap)HashMultimap.create(), (TaskReporterInterface)taskReporter, (ExecutorService)executor, null, "", (ExecutionContext)new ExecutionContextImpl("localhost"), Runtime.getRuntime().maxMemory(), updateSysCounters, (HadoopShim)new DefaultHadoopShim(), (TezExecutors)sharedExecutor);
        return taskRunner;
    }

    static {
        taskExecutor = Executors.newFixedThreadPool(1);
        defaultConf.set("fs.defaultFS", "file:///");
        defaultConf.set("tez.task.scale.memory.allocator.class", ScalingAllocator.class.getName());
        try {
            localFs = FileSystem.getLocal((Configuration)defaultConf);
            Path wd = new Path(System.getProperty("test.build.data", "/tmp"), TestTaskExecution2.class.getSimpleName());
            workDir = localFs.makeQualified(wd);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class TezTaskRunner2ForTest
    extends TezTaskRunner2 {
        private final ReentrantLock testLock = new ReentrantLock();
        private final Condition callableCompletionCondition = this.testLock.newCondition();
        private final AtomicBoolean isCallableComplete = new AtomicBoolean(false);

        public TezTaskRunner2ForTest(Configuration tezConf, UserGroupInformation ugi, String[] localDirs, TaskSpec taskSpec, int appAttemptNumber, Map<String, ByteBuffer> serviceConsumerMetadata, Map<String, String> serviceProviderEnvMap, Multimap<String, String> startedInputsMap, TaskReporterInterface taskReporter, ListeningExecutorService executor, ObjectRegistry objectRegistry, String pid, ExecutionContext executionContext, long memAvailable, boolean updateSysCounters, TezExecutors sharedExecutor) throws IOException {
            super(tezConf, ugi, localDirs, taskSpec, appAttemptNumber, serviceConsumerMetadata, serviceProviderEnvMap, startedInputsMap, taskReporter, (ExecutorService)executor, objectRegistry, pid, executionContext, memAvailable, updateSysCounters, (HadoopShim)new DefaultHadoopShim(), sharedExecutor);
        }

        @VisibleForTesting
        void processCallableResult(TaskRunner2Callable.TaskRunner2CallableResult executionResult) {
            this.testLock.lock();
            try {
                super.processCallableResult(executionResult);
                this.isCallableComplete.set(true);
                this.callableCompletionCondition.signal();
            }
            finally {
                this.testLock.unlock();
            }
        }

        void awaitCallableCompletion() throws InterruptedException {
            this.testLock.lock();
            try {
                while (!this.isCallableComplete.get()) {
                    this.callableCompletionCondition.await();
                }
            }
            finally {
                this.testLock.unlock();
            }
        }
    }

    private static class TaskRunnerCallable2ForTest
    implements Callable<TaskRunner2Result> {
        private final TezTaskRunner2 taskRunner;

        public TaskRunnerCallable2ForTest(TezTaskRunner2 taskRunner) {
            this.taskRunner = taskRunner;
        }

        @Override
        public TaskRunner2Result call() throws Exception {
            return this.taskRunner.run();
        }
    }
}

