/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.common.resources;

import org.apache.hadoop.conf.Configuration;
import org.apache.tez.dag.api.EntityDescriptor;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.MemoryUpdateCallback;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.api.TaskContext;
import org.apache.tez.runtime.common.resources.MemoryDistributor;
import org.apache.tez.runtime.common.resources.ScalingAllocator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMemoryDistributor {
    protected Configuration conf = new Configuration();

    @Before
    public void setup() {
        this.conf.setBoolean("tez.task.scale.memory.enabled", true);
        this.conf.set("tez.task.scale.memory.allocator.class", ScalingAllocator.class.getName());
    }

    @Test(timeout=5000L)
    public void testScalingNoProcessor() throws TezException {
        MemoryDistributor dist = new MemoryDistributor(2, 1, this.conf);
        dist.setJvmMemory(10000L);
        MemoryUpdateCallbackForTest e1Callback = new MemoryUpdateCallbackForTest();
        InputContext e1InputContext1 = this.createTestInputContext();
        InputDescriptor e1InDesc1 = this.createTestInputDescriptor();
        dist.requestMemory(10000L, (MemoryUpdateCallback)e1Callback, (TaskContext)e1InputContext1, (EntityDescriptor)e1InDesc1);
        MemoryUpdateCallbackForTest e2Callback = new MemoryUpdateCallbackForTest();
        InputContext e2InputContext2 = this.createTestInputContext();
        InputDescriptor e2InDesc2 = this.createTestInputDescriptor();
        dist.requestMemory(10000L, (MemoryUpdateCallback)e2Callback, (TaskContext)e2InputContext2, (EntityDescriptor)e2InDesc2);
        MemoryUpdateCallbackForTest e3Callback = new MemoryUpdateCallbackForTest();
        OutputContext e3OutputContext1 = this.createTestOutputContext();
        OutputDescriptor e3OutDesc2 = this.createTestOutputDescriptor();
        dist.requestMemory(5000L, (MemoryUpdateCallback)e3Callback, (TaskContext)e3OutputContext1, (EntityDescriptor)e3OutDesc2);
        dist.makeInitialAllocations();
        Assert.assertEquals((long)2800L, (long)e1Callback.assigned);
        Assert.assertEquals((long)2800L, (long)e2Callback.assigned);
        Assert.assertEquals((long)1400L, (long)e3Callback.assigned);
    }

    @Test(timeout=5000L)
    public void testScalingNoProcessor2() throws TezException {
        MemoryDistributor dist = new MemoryDistributor(2, 0, this.conf);
        dist.setJvmMemory(0xC800000L);
        MemoryUpdateCallbackForTest e1Callback = new MemoryUpdateCallbackForTest();
        InputContext e1InputContext1 = this.createTestInputContext();
        InputDescriptor e1InDesc1 = this.createTestInputDescriptor();
        dist.requestMemory(0x6400000L, (MemoryUpdateCallback)e1Callback, (TaskContext)e1InputContext1, (EntityDescriptor)e1InDesc1);
        MemoryUpdateCallbackForTest e2Callback = new MemoryUpdateCallbackForTest();
        InputContext e2InputContext2 = this.createTestInputContext();
        InputDescriptor e2InDesc2 = this.createTestInputDescriptor();
        dist.requestMemory(0x9600000L, (MemoryUpdateCallback)e2Callback, (TaskContext)e2InputContext2, (EntityDescriptor)e2InDesc2);
        dist.makeInitialAllocations();
        Assert.assertEquals((long)0x3800000L, (long)e1Callback.assigned);
        Assert.assertEquals((long)0x5400000L, (long)e2Callback.assigned);
    }

    @Test(timeout=5000L)
    public void testScalingProcessor() throws TezException {
        MemoryDistributor dist = new MemoryDistributor(2, 1, this.conf);
        dist.setJvmMemory(10000L);
        MemoryUpdateCallbackForTest e1Callback = new MemoryUpdateCallbackForTest();
        InputContext e1InputContext1 = this.createTestInputContext();
        InputDescriptor e1InDesc1 = this.createTestInputDescriptor();
        dist.requestMemory(10000L, (MemoryUpdateCallback)e1Callback, (TaskContext)e1InputContext1, (EntityDescriptor)e1InDesc1);
        MemoryUpdateCallbackForTest e2Callback = new MemoryUpdateCallbackForTest();
        InputContext e2InputContext2 = this.createTestInputContext();
        InputDescriptor e2InDesc2 = this.createTestInputDescriptor();
        dist.requestMemory(10000L, (MemoryUpdateCallback)e2Callback, (TaskContext)e2InputContext2, (EntityDescriptor)e2InDesc2);
        MemoryUpdateCallbackForTest e3Callback = new MemoryUpdateCallbackForTest();
        OutputContext e3OutputContext1 = this.createTestOutputContext();
        OutputDescriptor e3OutDesc1 = this.createTestOutputDescriptor();
        dist.requestMemory(5000L, (MemoryUpdateCallback)e3Callback, (TaskContext)e3OutputContext1, (EntityDescriptor)e3OutDesc1);
        MemoryUpdateCallbackForTest e4Callback = new MemoryUpdateCallbackForTest();
        ProcessorContext e4ProcessorContext1 = this.createTestProcessortContext();
        ProcessorDescriptor e4ProcessorDesc1 = this.createTestProcessorDescriptor();
        dist.requestMemory(5000L, (MemoryUpdateCallback)e4Callback, (TaskContext)e4ProcessorContext1, (EntityDescriptor)e4ProcessorDesc1);
        dist.makeInitialAllocations();
        Assert.assertTrue((e1Callback.assigned >= 2333L && e1Callback.assigned <= 2334L ? 1 : 0) != 0);
        Assert.assertTrue((e2Callback.assigned >= 2333L && e2Callback.assigned <= 2334L ? 1 : 0) != 0);
        Assert.assertTrue((e3Callback.assigned >= 1166L && e3Callback.assigned <= 1167L ? 1 : 0) != 0);
        Assert.assertTrue((e4Callback.assigned >= 1166L && e4Callback.assigned <= 1167L ? 1 : 0) != 0);
    }

    @Test(timeout=5000L)
    public void testScalingDisabled() throws TezException {
        Configuration conf = new Configuration(this.conf);
        conf.setBoolean("tez.task.scale.memory.enabled", false);
        MemoryDistributor dist = new MemoryDistributor(2, 0, conf);
        dist.setJvmMemory(207093760L);
        MemoryUpdateCallbackForTest e1Callback = new MemoryUpdateCallbackForTest();
        InputContext e1InputContext1 = this.createTestInputContext();
        InputDescriptor e1InDesc1 = this.createTestInputDescriptor();
        dist.requestMemory(0x6400000L, (MemoryUpdateCallback)e1Callback, (TaskContext)e1InputContext1, (EntityDescriptor)e1InDesc1);
        MemoryUpdateCallbackForTest e2Callback = new MemoryUpdateCallbackForTest();
        InputContext e2InputContext2 = this.createTestInputContext();
        InputDescriptor e2InDesc2 = this.createTestInputDescriptor();
        dist.requestMemory(144965632L, (MemoryUpdateCallback)e2Callback, (TaskContext)e2InputContext2, (EntityDescriptor)e2InDesc2);
        dist.makeInitialAllocations();
        Assert.assertEquals((long)0x6400000L, (long)e1Callback.assigned);
        Assert.assertEquals((long)144965632L, (long)e2Callback.assigned);
    }

    @Test(timeout=5000L)
    public void testReserveFractionConfigured() throws TezException {
        Configuration conf = new Configuration(this.conf);
        conf.setDouble("tez.task.scale.memory.reserve-fraction", 0.5);
        MemoryDistributor dist = new MemoryDistributor(2, 1, conf);
        dist.setJvmMemory(10000L);
        MemoryUpdateCallbackForTest e1Callback = new MemoryUpdateCallbackForTest();
        InputContext e1InputContext1 = this.createTestInputContext();
        InputDescriptor e1InDesc1 = this.createTestInputDescriptor();
        dist.requestMemory(10000L, (MemoryUpdateCallback)e1Callback, (TaskContext)e1InputContext1, (EntityDescriptor)e1InDesc1);
        MemoryUpdateCallbackForTest e2Callback = new MemoryUpdateCallbackForTest();
        InputContext e2InputContext2 = this.createTestInputContext();
        InputDescriptor e2InDesc2 = this.createTestInputDescriptor();
        dist.requestMemory(10000L, (MemoryUpdateCallback)e2Callback, (TaskContext)e2InputContext2, (EntityDescriptor)e2InDesc2);
        MemoryUpdateCallbackForTest e3Callback = new MemoryUpdateCallbackForTest();
        OutputContext e3OutputContext1 = this.createTestOutputContext();
        OutputDescriptor e3OutDesc2 = this.createTestOutputDescriptor();
        dist.requestMemory(5000L, (MemoryUpdateCallback)e3Callback, (TaskContext)e3OutputContext1, (EntityDescriptor)e3OutDesc2);
        dist.makeInitialAllocations();
        Assert.assertEquals((long)2000L, (long)e1Callback.assigned);
        Assert.assertEquals((long)2000L, (long)e2Callback.assigned);
        Assert.assertEquals((long)1000L, (long)e3Callback.assigned);
    }

    protected InputDescriptor createTestInputDescriptor() {
        InputDescriptor desc = (InputDescriptor)Mockito.mock(InputDescriptor.class);
        ((InputDescriptor)Mockito.doReturn((Object)"InputClass").when((Object)desc)).getClassName();
        return desc;
    }

    protected OutputDescriptor createTestOutputDescriptor() {
        OutputDescriptor desc = (OutputDescriptor)Mockito.mock(OutputDescriptor.class);
        ((OutputDescriptor)Mockito.doReturn((Object)"OutputClass").when((Object)desc)).getClassName();
        return desc;
    }

    protected ProcessorDescriptor createTestProcessorDescriptor() {
        ProcessorDescriptor desc = (ProcessorDescriptor)Mockito.mock(ProcessorDescriptor.class);
        ((ProcessorDescriptor)Mockito.doReturn((Object)"ProcessorClass").when((Object)desc)).getClassName();
        return desc;
    }

    protected InputContext createTestInputContext() {
        InputContext context = (InputContext)Mockito.mock(InputContext.class);
        ((InputContext)Mockito.doReturn((Object)"input").when((Object)context)).getSourceVertexName();
        ((InputContext)Mockito.doReturn((Object)"task").when((Object)context)).getTaskVertexName();
        return context;
    }

    protected OutputContext createTestOutputContext() {
        OutputContext context = (OutputContext)Mockito.mock(OutputContext.class);
        ((OutputContext)Mockito.doReturn((Object)"output").when((Object)context)).getDestinationVertexName();
        ((OutputContext)Mockito.doReturn((Object)"task").when((Object)context)).getTaskVertexName();
        return context;
    }

    protected ProcessorContext createTestProcessortContext() {
        ProcessorContext context = (ProcessorContext)Mockito.mock(ProcessorContext.class);
        ((ProcessorContext)Mockito.doReturn((Object)"task").when((Object)context)).getTaskVertexName();
        return context;
    }

    private static class MemoryUpdateCallbackForTest
    extends MemoryUpdateCallback {
        long assigned = -1000L;

        private MemoryUpdateCallbackForTest() {
        }

        public void memoryAssigned(long assignedSize) {
            this.assigned = assignedSize;
        }
    }
}

