/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.impl;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.TezExecutors;
import org.apache.tez.common.TezSharedExecutor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.hadoop.shim.DefaultHadoopShim;
import org.apache.tez.hadoop.shim.HadoopShim;
import org.apache.tez.runtime.InputReadyTracker;
import org.apache.tez.runtime.LogicalIOProcessorRuntimeTask;
import org.apache.tez.runtime.api.ExecutionContext;
import org.apache.tez.runtime.api.ObjectRegistry;
import org.apache.tez.runtime.api.impl.ExecutionContextImpl;
import org.apache.tez.runtime.api.impl.InputSpec;
import org.apache.tez.runtime.api.impl.OutputSpec;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.runtime.api.impl.TezProcessorContextImpl;
import org.apache.tez.runtime.api.impl.TezUmbilical;
import org.apache.tez.runtime.common.objectregistry.ObjectRegistryImpl;
import org.apache.tez.runtime.common.resources.MemoryDistributor;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestProcessorContext {
    @Test(timeout=5000L)
    public void testDagNumber() throws IOException {
        Object[] localDirs = new String[]{"dummyLocalDir"};
        int appAttemptNumber = 1;
        TezUmbilical tezUmbilical = (TezUmbilical)Mockito.mock(TezUmbilical.class);
        String dagName = "DAG_NAME";
        String vertexName = "VERTEX_NAME";
        int vertexParallelism = 20;
        int dagNumber = 52;
        ApplicationId appId = ApplicationId.newInstance((long)10000L, (int)13);
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)appId, (int)dagNumber);
        TezVertexID vertexId = TezVertexID.getInstance((TezDAGID)dagId, (int)6);
        TezTaskID taskId = TezTaskID.getInstance((TezVertexID)vertexId, (int)4);
        TezTaskAttemptID taskAttemptId = TezTaskAttemptID.getInstance((TezTaskID)taskId, (int)2);
        TaskSpec mockSpec = (TaskSpec)Mockito.mock(TaskSpec.class);
        Mockito.when((Object)mockSpec.getInputs()).thenReturn(Collections.singletonList((InputSpec)Mockito.mock(InputSpec.class)));
        Mockito.when((Object)mockSpec.getOutputs()).thenReturn(Collections.singletonList((OutputSpec)Mockito.mock(OutputSpec.class)));
        Configuration conf = new Configuration();
        TezSharedExecutor sharedExecutor = new TezSharedExecutor(conf);
        LogicalIOProcessorRuntimeTask runtimeTask = new LogicalIOProcessorRuntimeTask(mockSpec, 1, conf, new String[]{"/"}, tezUmbilical, null, null, null, null, "", null, 1024L, false, (HadoopShim)new DefaultHadoopShim(), (TezExecutors)sharedExecutor);
        LogicalIOProcessorRuntimeTask mockTask = (LogicalIOProcessorRuntimeTask)Mockito.spy((Object)runtimeTask);
        HashMap serviceConsumerMetadata = Maps.newHashMap();
        HashMap auxServiceEnv = Maps.newHashMap();
        MemoryDistributor memDist = (MemoryDistributor)Mockito.mock(MemoryDistributor.class);
        ProcessorDescriptor processorDesc = (ProcessorDescriptor)Mockito.mock(ProcessorDescriptor.class);
        InputReadyTracker inputReadyTracker = (InputReadyTracker)Mockito.mock(InputReadyTracker.class);
        ObjectRegistryImpl objectRegistry = new ObjectRegistryImpl();
        ExecutionContextImpl execContext = new ExecutionContextImpl("localhost");
        long memAvailable = 10000L;
        TezProcessorContextImpl procContext = new TezProcessorContextImpl(new Configuration(), (String[])localDirs, appAttemptNumber, tezUmbilical, dagName, vertexName, vertexParallelism, taskAttemptId, null, runtimeTask, (Map)serviceConsumerMetadata, (Map)auxServiceEnv, memDist, processorDesc, inputReadyTracker, (ObjectRegistry)objectRegistry, (ExecutionContext)execContext, memAvailable, (TezExecutors)sharedExecutor);
        Assert.assertEquals((long)dagNumber, (long)procContext.getDagIdentifier());
        Assert.assertEquals((long)appAttemptNumber, (long)procContext.getDAGAttemptNumber());
        Assert.assertEquals((Object)appId, (Object)procContext.getApplicationId());
        Assert.assertEquals((Object)dagName, (Object)procContext.getDAGName());
        Assert.assertEquals((Object)vertexName, (Object)procContext.getTaskVertexName());
        Assert.assertEquals((long)vertexId.getId(), (long)procContext.getTaskVertexIndex());
        Assert.assertTrue((boolean)Arrays.equals(localDirs, procContext.getWorkDirs()));
        procContext.setProgress(0.1f);
        ((LogicalIOProcessorRuntimeTask)Mockito.verify((Object)mockTask, (VerificationMode)Mockito.times((int)1))).notifyProgressInvocation();
        sharedExecutor.shutdown();
    }
}

