/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.logging.proto;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.tez.common.VersionInfo;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.dag.DAGState;
import org.apache.tez.dag.app.dag.VertexState;
import org.apache.tez.dag.app.dag.impl.ServicePluginInfo;
import org.apache.tez.dag.app.dag.impl.TaskAttemptImpl;
import org.apache.tez.dag.app.dag.impl.VertexStats;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.events.AMLaunchedEvent;
import org.apache.tez.dag.history.events.AMStartedEvent;
import org.apache.tez.dag.history.events.AppLaunchedEvent;
import org.apache.tez.dag.history.events.ContainerLaunchedEvent;
import org.apache.tez.dag.history.events.ContainerStoppedEvent;
import org.apache.tez.dag.history.events.DAGCommitStartedEvent;
import org.apache.tez.dag.history.events.DAGFinishedEvent;
import org.apache.tez.dag.history.events.DAGInitializedEvent;
import org.apache.tez.dag.history.events.DAGKillRequestEvent;
import org.apache.tez.dag.history.events.DAGRecoveredEvent;
import org.apache.tez.dag.history.events.DAGStartedEvent;
import org.apache.tez.dag.history.events.DAGSubmittedEvent;
import org.apache.tez.dag.history.events.TaskAttemptFinishedEvent;
import org.apache.tez.dag.history.events.TaskAttemptStartedEvent;
import org.apache.tez.dag.history.events.TaskFinishedEvent;
import org.apache.tez.dag.history.events.TaskStartedEvent;
import org.apache.tez.dag.history.events.VertexCommitStartedEvent;
import org.apache.tez.dag.history.events.VertexConfigurationDoneEvent;
import org.apache.tez.dag.history.events.VertexFinishedEvent;
import org.apache.tez.dag.history.events.VertexGroupCommitFinishedEvent;
import org.apache.tez.dag.history.events.VertexGroupCommitStartedEvent;
import org.apache.tez.dag.history.events.VertexInitializedEvent;
import org.apache.tez.dag.history.events.VertexStartedEvent;
import org.apache.tez.dag.history.logging.EntityTypes;
import org.apache.tez.dag.history.logging.proto.HistoryEventProtoConverter;
import org.apache.tez.dag.history.logging.proto.HistoryLoggerProtos;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.TaskFailureType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHistoryEventProtoConverter {
    private ApplicationAttemptId applicationAttemptId;
    private ApplicationId applicationId;
    private String user = "user";
    private Random random = new Random();
    private TezDAGID tezDAGID;
    private TezVertexID tezVertexID;
    private TezTaskID tezTaskID;
    private TezTaskAttemptID tezTaskAttemptID;
    private DAGProtos.DAGPlan dagPlan;
    private ContainerId containerId;
    private NodeId nodeId;
    private String containerLogs = "containerLogs";
    private HistoryEventProtoConverter converter = new HistoryEventProtoConverter();

    @Before
    public void setup() {
        this.applicationId = ApplicationId.newInstance((long)9999L, (int)1);
        this.applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)this.applicationId, (int)1);
        this.tezDAGID = TezDAGID.getInstance((ApplicationId)this.applicationId, (int)this.random.nextInt());
        this.tezVertexID = TezVertexID.getInstance((TezDAGID)this.tezDAGID, (int)this.random.nextInt());
        this.tezTaskID = TezTaskID.getInstance((TezVertexID)this.tezVertexID, (int)this.random.nextInt());
        this.tezTaskAttemptID = TezTaskAttemptID.getInstance((TezTaskID)this.tezTaskID, (int)this.random.nextInt());
        DAGProtos.CallerContextProto.Builder callerContextProto = DAGProtos.CallerContextProto.newBuilder();
        callerContextProto.setContext("ctxt");
        callerContextProto.setCallerId("Caller_ID");
        callerContextProto.setCallerType("Caller_Type");
        callerContextProto.setBlob("Desc_1");
        this.dagPlan = DAGProtos.DAGPlan.newBuilder().setName("DAGPlanMock").setCallerContext(callerContextProto).build();
        this.containerId = ContainerId.newContainerId((ApplicationAttemptId)this.applicationAttemptId, (long)111L);
        this.nodeId = NodeId.newInstance((String)"node", (int)13435);
    }

    @Test(timeout=5000L)
    public void testHandlerExists() {
        for (HistoryEventType eventType : HistoryEventType.values()) {
            DAGCommitStartedEvent event = null;
            switch (eventType) {
                case APP_LAUNCHED: {
                    event = new AppLaunchedEvent(this.applicationId, (long)this.random.nextInt(), (long)this.random.nextInt(), this.user, new Configuration(false), null);
                    break;
                }
                case AM_LAUNCHED: {
                    event = new AMLaunchedEvent(this.applicationAttemptId, (long)this.random.nextInt(), (long)this.random.nextInt(), this.user);
                    break;
                }
                case AM_STARTED: {
                    event = new AMStartedEvent(this.applicationAttemptId, (long)this.random.nextInt(), this.user);
                    break;
                }
                case DAG_SUBMITTED: {
                    event = new DAGSubmittedEvent(this.tezDAGID, (long)this.random.nextInt(), this.dagPlan, this.applicationAttemptId, null, this.user, null, this.containerLogs, null);
                    break;
                }
                case DAG_INITIALIZED: {
                    event = new DAGInitializedEvent(this.tezDAGID, (long)this.random.nextInt(), this.user, this.dagPlan.getName(), null);
                    break;
                }
                case DAG_STARTED: {
                    event = new DAGStartedEvent(this.tezDAGID, (long)this.random.nextInt(), this.user, this.dagPlan.getName());
                    break;
                }
                case DAG_FINISHED: {
                    event = new DAGFinishedEvent(this.tezDAGID, (long)this.random.nextInt(), (long)this.random.nextInt(), DAGState.ERROR, null, null, this.user, this.dagPlan.getName(), null, this.applicationAttemptId, this.dagPlan);
                    break;
                }
                case VERTEX_INITIALIZED: {
                    event = new VertexInitializedEvent(this.tezVertexID, "v1", (long)this.random.nextInt(), (long)this.random.nextInt(), this.random.nextInt(), "proc", null, null, null);
                    break;
                }
                case VERTEX_STARTED: {
                    event = new VertexStartedEvent(this.tezVertexID, (long)this.random.nextInt(), (long)this.random.nextInt());
                    break;
                }
                case VERTEX_CONFIGURE_DONE: {
                    event = new VertexConfigurationDoneEvent(this.tezVertexID, 0L, 1, null, null, null, true);
                    break;
                }
                case VERTEX_FINISHED: {
                    event = new VertexFinishedEvent(this.tezVertexID, "v1", 1, (long)this.random.nextInt(), (long)this.random.nextInt(), (long)this.random.nextInt(), (long)this.random.nextInt(), (long)this.random.nextInt(), VertexState.ERROR, null, null, null, null, null);
                    break;
                }
                case TASK_STARTED: {
                    event = new TaskStartedEvent(this.tezTaskID, "v1", (long)this.random.nextInt(), (long)this.random.nextInt());
                    break;
                }
                case TASK_FINISHED: {
                    event = new TaskFinishedEvent(this.tezTaskID, "v1", (long)this.random.nextInt(), (long)this.random.nextInt(), this.tezTaskAttemptID, TaskState.FAILED, null, null, 0);
                    break;
                }
                case TASK_ATTEMPT_STARTED: {
                    event = new TaskAttemptStartedEvent(this.tezTaskAttemptID, "v1", (long)this.random.nextInt(), this.containerId, this.nodeId, null, null, "nodeHttpAddress");
                    break;
                }
                case TASK_ATTEMPT_FINISHED: {
                    event = new TaskAttemptFinishedEvent(this.tezTaskAttemptID, "v1", (long)this.random.nextInt(), (long)this.random.nextInt(), TaskAttemptState.FAILED, TaskFailureType.NON_FATAL, TaskAttemptTerminationCause.OUTPUT_LOST, null, null, null, null, 0L, null, 0L, this.containerId, this.nodeId, null, null, "nodeHttpAddress");
                    break;
                }
                case CONTAINER_LAUNCHED: {
                    event = new ContainerLaunchedEvent(this.containerId, (long)this.random.nextInt(), this.applicationAttemptId);
                    break;
                }
                case CONTAINER_STOPPED: {
                    event = new ContainerStoppedEvent(this.containerId, (long)this.random.nextInt(), -1, this.applicationAttemptId);
                    break;
                }
                case DAG_COMMIT_STARTED: {
                    event = new DAGCommitStartedEvent();
                    break;
                }
                case VERTEX_COMMIT_STARTED: {
                    event = new VertexCommitStartedEvent();
                    break;
                }
                case VERTEX_GROUP_COMMIT_STARTED: {
                    event = new VertexGroupCommitStartedEvent();
                    break;
                }
                case VERTEX_GROUP_COMMIT_FINISHED: {
                    event = new VertexGroupCommitFinishedEvent();
                    break;
                }
                case DAG_RECOVERED: {
                    event = new DAGRecoveredEvent(this.applicationAttemptId, this.tezDAGID, this.dagPlan.getName(), this.user, this.random.nextLong(), this.containerLogs);
                    break;
                }
                case DAG_KILL_REQUEST: {
                    event = new DAGKillRequestEvent();
                    break;
                }
                default: {
                    Assert.fail((String)("Unhandled event type " + eventType));
                }
            }
            if (event == null || !event.isHistoryEvent()) continue;
            this.converter.convert((HistoryEvent)event);
        }
    }

    private String findEventData(HistoryLoggerProtos.HistoryEventProto proto, String key) {
        for (HistoryLoggerProtos.KVPair data : proto.getEventDataList()) {
            if (!data.getKey().equals(key)) continue;
            return data.getValue();
        }
        return null;
    }

    private void assertEventData(HistoryLoggerProtos.HistoryEventProto proto, String key, String value) {
        String evtVal = this.findEventData(proto, key);
        if (evtVal == null) {
            Assert.fail((String)("Cannot find kv pair: " + key));
        }
        if (value != null) {
            Assert.assertEquals((Object)value, (Object)evtVal);
        }
    }

    private void assertNoEventData(HistoryLoggerProtos.HistoryEventProto proto, String key) {
        for (HistoryLoggerProtos.KVPair data : proto.getEventDataList()) {
            if (!data.getKey().equals(key)) continue;
            Assert.fail((String)("Found find kv pair: " + key));
        }
    }

    private String safeToString(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    private void assertCommon(HistoryLoggerProtos.HistoryEventProto proto, HistoryEventType type, long eventTime, EntityTypes entityType, ApplicationAttemptId appAttemptId, String user, int numData) {
        Assert.assertEquals((Object)type.name(), (Object)proto.getEventType());
        Assert.assertEquals((long)eventTime, (long)proto.getEventTime());
        Assert.assertEquals((Object)this.safeToString(appAttemptId), (Object)proto.getAppAttemptId());
        Assert.assertEquals((Object)this.safeToString(user), (Object)proto.getUser());
        if (entityType != null) {
            switch (entityType) {
                case TEZ_TASK_ATTEMPT_ID: {
                    Assert.assertEquals((Object)this.tezTaskAttemptID.toString(), (Object)proto.getTaskAttemptId());
                }
                case TEZ_TASK_ID: {
                    Assert.assertEquals((Object)this.tezTaskID.toString(), (Object)proto.getTaskId());
                }
                case TEZ_VERTEX_ID: {
                    Assert.assertEquals((Object)this.tezVertexID.toString(), (Object)proto.getVertexId());
                }
                case TEZ_DAG_ID: {
                    Assert.assertEquals((Object)this.tezDAGID.toString(), (Object)proto.getDagId());
                }
                case TEZ_APPLICATION: {
                    Assert.assertEquals((Object)this.applicationId.toString(), (Object)proto.getAppId());
                    break;
                }
                default: {
                    Assert.fail((String)("Invalid type: " + entityType.name()));
                }
            }
        }
        Assert.assertEquals((long)numData, (long)proto.getEventDataCount());
    }

    @Test(timeout=5000L)
    public void testConvertAppLaunchedEvent() {
        long launchTime = this.random.nextLong();
        long submitTime = this.random.nextLong();
        Configuration conf = new Configuration(false);
        conf.set("foo", "bar");
        conf.set("applicationId", "1234");
        MockVersionInfo mockVersionInfo = new MockVersionInfo();
        AppLaunchedEvent event = new AppLaunchedEvent(this.applicationId, launchTime, submitTime, this.user, conf, (VersionInfo)mockVersionInfo);
        HistoryLoggerProtos.HistoryEventProto proto = this.converter.convert((HistoryEvent)event);
        this.assertCommon(proto, HistoryEventType.APP_LAUNCHED, launchTime, EntityTypes.TEZ_APPLICATION, null, this.user, 3);
        this.assertEventData(proto, "config", null);
        this.assertEventData(proto, "tezVersion", null);
        this.assertEventData(proto, "amWebServiceVersion", "2");
    }

    @Test(timeout=5000L)
    public void testConvertAMLaunchedEvent() {
        long launchTime = this.random.nextLong();
        long submitTime = this.random.nextLong();
        AMLaunchedEvent event = new AMLaunchedEvent(this.applicationAttemptId, launchTime, submitTime, this.user);
        HistoryLoggerProtos.HistoryEventProto proto = this.converter.convert((HistoryEvent)event);
        this.assertCommon(proto, HistoryEventType.AM_LAUNCHED, launchTime, EntityTypes.TEZ_APPLICATION, this.applicationAttemptId, this.user, 1);
        this.assertEventData(proto, "appSubmitTime", String.valueOf(submitTime));
    }

    @Test(timeout=5000L)
    public void testConvertAMStartedEvent() {
        long startTime = this.random.nextLong();
        AMStartedEvent event = new AMStartedEvent(this.applicationAttemptId, startTime, this.user);
        HistoryLoggerProtos.HistoryEventProto proto = this.converter.convert((HistoryEvent)event);
        this.assertCommon(proto, HistoryEventType.AM_STARTED, startTime, EntityTypes.TEZ_APPLICATION, this.applicationAttemptId, this.user, 0);
    }

    @Test(timeout=5000L)
    public void testConvertContainerLaunchedEvent() {
        long launchTime = this.random.nextLong();
        ContainerLaunchedEvent event = new ContainerLaunchedEvent(this.containerId, launchTime, this.applicationAttemptId);
        HistoryLoggerProtos.HistoryEventProto proto = this.converter.convert((HistoryEvent)event);
        this.assertCommon(proto, HistoryEventType.CONTAINER_LAUNCHED, launchTime, EntityTypes.TEZ_APPLICATION, this.applicationAttemptId, null, 1);
        this.assertEventData(proto, "containerId", this.containerId.toString());
    }

    @Test(timeout=5000L)
    public void testConvertContainerStoppedEvent() {
        long stopTime = this.random.nextLong();
        int exitStatus = this.random.nextInt();
        ContainerStoppedEvent event = new ContainerStoppedEvent(this.containerId, stopTime, exitStatus, this.applicationAttemptId);
        HistoryLoggerProtos.HistoryEventProto proto = this.converter.convert((HistoryEvent)event);
        this.assertCommon(proto, HistoryEventType.CONTAINER_STOPPED, stopTime, EntityTypes.TEZ_APPLICATION, this.applicationAttemptId, null, 3);
        this.assertEventData(proto, "containerId", this.containerId.toString());
        this.assertEventData(proto, "exitStatus", String.valueOf(exitStatus));
        this.assertEventData(proto, "endTime", String.valueOf(stopTime));
    }

    @Test(timeout=5000L)
    public void testConvertDAGStartedEvent() {
        long startTime = this.random.nextLong();
        String dagName = "testDagName";
        DAGStartedEvent event = new DAGStartedEvent(this.tezDAGID, startTime, this.user, dagName);
        HistoryLoggerProtos.HistoryEventProto proto = this.converter.convert((HistoryEvent)event);
        this.assertCommon(proto, HistoryEventType.DAG_STARTED, startTime, EntityTypes.TEZ_DAG_ID, null, this.user, 2);
        this.assertEventData(proto, "dagName", dagName);
        this.assertEventData(proto, "status", DAGState.RUNNING.name());
    }

    @Test(timeout=5000L)
    public void testConvertDAGSubmittedEvent() {
        long submitTime = this.random.nextLong();
        String queueName = "TEST_DAG_SUBMITTED";
        DAGSubmittedEvent event = new DAGSubmittedEvent(this.tezDAGID, submitTime, this.dagPlan, this.applicationAttemptId, null, this.user, null, this.containerLogs, "TEST_DAG_SUBMITTED");
        HistoryLoggerProtos.HistoryEventProto proto = this.converter.convert((HistoryEvent)event);
        this.assertCommon(proto, HistoryEventType.DAG_SUBMITTED, submitTime, EntityTypes.TEZ_DAG_ID, this.applicationAttemptId, this.user, 8);
        this.assertEventData(proto, "dagName", this.dagPlan.getName());
        this.assertEventData(proto, "queueName", event.getQueueName());
        this.assertEventData(proto, "amWebServiceVersion", "2");
        this.assertEventData(proto, "inProgressLogsURL_" + this.applicationAttemptId.getAttemptId(), this.containerLogs);
        this.assertEventData(proto, "callerId", this.dagPlan.getCallerContext().getCallerId());
        this.assertEventData(proto, "callerType", this.dagPlan.getCallerContext().getCallerType());
        this.assertEventData(proto, "callerContext", this.dagPlan.getCallerContext().getContext());
        this.assertEventData(proto, "dagPlan", null);
    }

    @Test(timeout=5000L)
    public void testConvertTaskAttemptFinishedEvent() {
        String vertexName = "testVertex";
        long creationTime = this.random.nextLong();
        long startTime = creationTime + 1000L;
        long allocationTime = creationTime + 1001L;
        long finishTime = startTime + 1002L;
        TaskAttemptState state = TaskAttemptState.values()[this.random.nextInt(TaskAttemptState.values().length)];
        TaskAttemptTerminationCause error = TaskAttemptTerminationCause.values()[this.random.nextInt(TaskAttemptTerminationCause.values().length)];
        String diagnostics = "random diagnostics message";
        TezCounters counters = new TezCounters();
        long lastDataEventTime = finishTime - 1L;
        ArrayList events = Lists.newArrayList();
        events.add(new TaskAttemptImpl.DataEventDependencyInfo(lastDataEventTime, this.tezTaskAttemptID));
        events.add(new TaskAttemptImpl.DataEventDependencyInfo(lastDataEventTime, this.tezTaskAttemptID));
        TaskAttemptFinishedEvent event = new TaskAttemptFinishedEvent(this.tezTaskAttemptID, vertexName, startTime, finishTime, state, TaskFailureType.FATAL, error, diagnostics, counters, (List)events, null, creationTime, this.tezTaskAttemptID, allocationTime, this.containerId, this.nodeId, "inProgressURL", "logsURL", "nodeHttpAddress");
        HistoryLoggerProtos.HistoryEventProto proto = this.converter.convert((HistoryEvent)event);
        this.assertCommon(proto, HistoryEventType.TASK_ATTEMPT_FINISHED, finishTime, EntityTypes.TEZ_DAG_ID, null, null, 17);
        this.assertEventData(proto, "status", state.name());
        this.assertEventData(proto, "creationCausalAttempt", this.tezTaskAttemptID.toString());
        this.assertEventData(proto, "creationTime", String.valueOf(creationTime));
        this.assertEventData(proto, "allocationTime", String.valueOf(allocationTime));
        this.assertEventData(proto, "startTime", String.valueOf(startTime));
        this.assertEventData(proto, "timeTaken", String.valueOf(finishTime - startTime));
        this.assertEventData(proto, "taskFailureType", TaskFailureType.FATAL.name());
        this.assertEventData(proto, "taskAttemptErrorEnum", error.name());
        this.assertEventData(proto, "diagnostics", diagnostics);
        this.assertEventData(proto, "lastDataEvents", null);
        this.assertEventData(proto, "counters", null);
        this.assertEventData(proto, "inProgressLogsURL", "inProgressURL");
        this.assertEventData(proto, "completedLogsURL", "logsURL");
        this.assertEventData(proto, "nodeId", this.nodeId.toString());
        this.assertEventData(proto, "containerId", this.containerId.toString());
        this.assertEventData(proto, "nodeHttpAddress", "nodeHttpAddress");
        TaskAttemptFinishedEvent eventWithNullFailureType = new TaskAttemptFinishedEvent(this.tezTaskAttemptID, vertexName, startTime, finishTime, state, null, error, diagnostics, counters, (List)events, null, creationTime, this.tezTaskAttemptID, allocationTime, this.containerId, this.nodeId, "inProgressURL", "logsURL", "nodeHttpAddress");
        proto = this.converter.convert((HistoryEvent)eventWithNullFailureType);
        this.assertNoEventData(proto, "taskFailureType");
    }

    @Test(timeout=5000L)
    public void testConvertDAGInitializedEvent() {
        long initTime = this.random.nextLong();
        HashMap<String, TezVertexID> nameIdMap = new HashMap<String, TezVertexID>();
        nameIdMap.put("foo", this.tezVertexID);
        DAGInitializedEvent event = new DAGInitializedEvent(this.tezDAGID, initTime, "user", "dagName", nameIdMap);
        HistoryLoggerProtos.HistoryEventProto proto = this.converter.convert((HistoryEvent)event);
        this.assertCommon(proto, HistoryEventType.DAG_INITIALIZED, initTime, EntityTypes.TEZ_DAG_ID, null, this.user, 2);
        this.assertEventData(proto, "dagName", "dagName");
        this.assertEventData(proto, "vertexNameIdMapping", null);
    }

    @Test(timeout=5000L)
    public void testConvertDAGFinishedEvent() {
        long finishTime = this.random.nextLong();
        long startTime = this.random.nextLong();
        HashMap<String, Integer> taskStats = new HashMap<String, Integer>();
        taskStats.put("FOO", 100);
        taskStats.put("BAR", 200);
        DAGFinishedEvent event = new DAGFinishedEvent(this.tezDAGID, startTime, finishTime, DAGState.ERROR, "diagnostics", null, this.user, this.dagPlan.getName(), taskStats, this.applicationAttemptId, this.dagPlan);
        HistoryLoggerProtos.HistoryEventProto proto = this.converter.convert((HistoryEvent)event);
        this.assertCommon(proto, HistoryEventType.DAG_FINISHED, finishTime, EntityTypes.TEZ_DAG_ID, this.applicationAttemptId, this.user, 11);
        this.assertEventData(proto, "dagName", this.dagPlan.getName());
        this.assertEventData(proto, "status", DAGState.ERROR.name());
        this.assertEventData(proto, "callerId", this.dagPlan.getCallerContext().getCallerId());
        this.assertEventData(proto, "callerType", this.dagPlan.getCallerContext().getCallerType());
        this.assertEventData(proto, "startTime", String.valueOf(startTime));
        this.assertEventData(proto, "timeTaken", String.valueOf(finishTime - startTime));
        this.assertEventData(proto, "diagnostics", "diagnostics");
        this.assertEventData(proto, "completionApplicationAttemptId", this.applicationAttemptId.toString());
        this.assertEventData(proto, "FOO", String.valueOf(100));
        this.assertEventData(proto, "BAR", String.valueOf(200));
        this.assertEventData(proto, "counters", null);
    }

    @Test(timeout=5000L)
    public void testConvertVertexInitializedEvent() {
        long initRequestedTime = this.random.nextLong();
        long initedTime = this.random.nextLong();
        int numTasks = this.random.nextInt();
        VertexInitializedEvent event = new VertexInitializedEvent(this.tezVertexID, "v1", initRequestedTime, initedTime, numTasks, "proc", null, null, new ServicePluginInfo().setContainerLauncherName("abc").setTaskSchedulerName("def").setTaskCommunicatorName("ghi").setContainerLauncherClassName("abc1").setTaskSchedulerClassName("def1").setTaskCommunicatorClassName("ghi1"));
        HistoryLoggerProtos.HistoryEventProto proto = this.converter.convert((HistoryEvent)event);
        this.assertCommon(proto, HistoryEventType.VERTEX_INITIALIZED, initedTime, EntityTypes.TEZ_VERTEX_ID, null, null, 6);
        this.assertEventData(proto, "vertexName", "v1");
        this.assertEventData(proto, "processorClassName", "proc");
        this.assertEventData(proto, "initRequestedTime", String.valueOf(initRequestedTime));
        this.assertEventData(proto, "numTasks", String.valueOf(numTasks));
        this.assertEventData(proto, "servicePlugin", null);
    }

    @Test(timeout=5000L)
    public void testConvertVertexStartedEvent() {
        long startRequestedTime = this.random.nextLong();
        long startTime = this.random.nextLong();
        VertexStartedEvent event = new VertexStartedEvent(this.tezVertexID, startRequestedTime, startTime);
        HistoryLoggerProtos.HistoryEventProto proto = this.converter.convert((HistoryEvent)event);
        this.assertCommon(proto, HistoryEventType.VERTEX_STARTED, startTime, EntityTypes.TEZ_VERTEX_ID, null, null, 2);
        this.assertEventData(proto, "startRequestedTime", String.valueOf(startRequestedTime));
        this.assertEventData(proto, "status", VertexState.RUNNING.name());
    }

    @Test(timeout=5000L)
    public void testConvertVertexFinishedEvent() {
        String vertexName = "v1";
        long initRequestedTime = this.random.nextLong();
        long initedTime = this.random.nextLong();
        long startRequestedTime = this.random.nextLong();
        long startTime = this.random.nextLong();
        long finishTime = this.random.nextLong();
        HashMap<String, Integer> taskStats = new HashMap<String, Integer>();
        taskStats.put("FOO", 100);
        taskStats.put("BAR", 200);
        VertexStats vertexStats = new VertexStats();
        VertexFinishedEvent event = new VertexFinishedEvent(this.tezVertexID, vertexName, 1, initRequestedTime, initedTime, startRequestedTime, startTime, finishTime, VertexState.ERROR, "diagnostics", null, vertexStats, taskStats, new ServicePluginInfo().setContainerLauncherName("abc").setTaskSchedulerName("def").setTaskCommunicatorName("ghi").setContainerLauncherClassName("abc1").setTaskSchedulerClassName("def1").setTaskCommunicatorClassName("ghi1"));
        HistoryLoggerProtos.HistoryEventProto proto = this.converter.convert((HistoryEvent)event);
        this.assertCommon(proto, HistoryEventType.VERTEX_FINISHED, finishTime, EntityTypes.TEZ_VERTEX_ID, null, null, 9);
        this.assertEventData(proto, "vertexName", vertexName);
        this.assertEventData(proto, "status", VertexState.ERROR.name());
        this.assertEventData(proto, "timeTaken", String.valueOf(finishTime - startTime));
        this.assertEventData(proto, "diagnostics", "diagnostics");
        this.assertEventData(proto, "counters", null);
        this.assertEventData(proto, "stats", null);
        this.assertEventData(proto, "FOO", "100");
        this.assertEventData(proto, "BAR", "200");
        this.assertEventData(proto, "servicePlugin", null);
    }

    @Test(timeout=5000L)
    public void testConvertTaskStartedEvent() {
        long scheduleTime = this.random.nextLong();
        long startTime = this.random.nextLong();
        TaskStartedEvent event = new TaskStartedEvent(this.tezTaskID, "v1", scheduleTime, startTime);
        HistoryLoggerProtos.HistoryEventProto proto = this.converter.convert((HistoryEvent)event);
        this.assertCommon(proto, HistoryEventType.TASK_STARTED, startTime, EntityTypes.TEZ_TASK_ID, null, null, 2);
        this.assertEventData(proto, "scheduledTime", String.valueOf(scheduleTime));
        this.assertEventData(proto, "status", TaskState.SCHEDULED.name());
    }

    @Test(timeout=5000L)
    public void testConvertTaskAttemptStartedEvent() {
        long startTime = this.random.nextLong();
        TaskAttemptStartedEvent event = new TaskAttemptStartedEvent(this.tezTaskAttemptID, "v1", startTime, this.containerId, this.nodeId, "inProgressURL", "logsURL", "nodeHttpAddress");
        HistoryLoggerProtos.HistoryEventProto proto = this.converter.convert((HistoryEvent)event);
        this.assertCommon(proto, HistoryEventType.TASK_ATTEMPT_STARTED, startTime, EntityTypes.TEZ_TASK_ATTEMPT_ID, null, null, 6);
        this.assertEventData(proto, "status", TaskAttemptState.RUNNING.name());
        this.assertEventData(proto, "inProgressLogsURL", "inProgressURL");
        this.assertEventData(proto, "completedLogsURL", "logsURL");
        this.assertEventData(proto, "nodeId", this.nodeId.toString());
        this.assertEventData(proto, "containerId", this.containerId.toString());
        this.assertEventData(proto, "nodeHttpAddress", "nodeHttpAddress");
    }

    @Test(timeout=5000L)
    public void testConvertTaskFinishedEvent() {
        String vertexName = "testVertexName";
        long startTime = this.random.nextLong();
        long finishTime = this.random.nextLong();
        TaskState state = TaskState.values()[this.random.nextInt(TaskState.values().length)];
        String diagnostics = "diagnostics message";
        TezCounters counters = new TezCounters();
        TaskFinishedEvent event = new TaskFinishedEvent(this.tezTaskID, vertexName, startTime, finishTime, this.tezTaskAttemptID, state, diagnostics, counters, 3);
        HistoryLoggerProtos.HistoryEventProto proto = this.converter.convert((HistoryEvent)event);
        this.assertCommon(proto, HistoryEventType.TASK_FINISHED, finishTime, EntityTypes.TEZ_TASK_ID, null, null, 6);
        this.assertEventData(proto, "status", state.name());
        this.assertEventData(proto, "timeTaken", String.valueOf(finishTime - startTime));
        this.assertEventData(proto, "successfulAttemptId", this.tezTaskAttemptID.toString());
        this.assertEventData(proto, "numFailedTaskAttempts", "3");
        this.assertEventData(proto, "diagnostics", diagnostics);
        this.assertEventData(proto, "counters", null);
    }

    @Test(timeout=5000L)
    public void testConvertVertexReconfigreDoneEvent() {
        TezVertexID vId = this.tezVertexID;
        HashMap<String, EdgeProperty> edgeMgrs = new HashMap<String, EdgeProperty>();
        edgeMgrs.put("a", EdgeProperty.create((EdgeManagerPluginDescriptor)((EdgeManagerPluginDescriptor)EdgeManagerPluginDescriptor.create((String)"a.class").setHistoryText("text")), (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"Out"), (InputDescriptor)InputDescriptor.create((String)"In")));
        VertexConfigurationDoneEvent event = new VertexConfigurationDoneEvent(vId, 0L, 1, null, edgeMgrs, null, true);
        HistoryLoggerProtos.HistoryEventProto proto = this.converter.convert((HistoryEvent)event);
        this.assertCommon(proto, HistoryEventType.VERTEX_CONFIGURE_DONE, 0L, EntityTypes.TEZ_VERTEX_ID, null, null, 2);
        this.assertEventData(proto, "numTasks", "1");
        this.assertEventData(proto, "updatedEdgeManagers", null);
    }

    @Test(timeout=5000L)
    public void testConvertDAGRecoveredEvent() {
        long recoverTime = this.random.nextLong();
        DAGRecoveredEvent event = new DAGRecoveredEvent(this.applicationAttemptId, this.tezDAGID, this.dagPlan.getName(), this.user, recoverTime, this.containerLogs);
        HistoryLoggerProtos.HistoryEventProto proto = this.converter.convert((HistoryEvent)event);
        this.assertCommon(proto, HistoryEventType.DAG_RECOVERED, recoverTime, EntityTypes.TEZ_DAG_ID, this.applicationAttemptId, this.user, 2);
        this.assertEventData(proto, "inProgressLogsURL_" + this.applicationAttemptId.getAttemptId(), this.containerLogs);
        this.assertEventData(proto, "dagName", this.dagPlan.getName());
    }

    @Test(timeout=5000L)
    public void testConvertDAGRecoveredEvent2() {
        long recoverTime = this.random.nextLong();
        DAGRecoveredEvent event = new DAGRecoveredEvent(this.applicationAttemptId, this.tezDAGID, this.dagPlan.getName(), this.user, recoverTime, DAGState.ERROR, "mock reason", this.containerLogs);
        HistoryLoggerProtos.HistoryEventProto proto = this.converter.convert((HistoryEvent)event);
        this.assertCommon(proto, HistoryEventType.DAG_RECOVERED, recoverTime, EntityTypes.TEZ_DAG_ID, this.applicationAttemptId, this.user, 4);
        this.assertEventData(proto, "dagState", DAGState.ERROR.name());
        this.assertEventData(proto, "recoveryFailureReason", "mock reason");
        this.assertEventData(proto, "inProgressLogsURL_" + this.applicationAttemptId.getAttemptId(), this.containerLogs);
        this.assertEventData(proto, "dagName", this.dagPlan.getName());
    }

    static class MockVersionInfo
    extends VersionInfo {
        MockVersionInfo() {
            super("component", "1.1.0", "rev1", "20120101", "git.apache.org");
        }
    }
}

