/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.split;

import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.split.SplitLocationProvider;
import org.apache.hadoop.mapred.split.SplitSizeEstimator;
import org.apache.hadoop.mapred.split.TezGroupedSplit;
import org.apache.hadoop.mapred.split.TezGroupedSplitsInputFormat;
import org.apache.hadoop.mapred.split.TezMapredSplitsGrouper;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tez.common.MockDNSToSwitchMapping;
import org.apache.tez.mapreduce.grouper.TezSplitGrouper;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestGroupedSplits {
    private static final Logger LOG = LoggerFactory.getLogger(TestGroupedSplits.class);
    private static JobConf defaultConf = new JobConf();
    private static FileSystem localFs = null;
    private static Path workDir;
    private static final Reporter voidReporter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testFormat() throws Exception {
        JobConf job = new JobConf((Configuration)defaultConf);
        Random random = new Random();
        long seed = random.nextLong();
        LOG.info("seed = " + seed);
        random.setSeed(seed);
        localFs.delete(workDir, true);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{workDir});
        int length = 10000;
        int numFiles = 10;
        TestGroupedSplits.createFiles(10000, 10, random);
        TextInputFormat wrappedFormat = new TextInputFormat();
        wrappedFormat.configure(job);
        TezGroupedSplitsInputFormat format = new TezGroupedSplitsInputFormat();
        format.setConf((Configuration)job);
        format.setDesiredNumberOfSplits(1);
        format.setInputFormat((InputFormat)wrappedFormat);
        LongWritable key = new LongWritable();
        Text value = new Text();
        for (int i = 0; i < 3; ++i) {
            int numSplits = random.nextInt(500) + 1;
            LOG.info("splitting: requesting = " + numSplits);
            InputSplit[] splits = format.getSplits(job, numSplits);
            LOG.info("splitting: got =        " + splits.length);
            Assert.assertEquals((String)"We got more than one splits!", (long)1L, (long)splits.length);
            InputSplit split = splits[0];
            Assert.assertEquals((String)"It should be TezGroupedSplit", TezGroupedSplit.class, split.getClass());
            BitSet bits = new BitSet(10000);
            LOG.debug("split= " + split);
            try (RecordReader reader = format.getRecordReader(split, job, voidReporter);){
                int count = 0;
                while (reader.next((Object)key, (Object)value)) {
                    int v = Integer.parseInt(value.toString());
                    LOG.debug("read " + v);
                    if (bits.get(v)) {
                        LOG.warn("conflict with " + v + " at position " + reader.getPos());
                    }
                    Assert.assertFalse((String)"Key in multiple partitions.", (boolean)bits.get(v));
                    bits.set(v);
                    ++count;
                }
                LOG.info("splits=" + split + " count=" + count);
            }
            Assert.assertEquals((String)"Some keys in no partition.", (long)10000L, (long)bits.cardinality());
        }
    }

    private static Range[] createRanges(int length, int numFiles, Random random) {
        Range[] ranges = new Range[numFiles];
        for (int i = 0; i < numFiles; ++i) {
            int start = i == 0 ? 0 : ranges[i - 1].end;
            int end = i == numFiles - 1 ? length : length / numFiles * (2 * i + 1) / 2 + random.nextInt(length / numFiles) + 1;
            ranges[i] = new Range(start, end);
        }
        return ranges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createFiles(int length, int numFiles, Random random) throws IOException {
        Range[] ranges = TestGroupedSplits.createRanges(length, numFiles, random);
        for (int i = 0; i < numFiles; ++i) {
            Path file = new Path(workDir, "test_" + i + ".txt");
            Range range = ranges[i];
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)localFs.create(file));){
                for (int j = range.start; j < range.end; ++j) {
                    writer.write(Integer.toString(j));
                    writer.write("\n");
                }
                continue;
            }
        }
    }

    private static void writeFile(FileSystem fs, Path name, CompressionCodec codec, String contents) throws IOException {
        Object stm = codec == null ? fs.create(name) : codec.createOutputStream((OutputStream)fs.create(name));
        stm.write(contents.getBytes());
        stm.close();
    }

    private static List<Text> readSplit(InputFormat<LongWritable, Text> format, InputSplit split, JobConf job) throws IOException {
        ArrayList<Text> result = new ArrayList<Text>();
        RecordReader reader = format.getRecordReader(split, job, voidReporter);
        LongWritable key = (LongWritable)reader.createKey();
        Text value = (Text)reader.createValue();
        while (reader.next((Object)key, (Object)value)) {
            result.add(value);
            value = (Text)reader.createValue();
        }
        reader.close();
        return result;
    }

    @BeforeClass
    public static void beforeClass() {
        MockDNSToSwitchMapping.initializeMockRackResolver();
    }

    @Test(timeout=10000L)
    public void testGzip() throws IOException {
        JobConf job = new JobConf((Configuration)defaultConf);
        GzipCodec gzip = new GzipCodec();
        ReflectionUtils.setConf((Object)gzip, (Configuration)job);
        localFs.delete(workDir, true);
        TestGroupedSplits.writeFile(localFs, new Path(workDir, "part1.txt.gz"), (CompressionCodec)gzip, "the quick\nbrown\nfox jumped\nover\n the lazy\n dog\n");
        TestGroupedSplits.writeFile(localFs, new Path(workDir, "part2.txt.gz"), (CompressionCodec)gzip, "is\ngzip\n");
        TestGroupedSplits.writeFile(localFs, new Path(workDir, "part3.txt.gz"), (CompressionCodec)gzip, "one\nmore\nsplit\n");
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{workDir});
        TextInputFormat wrappedFormat = new TextInputFormat();
        wrappedFormat.configure(job);
        TezGroupedSplitsInputFormat format = new TezGroupedSplitsInputFormat();
        format.setConf((Configuration)job);
        format.setInputFormat((InputFormat)wrappedFormat);
        block5: for (int j = 1; j <= 3; ++j) {
            format.setDesiredNumberOfSplits(j);
            InputSplit[] splits = format.getSplits(job, 100);
            if (j == 1) {
                Assert.assertEquals((String)("compressed splits == " + j), (long)j, (long)splits.length);
            }
            ArrayList<Text> results = new ArrayList<Text>();
            for (int i = 0; i < splits.length; ++i) {
                List<Text> read = TestGroupedSplits.readSplit((InputFormat<LongWritable, Text>)format, splits[i], job);
                results.addAll(read);
            }
            Assert.assertEquals((String)"splits length", (long)11L, (long)results.size());
            String[] firstList = new String[]{"the quick", "brown", "fox jumped", "over", " the lazy", " dog"};
            String[] secondList = new String[]{"is", "gzip"};
            String[] thirdList = new String[]{"one", "more", "split"};
            String first = ((Text)results.get(0)).toString();
            int start = 0;
            switch (first.charAt(0)) {
                case 't': {
                    start = TestGroupedSplits.testResults(results, firstList, start);
                    continue block5;
                }
                case 'i': {
                    start = TestGroupedSplits.testResults(results, secondList, start);
                    continue block5;
                }
                case 'o': {
                    start = TestGroupedSplits.testResults(results, thirdList, start);
                    continue block5;
                }
                default: {
                    Assert.fail((String)("unexpected first token - " + first));
                }
            }
        }
    }

    private static int testResults(List<Text> results, String[] first, int start) {
        for (int i = 0; i < first.length; ++i) {
            Assert.assertEquals((String)("splits[" + i + "]"), (Object)first[i], (Object)results.get(start + i).toString());
        }
        return first.length + start;
    }

    @Test(timeout=10000L)
    public void testGroupedSplitSize() throws IOException {
        JobConf job = new JobConf((Configuration)defaultConf);
        InputFormat mockWrappedFormat = (InputFormat)Mockito.mock(InputFormat.class);
        TezGroupedSplitsInputFormat format = new TezGroupedSplitsInputFormat();
        format.setConf((Configuration)job);
        format.setInputFormat(mockWrappedFormat);
        job = (JobConf)TezSplitGrouper.newConfigBuilder((Configuration)job).setGroupingSplitSize(50000000L, 500000000L).build();
        InputSplit mockSplit1 = (InputSplit)Mockito.mock(InputSplit.class);
        Mockito.when((Object)mockSplit1.getLength()).thenReturn((Object)10000000L);
        Mockito.when((Object)mockSplit1.getLocations()).thenReturn(null);
        int numSplits = 100;
        InputSplit[] mockSplits = new InputSplit[numSplits];
        for (int i = 0; i < numSplits; ++i) {
            mockSplits[i] = mockSplit1;
        }
        Mockito.when((Object)mockWrappedFormat.getSplits((JobConf)Mockito.any(), Mockito.anyInt())).thenReturn((Object)mockSplits);
        InputSplit[] splits = format.getSplits(job, 0);
        Assert.assertEquals((long)25L, (long)splits.length);
        format.setDesiredNumberOfSplits(1);
        splits = format.getSplits(job, 0);
        Assert.assertEquals((long)4L, (long)splits.length);
        format.setDesiredNumberOfSplits(1000);
        splits = format.getSplits(job, 0);
        Assert.assertEquals((long)25L, (long)splits.length);
    }

    @Test(timeout=5000L)
    public void testMaintainSplitOrdering() throws IOException {
        int numLocations = 3;
        String[] locations = new String[numLocations];
        InputSplit[] origSplits = new InputSplit[numLocations * 4];
        long splitLength = 100L;
        for (int i = 0; i < numLocations; ++i) {
            locations[i] = "node" + i;
            String[] splitLoc = new String[]{locations[i]};
            for (int j = 0; j < 4; ++j) {
                int pos = i * 4 + j;
                origSplits[pos] = new TestInputSplit(splitLength, splitLoc, pos);
            }
        }
        TezMapredSplitsGrouper grouper = new TezMapredSplitsGrouper();
        JobConf conf = new JobConf((Configuration)defaultConf);
        conf = (JobConf)TezSplitGrouper.newConfigBuilder((Configuration)conf).setGroupingSplitSize(splitLength * 3L, splitLength * 3L).setGroupingRackSplitSizeReduction(1.0f).build();
        InputSplit[] groupedSplits = grouper.getGroupedSplits((Configuration)conf, origSplits, 4, "InputFormat");
        Assert.assertEquals((long)4L, (long)groupedSplits.length);
        for (int i = 0; i < 4; ++i) {
            TezGroupedSplit split = (TezGroupedSplit)groupedSplits[i];
            List innerSplits = split.getGroupedSplits();
            int pos = -1;
            for (InputSplit innerSplit : innerSplits) {
                int splitPos = ((TestInputSplit)innerSplit).getPosition();
                Assert.assertTrue((pos < splitPos ? 1 : 0) != 0);
                pos = splitPos;
            }
            if (i != 3) continue;
            Assert.assertTrue((split.getRack() != null ? 1 : 0) != 0);
        }
    }

    @Test(timeout=5000L)
    public void testRepeatableSplits() throws IOException {
        int i;
        int numLocations = 3;
        String[] locations = new String[numLocations];
        InputSplit[] origSplits = new InputSplit[numLocations * 4];
        long splitLength = 100L;
        for (i = 0; i < numLocations; ++i) {
            locations[i] = "node" + i;
        }
        for (i = 0; i < 4; ++i) {
            String[] splitLoc = null;
            for (int j = 0; j < 3; ++j) {
                int pos = i * 3 + j;
                if (pos < 9) {
                    String[] nodeLoc = new String[]{new String(locations[i]), new String(locations[(i + 1) % numLocations])};
                    splitLoc = nodeLoc;
                } else {
                    String[] rackLoc;
                    splitLoc = rackLoc = new String[]{new String(locations[j])};
                }
                origSplits[pos] = new TestInputSplit(splitLength, splitLoc, pos);
            }
        }
        TezMapredSplitsGrouper grouper = new TezMapredSplitsGrouper();
        JobConf conf = new JobConf((Configuration)defaultConf);
        conf = (JobConf)TezSplitGrouper.newConfigBuilder((Configuration)conf).setGroupingSplitSize(splitLength * 3L, splitLength * 3L).setGroupingRackSplitSizeReduction(1.0f).build();
        InputSplit[] groupedSplits1 = grouper.getGroupedSplits((Configuration)conf, origSplits, 4, "InputFormat");
        InputSplit[] groupedSplits2 = grouper.getGroupedSplits((Configuration)conf, origSplits, 4, "InputFormat");
        Assert.assertEquals((long)4L, (long)groupedSplits1.length);
        Assert.assertEquals((long)4L, (long)groupedSplits2.length);
        for (int i2 = 0; i2 < 4; ++i2) {
            TezGroupedSplit gSplit1 = (TezGroupedSplit)groupedSplits1[i2];
            List testSplits1 = gSplit1.getGroupedSplits();
            TezGroupedSplit gSplit2 = (TezGroupedSplit)groupedSplits2[i2];
            List testSplits2 = gSplit2.getGroupedSplits();
            Assert.assertEquals((long)testSplits1.size(), (long)testSplits2.size());
            for (int j = 0; j < testSplits1.size(); ++j) {
                TestInputSplit split1 = (TestInputSplit)testSplits1.get(j);
                TestInputSplit split2 = (TestInputSplit)testSplits2.get(j);
                Assert.assertEquals((long)split1.position, (long)split2.position);
            }
            if (i2 != 3) continue;
            Assert.assertTrue((gSplit1.getRack() != null ? 1 : 0) != 0);
            Assert.assertTrue((gSplit2.getRack() != null ? 1 : 0) != 0);
        }
    }

    @Test(timeout=30000L)
    public void testS3Scenario() throws IOException {
        String[] locations = new String[]{"localhost"};
        int oriSplits = 52;
        int desiredSplits = 19;
        long splitLength = 231958L;
        InputSplit[] origSplits = new InputSplit[oriSplits];
        for (int i = 0; i < oriSplits; ++i) {
            String[] splitLoc = locations;
            origSplits[i] = new TestInputSplit(splitLength, splitLoc, i);
        }
        TezMapredSplitsGrouper grouper = new TezMapredSplitsGrouper();
        JobConf conf = new JobConf((Configuration)defaultConf);
        conf = (JobConf)TezSplitGrouper.newConfigBuilder((Configuration)conf).build();
        InputSplit[] groupedSplits = grouper.getGroupedSplits((Configuration)conf, origSplits, desiredSplits, "SampleFormat");
        int splitsInGroup = oriSplits / desiredSplits;
        int totalSplits = (int)Math.ceil((double)oriSplits * 1.0 / (double)splitsInGroup);
        Assert.assertEquals((long)totalSplits, (long)groupedSplits.length);
        String[] nonLocalLocations = new String[]{"EmptyLocation", "localhost"};
        origSplits = new InputSplit[oriSplits];
        for (int i = 0; i < oriSplits; ++i) {
            String[] splitLoc = nonLocalLocations;
            origSplits[i] = new TestInputSplit(splitLength, splitLoc, i);
        }
        grouper = new TezMapredSplitsGrouper();
        conf = new JobConf((Configuration)defaultConf);
        conf = (JobConf)TezSplitGrouper.newConfigBuilder((Configuration)conf).build();
        groupedSplits = grouper.getGroupedSplits((Configuration)conf, origSplits, desiredSplits, "SampleFormat");
        Assert.assertEquals((long)1L, (long)groupedSplits.length);
    }

    @Test(timeout=10000L)
    public void testGroupedSplitWithDuplicates() throws IOException {
        JobConf job = new JobConf((Configuration)defaultConf);
        InputFormat mockWrappedFormat = (InputFormat)Mockito.mock(InputFormat.class);
        TezGroupedSplitsInputFormat format = new TezGroupedSplitsInputFormat();
        format.setConf((Configuration)job);
        format.setInputFormat(mockWrappedFormat);
        String[] locations = new String[]{"common", "common", "common"};
        int numSplits = 3;
        InputSplit[] mockSplits = new InputSplit[numSplits];
        for (int i = 0; i < numSplits; ++i) {
            InputSplit mockSplit = (InputSplit)Mockito.mock(InputSplit.class);
            Mockito.when((Object)mockSplit.getLength()).thenReturn((Object)10000000L);
            Mockito.when((Object)mockSplit.getLocations()).thenReturn((Object)locations);
            mockSplits[i] = mockSplit;
        }
        Mockito.when((Object)mockWrappedFormat.getSplits((JobConf)Mockito.any(), Mockito.anyInt())).thenReturn((Object)mockSplits);
        format.setDesiredNumberOfSplits(1);
        InputSplit[] splits = format.getSplits(job, 1);
        Assert.assertEquals((long)1L, (long)splits.length);
        TezGroupedSplit split = (TezGroupedSplit)splits[0];
        Assert.assertEquals((long)numSplits, (long)split.wrappedSplits.size());
        HashSet splitSet = Sets.newHashSet((Iterable)split.wrappedSplits);
        Assert.assertEquals((long)numSplits, (long)splitSet.size());
    }

    @Test(timeout=10000L)
    public void testGroupedSplitWithBadLocations() throws IOException {
        JobConf job = new JobConf((Configuration)defaultConf);
        InputFormat mockWrappedFormat = (InputFormat)Mockito.mock(InputFormat.class);
        TezGroupedSplitsInputFormat format = new TezGroupedSplitsInputFormat();
        format.setConf((Configuration)job);
        format.setInputFormat(mockWrappedFormat);
        int numSplits = 3;
        InputSplit[] mockSplits = new InputSplit[numSplits];
        InputSplit mockSplit1 = (InputSplit)Mockito.mock(InputSplit.class);
        Mockito.when((Object)mockSplit1.getLength()).thenReturn((Object)10000000L);
        Mockito.when((Object)mockSplit1.getLocations()).thenReturn(null);
        mockSplits[0] = mockSplit1;
        InputSplit mockSplit2 = (InputSplit)Mockito.mock(InputSplit.class);
        Mockito.when((Object)mockSplit2.getLength()).thenReturn((Object)10000000L);
        Mockito.when((Object)mockSplit2.getLocations()).thenReturn((Object)new String[]{null});
        mockSplits[1] = mockSplit2;
        InputSplit mockSplit3 = (InputSplit)Mockito.mock(InputSplit.class);
        Mockito.when((Object)mockSplit3.getLength()).thenReturn((Object)10000000L);
        Mockito.when((Object)mockSplit3.getLocations()).thenReturn((Object)new String[]{null, null});
        mockSplits[2] = mockSplit3;
        Mockito.when((Object)mockWrappedFormat.getSplits((JobConf)Mockito.any(), Mockito.anyInt())).thenReturn((Object)mockSplits);
        format.setDesiredNumberOfSplits(1);
        InputSplit[] splits = format.getSplits(job, 1);
        Assert.assertEquals((long)1L, (long)splits.length);
        TezGroupedSplit split = (TezGroupedSplit)splits[0];
        Assert.assertEquals((long)numSplits, (long)split.wrappedSplits.size());
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        split.write((DataOutput)new DataOutputStream(bOut));
    }

    @Test(timeout=10000L)
    public void testGroupedSplitWithBadLocations2() throws IOException {
        JobConf job = new JobConf((Configuration)defaultConf);
        InputFormat mockWrappedFormat = (InputFormat)Mockito.mock(InputFormat.class);
        TezGroupedSplitsInputFormat format = new TezGroupedSplitsInputFormat();
        format.setConf((Configuration)job);
        format.setInputFormat(mockWrappedFormat);
        String validLocation = "validLocation";
        String validLocation2 = "validLocation2";
        int numSplits = 5;
        InputSplit[] mockSplits = new InputSplit[numSplits];
        InputSplit mockSplit1 = (InputSplit)Mockito.mock(InputSplit.class);
        Mockito.when((Object)mockSplit1.getLength()).thenReturn((Object)100000000L);
        Mockito.when((Object)mockSplit1.getLocations()).thenReturn(null);
        mockSplits[0] = mockSplit1;
        InputSplit mockSplit2 = (InputSplit)Mockito.mock(InputSplit.class);
        Mockito.when((Object)mockSplit2.getLength()).thenReturn((Object)100000000L);
        Mockito.when((Object)mockSplit2.getLocations()).thenReturn((Object)new String[]{null});
        mockSplits[1] = mockSplit2;
        InputSplit mockSplit3 = (InputSplit)Mockito.mock(InputSplit.class);
        Mockito.when((Object)mockSplit3.getLength()).thenReturn((Object)100000000L);
        Mockito.when((Object)mockSplit3.getLocations()).thenReturn((Object)new String[]{null, null});
        mockSplits[2] = mockSplit3;
        InputSplit mockSplit4 = (InputSplit)Mockito.mock(InputSplit.class);
        Mockito.when((Object)mockSplit4.getLength()).thenReturn((Object)100000000L);
        Mockito.when((Object)mockSplit4.getLocations()).thenReturn((Object)new String[]{validLocation});
        mockSplits[3] = mockSplit4;
        InputSplit mockSplit5 = (InputSplit)Mockito.mock(InputSplit.class);
        Mockito.when((Object)mockSplit5.getLength()).thenReturn((Object)100000000L);
        Mockito.when((Object)mockSplit5.getLocations()).thenReturn((Object)new String[]{validLocation, null, validLocation2});
        mockSplits[4] = mockSplit4;
        Mockito.when((Object)mockWrappedFormat.getSplits((JobConf)Mockito.any(), Mockito.anyInt())).thenReturn((Object)mockSplits);
        format.setDesiredNumberOfSplits(numSplits);
        InputSplit[] splits = format.getSplits(job, 1);
        Assert.assertEquals((long)numSplits, (long)splits.length);
        for (int i = 0; i < numSplits; ++i) {
            TezGroupedSplit split = (TezGroupedSplit)splits[i];
            Assert.assertEquals((long)1L, (long)split.wrappedSplits.size());
            if (i == 3) {
                Assert.assertEquals((long)1L, (long)split.getLocations().length);
                Assert.assertEquals((Object)validLocation, (Object)split.getLocations()[0]);
            } else if (i == 4) {
                Assert.assertEquals((long)1L, (long)split.getLocations().length);
                Assert.assertTrue((split.getLocations()[0].equals(validLocation) || split.getLocations()[0].equals(validLocation2) ? 1 : 0) != 0);
            } else {
                Assert.assertNull((Object)split.getLocations());
            }
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            split.write((DataOutput)new DataOutputStream(bOut));
        }
    }

    @Test(timeout=10000L)
    public void testGroupedSplitWithEstimator() throws IOException {
        JobConf job = new JobConf((Configuration)defaultConf);
        job = (JobConf)TezSplitGrouper.newConfigBuilder((Configuration)job).setGroupingSplitSize(12000000L, 25000000L).build();
        InputFormat mockWrappedFormat = (InputFormat)Mockito.mock(InputFormat.class);
        TezGroupedSplitsInputFormat format = new TezGroupedSplitsInputFormat();
        format.setConf((Configuration)job);
        format.setInputFormat(mockWrappedFormat);
        InputSplit mockSplit1 = (InputSplit)Mockito.mock(InputSplit.class);
        InputSplit mockSplit2 = (InputSplit)Mockito.mock(InputSplit.class);
        InputSplit mockSplit3 = (InputSplit)Mockito.mock(InputSplit.class);
        String[] locations = new String[]{"common", "common", "common"};
        SplitSizeEstimator estimator = new SplitSizeEstimator(){

            public long getEstimatedSize(InputSplit split) throws IOException {
                LOG.info("Estimating 10x of " + split.getLength());
                return 10L * split.getLength();
            }
        };
        Mockito.when((Object)mockSplit1.getLength()).thenReturn((Object)1000000L);
        Mockito.when((Object)mockSplit1.getLocations()).thenReturn((Object)locations);
        Mockito.when((Object)mockSplit2.getLength()).thenReturn((Object)1000000L);
        Mockito.when((Object)mockSplit2.getLocations()).thenReturn((Object)locations);
        Mockito.when((Object)mockSplit3.getLength()).thenReturn((Object)2000001L);
        Mockito.when((Object)mockSplit3.getLocations()).thenReturn((Object)locations);
        InputSplit[] mockSplits = new InputSplit[]{mockSplit1, mockSplit2, mockSplit3};
        Mockito.when((Object)mockWrappedFormat.getSplits((JobConf)Mockito.any(), Mockito.anyInt())).thenReturn((Object)mockSplits);
        format.setDesiredNumberOfSplits(1);
        format.setSplitSizeEstimator(estimator);
        InputSplit[] splits = format.getSplits(job, 1);
        Assert.assertEquals((long)2L, (long)splits.length);
        for (InputSplit group : splits) {
            TezGroupedSplit split = (TezGroupedSplit)group;
            if (split.wrappedSplits.size() == 2) {
                Assert.assertEquals((long)split.getLength(), (long)2000000L);
                continue;
            }
            Assert.assertEquals((long)split.getLength(), (long)2000001L);
        }
    }

    @Test(timeout=10000L)
    public void testGroupingWithCustomLocations1() throws IOException {
        int numSplits = 3;
        InputSplit[] mockSplits = new InputSplit[numSplits];
        InputSplit mockSplit1 = (InputSplit)Mockito.mock(InputSplit.class);
        Mockito.when((Object)mockSplit1.getLength()).thenReturn((Object)100000000L);
        Mockito.when((Object)mockSplit1.getLocations()).thenReturn((Object)new String[]{"location1", "location2"});
        mockSplits[0] = mockSplit1;
        InputSplit mockSplit2 = (InputSplit)Mockito.mock(InputSplit.class);
        Mockito.when((Object)mockSplit2.getLength()).thenReturn((Object)100000000L);
        Mockito.when((Object)mockSplit2.getLocations()).thenReturn((Object)new String[]{"location3", "location4"});
        mockSplits[1] = mockSplit2;
        InputSplit mockSplit3 = (InputSplit)Mockito.mock(InputSplit.class);
        Mockito.when((Object)mockSplit3.getLength()).thenReturn((Object)100000000L);
        Mockito.when((Object)mockSplit3.getLocations()).thenReturn((Object)new String[]{"location5", "location6"});
        mockSplits[2] = mockSplit3;
        SplitLocationProvider locationProvider = new SplitLocationProvider(){

            public String[] getLocations(InputSplit split) throws IOException {
                return new String[]{"customLocation"};
            }
        };
        TezMapredSplitsGrouper splitsGrouper = new TezMapredSplitsGrouper();
        InputSplit[] groupedSplits = splitsGrouper.getGroupedSplits(new Configuration((Configuration)defaultConf), mockSplits, 1, "MockInputForamt", null, locationProvider);
        Assert.assertEquals((long)1L, (long)groupedSplits.length);
        Assert.assertTrue((boolean)(groupedSplits[0] instanceof TezGroupedSplit));
        TezGroupedSplit groupedSplit = (TezGroupedSplit)groupedSplits[0];
        Assert.assertEquals((long)3L, (long)groupedSplit.getGroupedSplits().size());
        Assert.assertEquals((long)1L, (long)groupedSplit.getLocations().length);
        Assert.assertEquals((Object)"customLocation", (Object)groupedSplit.getLocations()[0]);
    }

    @Test(timeout=10000L)
    public void testGroupingWithCustomLocations2() throws IOException {
        int numSplits = 3;
        InputSplit[] mockSplits = new InputSplit[numSplits];
        InputSplit mockSplit1 = (InputSplit)Mockito.mock(InputSplit.class);
        Mockito.when((Object)mockSplit1.getLength()).thenReturn((Object)100000000L);
        Mockito.when((Object)mockSplit1.getLocations()).thenReturn((Object)new String[]{"location1", "location2"});
        mockSplits[0] = mockSplit1;
        InputSplit mockSplit2 = (InputSplit)Mockito.mock(InputSplit.class);
        Mockito.when((Object)mockSplit2.getLength()).thenReturn((Object)100000000L);
        Mockito.when((Object)mockSplit2.getLocations()).thenReturn((Object)new String[]{"location3", "location4"});
        mockSplits[1] = mockSplit2;
        InputSplit mockSplit3 = (InputSplit)Mockito.mock(InputSplit.class);
        Mockito.when((Object)mockSplit3.getLength()).thenReturn((Object)100000000L);
        Mockito.when((Object)mockSplit3.getLocations()).thenReturn((Object)new String[]{"location5", "location6"});
        mockSplits[2] = mockSplit3;
        SplitLocationProvider locationProvider = new SplitLocationProvider(){

            public String[] getLocations(InputSplit split) throws IOException {
                return new String[]{"customLocation"};
            }
        };
        TezMapredSplitsGrouper splitsGrouper = new TezMapredSplitsGrouper();
        InputSplit[] groupedSplits = splitsGrouper.getGroupedSplits(new Configuration((Configuration)defaultConf), mockSplits, 3, "MockInputForamt", null, locationProvider);
        Assert.assertEquals((long)3L, (long)groupedSplits.length);
        for (int i = 0; i < 3; ++i) {
            Assert.assertTrue((boolean)(groupedSplits[i] instanceof TezGroupedSplit));
            TezGroupedSplit groupedSplit = (TezGroupedSplit)groupedSplits[i];
            Assert.assertEquals((long)1L, (long)groupedSplit.getGroupedSplits().size());
            Assert.assertEquals((long)1L, (long)groupedSplit.getLocations().length);
            Assert.assertEquals((Object)"customLocation", (Object)groupedSplit.getLocations()[0]);
        }
    }

    @Test(timeout=5000L)
    public void testForceNodeLocalSplits() throws IOException {
        int numLocations = 7;
        long splitLen = 100L;
        String[] locations = new String[numLocations];
        for (int i = 0; i < numLocations; ++i) {
            locations[i] = "node" + i;
        }
        int numSplits = 27;
        InputSplit[] rawSplits = new InputSplit[numSplits];
        for (int i = 0; i < 27; ++i) {
            String[] splitLoc = new String[]{i < 24 ? locations[i % 4] : locations[4 + i % 24]};
            rawSplits[i] = new TestInputSplit(splitLen, splitLoc, i);
        }
        TezMapredSplitsGrouper grouper = new TezMapredSplitsGrouper();
        JobConf confDisallowSmallEarly = new JobConf((Configuration)defaultConf);
        confDisallowSmallEarly = (JobConf)TezSplitGrouper.newConfigBuilder((Configuration)confDisallowSmallEarly).setGroupingSplitSize(splitLen * 3L, splitLen * 3L).setGroupingRackSplitSizeReduction(1.0f).setNodeLocalGroupsOnly(false).build();
        JobConf confSmallEarly = new JobConf((Configuration)defaultConf);
        confSmallEarly = (JobConf)TezSplitGrouper.newConfigBuilder((Configuration)confSmallEarly).setGroupingSplitSize(splitLen * 3L, splitLen * 3L).setGroupingRackSplitSizeReduction(1.0f).setNodeLocalGroupsOnly(true).build();
        InputSplit[] groupedSplitsDisallowSmallEarly = grouper.getGroupedSplits((Configuration)confDisallowSmallEarly, rawSplits, 9, "InputFormat");
        Assert.assertEquals((long)9L, (long)groupedSplitsDisallowSmallEarly.length);
        HashMap matchedLocations = new HashMap();
        this.verifySplitsFortestAllowSmallSplitsEarly(groupedSplitsDisallowSmallEarly);
        TezGroupedSplit group = (TezGroupedSplit)groupedSplitsDisallowSmallEarly[8];
        Assert.assertEquals((long)3L, (long)group.getLocations().length);
        Assert.assertEquals((long)3L, (long)group.getGroupedSplits().size());
        HashSet exp = Sets.newHashSet((Object[])new String[]{locations[4], locations[5], locations[6]});
        for (int i = 0; i < 3; ++i) {
            LOG.info(group.getLocations()[i]);
            exp.remove(group.getLocations()[i]);
        }
        Assert.assertEquals((long)0L, (long)exp.size());
        InputSplit[] groupedSplitsSmallEarly = grouper.getGroupedSplits((Configuration)confSmallEarly, rawSplits, 9, "InputFormat");
        Assert.assertEquals((long)11L, (long)groupedSplitsSmallEarly.length);
        this.verifySplitsFortestAllowSmallSplitsEarly(groupedSplitsSmallEarly);
        exp = Sets.newHashSet((Object[])new String[]{locations[4], locations[5], locations[6]});
        for (int i = 8; i < 11; ++i) {
            group = (TezGroupedSplit)groupedSplitsSmallEarly[i];
            Assert.assertEquals((long)1L, (long)group.getLocations().length);
            Assert.assertEquals((long)1L, (long)group.getGroupedSplits().size());
            String matchedLoc = group.getLocations()[0];
            Assert.assertTrue((boolean)exp.contains(matchedLoc));
            exp.remove(matchedLoc);
        }
        Assert.assertEquals((long)0L, (long)exp.size());
    }

    private void verifySplitsFortestAllowSmallSplitsEarly(InputSplit[] groupedSplits) throws IOException {
        HashMap<String, MutableInt> matchedLocations = new HashMap<String, MutableInt>();
        for (int i = 0; i < 8; ++i) {
            TezGroupedSplit group = (TezGroupedSplit)groupedSplits[i];
            Assert.assertEquals((long)1L, (long)group.getLocations().length);
            Assert.assertEquals((long)3L, (long)group.getGroupedSplits().size());
            String matchedLoc = group.getLocations()[0];
            MutableInt count = (MutableInt)matchedLocations.get(matchedLoc);
            if (count == null) {
                count = new MutableInt(0);
                matchedLocations.put(matchedLoc, count);
            }
            count.increment();
        }
        for (Map.Entry entry : matchedLocations.entrySet()) {
            String loc = (String)entry.getKey();
            int nodeId = Character.getNumericValue(loc.charAt(loc.length() - 1));
            Assert.assertTrue((nodeId < 4 ? 1 : 0) != 0);
            Assert.assertTrue((loc.startsWith("node") && loc.length() == 5 ? 1 : 0) != 0);
            Assert.assertEquals((Object)2, (Object)((MutableInt)entry.getValue()).getValue());
        }
    }

    static {
        try {
            defaultConf.set("fs.defaultFS", "file:///");
            localFs = FileSystem.getLocal((Configuration)defaultConf);
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
        workDir = new Path(new Path(System.getProperty("test.build.data", "/tmp")), "TestCombineTextInputFormat").makeQualified(localFs);
        voidReporter = Reporter.NULL;
    }

    class TestInputSplit
    implements InputSplit {
        long length;
        String[] locations;
        int position;

        public TestInputSplit(long length, String[] locations, int position) {
            this.length = length;
            this.locations = locations;
            this.position = position;
        }

        public void write(DataOutput out) throws IOException {
        }

        public void readFields(DataInput in) throws IOException {
        }

        public long getLength() throws IOException {
            return this.length;
        }

        public String[] getLocations() throws IOException {
            return this.locations;
        }

        public int getPosition() {
            return this.position;
        }
    }

    private static class Range {
        private final int start;
        private final int end;

        Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return "(" + this.start + ", " + this.end + ")";
        }
    }
}

