/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.analyzer.plugins;

import com.google.common.collect.Lists;
import com.google.common.collect.TreeMultiset;
import java.util.Comparator;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tez.analyzer.Analyzer;
import org.apache.tez.analyzer.CSVResult;
import org.apache.tez.analyzer.plugins.TezAnalyzerBase;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.history.parser.datamodel.DagInfo;
import org.apache.tez.history.parser.datamodel.TaskAttemptInfo;
import org.apache.tez.history.parser.datamodel.VertexInfo;

public class TaskConcurrencyAnalyzer
extends TezAnalyzerBase
implements Analyzer {
    private static final String[] headers = new String[]{"time", "vertexName", "concurrentTasksRunning"};
    private final CSVResult csvResult = new CSVResult(headers);

    public TaskConcurrencyAnalyzer(Configuration conf) {
        super(conf);
    }

    @Override
    public void analyze(DagInfo dagInfo) throws TezException {
        for (VertexInfo vertexInfo : dagInfo.getVertices()) {
            LinkedList taskAttempts = Lists.newLinkedList((Iterable)vertexInfo.getTaskAttempts(true, null));
            String vertexName = vertexInfo.getVertexName();
            TreeMultiset timeInfoSet = TreeMultiset.create((Comparator)new Comparator<TimeInfo>(){

                @Override
                public int compare(TimeInfo o1, TimeInfo o2) {
                    if (o1.timestamp < o2.timestamp) {
                        return -1;
                    }
                    if (o1.timestamp > o2.timestamp) {
                        return 1;
                    }
                    if (o1.timestamp == o2.timestamp) {
                        if (o1.eventType.equals((Object)o2.eventType)) {
                            return 0;
                        }
                        if (o1.eventType.equals((Object)EventType.START) && o2.eventType.equals((Object)EventType.FINISH)) {
                            return -1;
                        }
                        return 1;
                    }
                    return 0;
                }
            });
            for (TaskAttemptInfo attemptInfo : taskAttempts) {
                TimeInfo startTimeInfo = new TimeInfo(EventType.START, attemptInfo.getStartTime());
                TimeInfo stopTimeInfo = new TimeInfo(EventType.FINISH, attemptInfo.getFinishTime());
                timeInfoSet.add((Object)startTimeInfo);
                timeInfoSet.add((Object)stopTimeInfo);
            }
            int concurrentTasks = 0;
            for (TimeInfo timeInfo : timeInfoSet.elementSet()) {
                switch (timeInfo.eventType) {
                    case START: {
                        concurrentTasks += timeInfoSet.count((Object)timeInfo);
                        break;
                    }
                    case FINISH: {
                        concurrentTasks -= timeInfoSet.count((Object)timeInfo);
                        break;
                    }
                }
                timeInfo.concurrentTasks = concurrentTasks;
                this.addToResult(vertexName, timeInfo.timestamp, timeInfo.concurrentTasks);
            }
        }
    }

    private void addToResult(String vertexName, long currentTime, int concurrentTasks) {
        String[] record = new String[]{"" + currentTime, vertexName, "" + concurrentTasks};
        this.csvResult.addRecord(record);
    }

    @Override
    public CSVResult getResult() throws TezException {
        return this.csvResult;
    }

    @Override
    public String getName() {
        return "TaskConcurrencyAnalyzer";
    }

    @Override
    public String getDescription() {
        return "Analyze how many tasks were running in every vertex at given point in time. This would be helpful in understanding whether any starvation was there or not.";
    }

    public static void main(String[] args) throws Exception {
        Configuration config = new Configuration();
        TaskConcurrencyAnalyzer analyzer = new TaskConcurrencyAnalyzer(config);
        int res = ToolRunner.run((Configuration)config, (Tool)analyzer, (String[])args);
        analyzer.printResults();
        System.exit(res);
    }

    static class TimeInfo {
        EventType eventType;
        long timestamp;
        int concurrentTasks;

        public TimeInfo(EventType eventType, long timestamp) {
            this.eventType = eventType;
            this.timestamp = timestamp;
        }
    }

    private static enum EventType {
        START,
        FINISH;

    }
}

