/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.analyzer.plugins;

import com.google.common.base.Functions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tez.analyzer.Analyzer;
import org.apache.tez.analyzer.CSVResult;
import org.apache.tez.analyzer.plugins.TezAnalyzerBase;
import org.apache.tez.analyzer.utils.Utils;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.history.parser.datamodel.DagInfo;
import org.apache.tez.history.parser.datamodel.VertexInfo;

public class VertexLevelCriticalPathAnalyzer
extends TezAnalyzerBase
implements Analyzer {
    private static final String[] headers = new String[]{"CriticalPath", "Score"};
    private final CSVResult csvResult = new CSVResult(headers);
    private static final String DOT_FILE_DIR = "tez.critical-path.analyzer.dot.output.loc";
    private static final String DOT_FILE_DIR_DEFAULT = ".";
    private final String dotFileLocation;
    private static final String CONNECTOR = "-->";

    public VertexLevelCriticalPathAnalyzer(Configuration config) {
        super(config);
        this.dotFileLocation = config.get(DOT_FILE_DIR, DOT_FILE_DIR_DEFAULT);
    }

    @Override
    public void analyze(DagInfo dagInfo) throws TezException {
        LinkedHashMap result = Maps.newLinkedHashMap();
        VertexLevelCriticalPathAnalyzer.getCriticalPath("", (VertexInfo)dagInfo.getVertices().get(dagInfo.getVertices().size() - 1), 0L, result);
        Map<String, Long> sortedByValues = VertexLevelCriticalPathAnalyzer.sortByValues(result);
        for (Map.Entry<String, Long> entry : sortedByValues.entrySet()) {
            LinkedList record = Lists.newLinkedList();
            record.add(entry.getKey());
            record.add("" + entry.getValue());
            this.csvResult.addRecord(record.toArray(new String[record.size()]));
        }
        String dotFile = this.dotFileLocation + File.separator + dagInfo.getDagId() + ".dot";
        try {
            List<Object> criticalVertices = null;
            if (!sortedByValues.isEmpty()) {
                String criticalPath = sortedByValues.keySet().iterator().next();
                criticalVertices = VertexLevelCriticalPathAnalyzer.getVertexNames(criticalPath);
            } else {
                criticalVertices = Lists.newLinkedList();
            }
            Utils.generateDAGVizFile(dagInfo, dotFile, criticalVertices);
        }
        catch (IOException e) {
            throw new TezException((Throwable)e);
        }
    }

    @Override
    public CSVResult getResult() throws TezException {
        return this.csvResult;
    }

    @Override
    public String getName() {
        return "CriticalPathAnalyzer";
    }

    @Override
    public String getDescription() {
        return "Analyze vertex level critical path of the DAG";
    }

    private static Map<String, Long> sortByValues(Map<String, Long> result) {
        Ordering reversValueOrdering = Ordering.natural().reverse().nullsLast().onResultOf(Functions.forMap(result, null));
        ImmutableSortedMap orderedMap = ImmutableSortedMap.copyOf(result, (Comparator)reversValueOrdering);
        return orderedMap;
    }

    private static void getCriticalPath(String predecessor, VertexInfo dest, long time, Map<String, Long> result) {
        String destVertexName;
        String string = destVertexName = dest != null ? dest.getVertexName() : "";
        if (dest != null) {
            time += dest.getTimeTaken();
            predecessor = (String)predecessor + destVertexName + CONNECTOR;
            for (VertexInfo incomingVertex : dest.getInputVertices()) {
                VertexLevelCriticalPathAnalyzer.getCriticalPath((String)predecessor, incomingVertex, time, result);
            }
            result.put((String)predecessor, time);
        }
    }

    private static List<String> getVertexNames(String criticalPath) {
        if (Strings.isNullOrEmpty((String)criticalPath)) {
            return Lists.newLinkedList();
        }
        return Lists.newLinkedList((Iterable)Splitter.on((String)CONNECTOR).trimResults().omitEmptyStrings().split((CharSequence)criticalPath));
    }

    public static void main(String[] args) throws Exception {
        Configuration config = new Configuration();
        VertexLevelCriticalPathAnalyzer analyzer = new VertexLevelCriticalPathAnalyzer(config);
        int res = ToolRunner.run((Configuration)config, (Tool)analyzer, (String[])args);
        analyzer.printResults();
        System.exit(res);
    }
}

