/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.analyzer.plugins;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tez.analyzer.Analyzer;
import org.apache.tez.analyzer.CSVResult;
import org.apache.tez.analyzer.plugins.TezAnalyzerBase;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.history.parser.datamodel.DagInfo;
import org.apache.tez.history.parser.datamodel.TaskAttemptInfo;
import org.apache.tez.history.parser.datamodel.VertexInfo;

public class SpillAnalyzerImpl
extends TezAnalyzerBase
implements Analyzer {
    private static final String[] headers = new String[]{"vertexName", "taskAttemptId", "Node", "counterGroupName", "spillCount", "taskDuration", "OUTPUT_BYTES", "OUTPUT_RECORDS", "SPILLED_RECORDS", "Recommendation"};
    private final CSVResult csvResult;
    private static final String OUTPUT_BYTES_THRESHOLD = "tez.spill-analyzer.min.output.bytes.threshold";
    private static long OUTPUT_BYTES_THRESHOLD_DEFAULT = 0x40000000L;
    private final long minOutputBytesPerTask;

    public SpillAnalyzerImpl(Configuration config) {
        super(config);
        this.minOutputBytesPerTask = Math.max(0L, config.getLong(OUTPUT_BYTES_THRESHOLD, OUTPUT_BYTES_THRESHOLD_DEFAULT));
        this.csvResult = new CSVResult(headers);
    }

    @Override
    public void analyze(DagInfo dagInfo) throws TezException {
        for (VertexInfo vertexInfo : dagInfo.getVertices()) {
            String vertexName = vertexInfo.getVertexName();
            for (TaskAttemptInfo attemptInfo : vertexInfo.getTaskAttempts()) {
                Map spillCountMap = attemptInfo.getCounter(TaskCounter.ADDITIONAL_SPILL_COUNT.name());
                Map spilledRecordsMap = attemptInfo.getCounter(TaskCounter.SPILLED_RECORDS.name());
                Map outputRecordsMap = attemptInfo.getCounter(TaskCounter.OUTPUT_RECORDS.name());
                Map outputBytesMap = attemptInfo.getCounter(TaskCounter.OUTPUT_BYTES.name());
                for (Map.Entry entry : spillCountMap.entrySet()) {
                    String source = (String)entry.getKey();
                    long spillCount = ((TezCounter)entry.getValue()).getValue();
                    long outBytes = ((TezCounter)outputBytesMap.get(source)).getValue();
                    long outputRecords = ((TezCounter)outputRecordsMap.get(source)).getValue();
                    long spilledRecords = ((TezCounter)spilledRecordsMap.get(source)).getValue();
                    if (spillCount <= 1L || outBytes <= this.minOutputBytesPerTask) continue;
                    LinkedList recorList = Lists.newLinkedList();
                    recorList.add(vertexName);
                    recorList.add(attemptInfo.getTaskAttemptId());
                    recorList.add(attemptInfo.getNodeId());
                    recorList.add(source);
                    recorList.add("" + spillCount);
                    recorList.add("" + attemptInfo.getTimeTaken());
                    recorList.add("" + outBytes);
                    recorList.add("" + outputRecords);
                    recorList.add("" + spilledRecords);
                    recorList.add("Consider increasing tez.runtime.io.sort.mb. Try increasing container size.");
                    this.csvResult.addRecord(recorList.toArray(new String[recorList.size()]));
                }
            }
        }
    }

    @Override
    public CSVResult getResult() throws TezException {
        return this.csvResult;
    }

    @Override
    public String getName() {
        return "SpillAnalyzer";
    }

    @Override
    public String getDescription() {
        return "Analyze spill details in the task";
    }

    public static void main(String[] args) throws Exception {
        Configuration config = new Configuration();
        SpillAnalyzerImpl analyzer = new SpillAnalyzerImpl(config);
        int res = ToolRunner.run((Configuration)config, (Tool)analyzer, (String[])args);
        analyzer.printResults();
        System.exit(res);
    }
}

