/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.service.impl;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.StringUtils;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.TezExecutors;
import org.apache.tez.common.TezSharedExecutor;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.service.ContainerRunner;
import org.apache.tez.service.impl.ContainerRunnerImpl;
import org.apache.tez.service.impl.TezTestServiceProtocolServerImpl;
import org.apache.tez.shufflehandler.ShuffleHandler;
import org.apache.tez.test.service.rpc.TezTestServiceProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezTestService
extends AbstractService
implements ContainerRunner {
    private static final Logger LOG = LoggerFactory.getLogger(TezTestService.class);
    private final Configuration shuffleHandlerConf;
    private final int numExecutors;
    private final TezTestServiceProtocolServerImpl server;
    private final ContainerRunnerImpl containerRunner;
    private final String[] localDirs;
    private final AtomicInteger numSubmissions = new AtomicInteger(0);
    private final AtomicReference<InetSocketAddress> address = new AtomicReference();
    private final TezExecutors sharedExecutor;

    public TezTestService(Configuration conf, int numExecutors, long memoryAvailable, String[] localDirs) {
        super(TezTestService.class.getSimpleName());
        this.numExecutors = numExecutors;
        this.localDirs = localDirs;
        long memoryAvailableBytes = memoryAvailable;
        long jvmMax = Runtime.getRuntime().maxMemory();
        LOG.info(TezTestService.class.getSimpleName() + " created with the following configuration: numExecutors=" + numExecutors + ", workDirs=" + Arrays.toString(localDirs) + ", memoryAvailable=" + memoryAvailable + ", jvmMaxMemory=" + jvmMax);
        Preconditions.checkArgument((this.numExecutors > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((this.localDirs != null && this.localDirs.length > 0 ? 1 : 0) != 0, (Object)"Work dirs must be specified");
        Preconditions.checkState((jvmMax >= memoryAvailableBytes ? 1 : 0) != 0, (Object)("Invalid configuration. Xmx value too small. maxAvailable=" + jvmMax + ", configured=" + memoryAvailableBytes));
        this.shuffleHandlerConf = new Configuration(conf);
        this.shuffleHandlerConf.setInt("tez.shuffle.port", 0);
        this.shuffleHandlerConf.set("tez.shuffle.handler.local-dirs", StringUtils.arrayToString((String[])localDirs));
        this.server = new TezTestServiceProtocolServerImpl(this, this.address);
        this.sharedExecutor = new TezSharedExecutor(conf);
        this.containerRunner = new ContainerRunnerImpl(numExecutors, localDirs, this.address, memoryAvailableBytes, this.sharedExecutor);
    }

    public void serviceInit(Configuration conf) {
        this.server.init(conf);
        this.containerRunner.init(conf);
    }

    public void serviceStart() throws Exception {
        ShuffleHandler.initializeAndStart(this.shuffleHandlerConf);
        String auxiliaryService = this.getConfig().get("tez.am.shuffle.auxiliary-service.id", "mapreduce_shuffle");
        this.containerRunner.setShufflePort(auxiliaryService, ShuffleHandler.get().getPort());
        this.server.start();
        this.containerRunner.start();
    }

    public void serviceStop() throws Exception {
        this.containerRunner.stop();
        this.server.stop();
        ShuffleHandler.get().stop();
        this.sharedExecutor.shutdownNow();
    }

    public InetSocketAddress getListenerAddress() {
        return this.server.getBindAddress();
    }

    public int getShufflePort() {
        return ShuffleHandler.get().getPort();
    }

    @Override
    public void queueContainer(TezTestServiceProtocolProtos.RunContainerRequestProto request) throws TezException {
        this.numSubmissions.incrementAndGet();
        this.containerRunner.queueContainer(request);
    }

    @Override
    public void submitWork(TezTestServiceProtocolProtos.SubmitWorkRequestProto request) throws TezException {
        this.numSubmissions.incrementAndGet();
        this.containerRunner.submitWork(request);
    }

    public int getNumSubmissions() {
        return this.numSubmissions.get();
    }
}

