/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.service.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.BlockingService;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.service.AbstractService;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.service.ContainerRunner;
import org.apache.tez.service.TezTestServiceProtocolBlockingPB;
import org.apache.tez.test.service.rpc.TezTestServiceProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezTestServiceProtocolServerImpl
extends AbstractService
implements TezTestServiceProtocolBlockingPB {
    private static final Logger LOG = LoggerFactory.getLogger(TezTestServiceProtocolServerImpl.class);
    private final ContainerRunner containerRunner;
    private RPC.Server server;
    private final AtomicReference<InetSocketAddress> bindAddress;

    public TezTestServiceProtocolServerImpl(ContainerRunner containerRunner, AtomicReference<InetSocketAddress> address) {
        super(TezTestServiceProtocolServerImpl.class.getSimpleName());
        this.containerRunner = containerRunner;
        this.bindAddress = address;
    }

    public TezTestServiceProtocolProtos.RunContainerResponseProto runContainer(RpcController controller, TezTestServiceProtocolProtos.RunContainerRequestProto request) throws ServiceException {
        LOG.info("Received request: " + request);
        try {
            this.containerRunner.queueContainer(request);
        }
        catch (TezException e) {
            throw new ServiceException((Throwable)e);
        }
        return TezTestServiceProtocolProtos.RunContainerResponseProto.getDefaultInstance();
    }

    public TezTestServiceProtocolProtos.SubmitWorkResponseProto submitWork(RpcController controller, TezTestServiceProtocolProtos.SubmitWorkRequestProto request) throws ServiceException {
        LOG.info("Received submitWork request: " + request);
        try {
            this.containerRunner.submitWork(request);
        }
        catch (TezException e) {
            throw new ServiceException((Throwable)e);
        }
        return TezTestServiceProtocolProtos.SubmitWorkResponseProto.getDefaultInstance();
    }

    public void serviceStart() {
        Configuration conf = this.getConfig();
        int numHandlers = 3;
        InetSocketAddress addr = new InetSocketAddress(0);
        try {
            this.server = this.createServer(TezTestServiceProtocolBlockingPB.class, addr, conf, numHandlers, TezTestServiceProtocolProtos.TezTestServiceProtocol.newReflectiveBlockingService((TezTestServiceProtocolProtos.TezTestServiceProtocol.BlockingInterface)this));
            this.server.start();
        }
        catch (IOException e) {
            LOG.error("Failed to run RPC Server", (Throwable)e);
            throw new RuntimeException(e);
        }
        InetSocketAddress serverBindAddress = NetUtils.getConnectAddress((Server)this.server);
        this.bindAddress.set(NetUtils.createSocketAddrForHost((String)serverBindAddress.getAddress().getCanonicalHostName(), (int)serverBindAddress.getPort()));
        LOG.info("Instantiated TestTestServiceListener at " + this.bindAddress);
    }

    public void serviceStop() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    InetSocketAddress getBindAddress() {
        return this.bindAddress.get();
    }

    private RPC.Server createServer(Class<?> pbProtocol, InetSocketAddress addr, Configuration conf, int numHandlers, BlockingService blockingService) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, pbProtocol, ProtobufRpcEngine.class);
        RPC.Server server = new RPC.Builder(conf).setProtocol(pbProtocol).setInstance((Object)blockingService).setBindAddress(addr.getHostName()).setPort(0).setNumHandlers(numHandlers).build();
        return server;
    }
}

