/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.service;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.tez.common.Preconditions;
import org.apache.tez.service.impl.TezTestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniTezTestServiceCluster
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(MiniTezTestServiceCluster.class);
    private final File testWorkDir;
    private final long availableMemory;
    private final int numExecutorsPerService;
    private final String[] localDirs;
    private final Configuration clusterSpecificConfiguration = new Configuration(false);
    private TezTestService tezTestService;

    public static MiniTezTestServiceCluster create(String clusterName, int numExecutorsPerService, long availableMemory, int numLocalDirs) {
        return new MiniTezTestServiceCluster(clusterName, numExecutorsPerService, availableMemory, numLocalDirs);
    }

    private MiniTezTestServiceCluster(String clusterName, int numExecutorsPerService, long availableMemory, int numLocalDirs) {
        super(clusterName + "_TezTestServerCluster");
        Preconditions.checkArgument((numExecutorsPerService > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((availableMemory > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((numLocalDirs > 0 ? 1 : 0) != 0);
        String clusterNameTrimmed = clusterName.replace("$", "") + "_TezTestServerCluster";
        File targetWorkDir = new File("target", clusterNameTrimmed);
        try {
            FileContext.getLocalFSFileContext().delete(new Path(targetWorkDir.getAbsolutePath()), true);
        }
        catch (Exception e) {
            LOG.warn("Could not cleanup test workDir: " + targetWorkDir, (Throwable)e);
            throw new RuntimeException("Could not cleanup test workDir: " + targetWorkDir, e);
        }
        if (Shell.WINDOWS) {
            String targetPath = targetWorkDir.getAbsolutePath();
            File link = new File(System.getProperty("java.io.tmpdir"), String.valueOf(System.currentTimeMillis()));
            String linkPath = link.getAbsolutePath();
            try {
                FileContext.getLocalFSFileContext().delete(new Path(linkPath), true);
            }
            catch (IOException e) {
                throw new YarnRuntimeException("could not cleanup symlink: " + linkPath, (Throwable)e);
            }
            targetWorkDir.mkdirs();
            Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(Shell.getSymlinkCommand((String)targetPath, (String)linkPath));
            try {
                shexec.execute();
            }
            catch (IOException e) {
                throw new YarnRuntimeException(String.format("failed to create symlink from %s to %s, shell output: %s", linkPath, targetPath, shexec.getOutput()), (Throwable)e);
            }
            this.testWorkDir = link;
        } else {
            this.testWorkDir = targetWorkDir;
        }
        this.numExecutorsPerService = numExecutorsPerService;
        this.availableMemory = availableMemory;
        this.localDirs = new String[numLocalDirs];
        for (int i = 0; i < numLocalDirs; ++i) {
            File f = new File(this.testWorkDir, "localDir");
            f.mkdirs();
            LOG.info("Created localDir: " + f.getAbsolutePath());
            this.localDirs[i] = f.getAbsolutePath();
        }
    }

    public void serviceInit(Configuration conf) {
        this.tezTestService = new TezTestService(conf, this.numExecutorsPerService, this.availableMemory, this.localDirs);
        this.tezTestService.init(conf);
    }

    public void serviceStart() {
        this.tezTestService.start();
        this.clusterSpecificConfiguration.set("tez.test.service.hosts", this.getServiceAddress().getHostName());
        this.clusterSpecificConfiguration.setInt("tez.test.service.rpc.port", this.getServiceAddress().getPort());
        this.clusterSpecificConfiguration.setInt("tez.test.service.num.executors.per-instance", this.numExecutorsPerService);
        this.clusterSpecificConfiguration.setLong("tez.test.service.memory.per.instance.mb", this.availableMemory);
    }

    public void serviceStop() {
        if (this.tezTestService != null) {
            this.tezTestService.stop();
            this.tezTestService = null;
        }
    }

    public InetSocketAddress getServiceAddress() {
        Preconditions.checkState((this.getServiceState() == Service.STATE.STARTED ? 1 : 0) != 0);
        return this.tezTestService.getListenerAddress();
    }

    public int getShufflePort() {
        Preconditions.checkState((this.getServiceState() == Service.STATE.STARTED ? 1 : 0) != 0);
        return this.tezTestService.getShufflePort();
    }

    public Configuration getClusterSpecificConfiguration() {
        Preconditions.checkState((this.getServiceState() == Service.STATE.STARTED ? 1 : 0) != 0);
        return this.clusterSpecificConfiguration;
    }

    public int getNumSubmissions() {
        return this.tezTestService.getNumSubmissions();
    }
}

