/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.examples;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.examples.JoinValidate;

public class JoinValidateConfigured
extends JoinValidate {
    private final Vertex.VertexExecutionContext defaultExecutionContext;
    private final Vertex.VertexExecutionContext lhsContext;
    private final Vertex.VertexExecutionContext rhsContext;
    private final Vertex.VertexExecutionContext validateContext;
    private final String dagNameSuffix;

    public JoinValidateConfigured(Vertex.VertexExecutionContext defaultExecutionContext, Vertex.VertexExecutionContext lhsContext, Vertex.VertexExecutionContext rhsContext, Vertex.VertexExecutionContext validateContext, String dagNameSuffix) {
        this.defaultExecutionContext = defaultExecutionContext;
        this.lhsContext = lhsContext;
        this.rhsContext = rhsContext;
        this.validateContext = validateContext;
        this.dagNameSuffix = dagNameSuffix;
    }

    protected Vertex.VertexExecutionContext getDefaultExecutionContext() {
        return this.defaultExecutionContext;
    }

    protected Vertex.VertexExecutionContext getLhsExecutionContext() {
        return this.lhsContext;
    }

    protected Vertex.VertexExecutionContext getRhsExecutionContext() {
        return this.rhsContext;
    }

    protected Vertex.VertexExecutionContext getValidateExecutionContext() {
        return this.validateContext;
    }

    protected String getDagName() {
        return "JoinValidate_" + this.dagNameSuffix;
    }

    public DAG createDag(TezConfiguration tezConf, Path lhs, Path rhs, int numPartitions) throws IOException {
        return super.createDag(tezConf, lhs, rhs, numPartitions);
    }
}

