/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.launcher;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.TezConstants;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.app.TezTestServiceCommunicator;
import org.apache.tez.serviceplugins.api.ContainerLaunchRequest;
import org.apache.tez.serviceplugins.api.ContainerLauncher;
import org.apache.tez.serviceplugins.api.ContainerLauncherContext;
import org.apache.tez.serviceplugins.api.ContainerStopRequest;
import org.apache.tez.test.service.rpc.TezTestServiceProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezTestServiceContainerLauncher
extends ContainerLauncher {
    static final Logger LOG = LoggerFactory.getLogger(TezTestServiceContainerLauncher.class);
    private final String tokenIdentifier;
    private final int servicePort;
    private final TezTestServiceCommunicator communicator;
    private final ApplicationAttemptId appAttemptId;
    private final Configuration conf;

    public TezTestServiceContainerLauncher(ContainerLauncherContext containerLauncherContext) {
        super(containerLauncherContext);
        try {
            this.conf = TezUtils.createConfFromUserPayload((UserPayload)this.getContext().getInitialUserPayload());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int numThreads = this.conf.getInt("tez.test.service.communicator.num.threads", 2);
        this.servicePort = this.conf.getInt("tez.test.service.rpc.port", -1);
        Preconditions.checkArgument((this.servicePort > 0 ? 1 : 0) != 0, (Object)"tez.test.service.rpc.port must be set");
        this.communicator = new TezTestServiceCommunicator(numThreads);
        this.tokenIdentifier = this.getContext().getApplicationAttemptId().getApplicationId().toString();
        this.appAttemptId = this.getContext().getApplicationAttemptId();
    }

    public void start() {
        this.communicator.init(this.conf);
        this.communicator.start();
    }

    public void shutdown() {
        this.communicator.stop();
    }

    public void launchContainer(final ContainerLaunchRequest launchRequest) {
        TezTestServiceProtocolProtos.RunContainerRequestProto runRequest = null;
        try {
            runRequest = this.constructRunContainerRequest(launchRequest);
        }
        catch (IOException e) {
            this.getContext().containerLaunchFailed(launchRequest.getContainerId(), "Failed to construct launch request, " + StringUtils.stringifyException((Throwable)e));
            return;
        }
        this.communicator.runContainer(runRequest, launchRequest.getNodeId().getHost(), launchRequest.getNodeId().getPort(), new TezTestServiceCommunicator.ExecuteRequestCallback<TezTestServiceProtocolProtos.RunContainerResponseProto>(){

            @Override
            public void setResponse(TezTestServiceProtocolProtos.RunContainerResponseProto response) {
                LOG.info("Container: " + launchRequest.getContainerId() + " launch succeeded on host: " + launchRequest.getNodeId());
                TezTestServiceContainerLauncher.this.getContext().containerLaunched(launchRequest.getContainerId());
            }

            @Override
            public void indicateError(Throwable t) {
                LOG.error("Failed to launch container: " + launchRequest.getContainerId() + " on host: " + launchRequest.getNodeId(), t);
                TezTestServiceContainerLauncher.this.sendContainerLaunchFailedMsg(launchRequest.getContainerId(), t);
            }
        });
    }

    public void stopContainer(ContainerStopRequest stopRequest) {
        LOG.info("Ignoring stopContainer for event: " + stopRequest);
        this.getContext().containerStopRequested(stopRequest.getContainerId());
    }

    private TezTestServiceProtocolProtos.RunContainerRequestProto constructRunContainerRequest(ContainerLaunchRequest launchRequest) throws IOException {
        TezTestServiceProtocolProtos.RunContainerRequestProto.Builder builder = TezTestServiceProtocolProtos.RunContainerRequestProto.newBuilder();
        Preconditions.checkArgument((boolean)launchRequest.getTaskCommunicatorName().equals(TezConstants.getTezYarnServicePluginName()));
        InetSocketAddress address = (InetSocketAddress)this.getContext().getTaskCommunicatorMetaInfo(launchRequest.getTaskCommunicatorName());
        builder.setAmHost(address.getHostName()).setAmPort(address.getPort());
        builder.setAppAttemptNumber(this.appAttemptId.getAttemptId());
        builder.setApplicationIdString(this.appAttemptId.getApplicationId().toString());
        builder.setTokenIdentifier(this.tokenIdentifier);
        builder.setContainerIdString(launchRequest.getContainerId().toString());
        builder.setCredentialsBinary(ByteString.copyFrom((ByteBuffer)launchRequest.getContainerLaunchContext().getTokens()));
        builder.setUser(System.getenv(ApplicationConstants.Environment.USER.name()));
        return builder.build();
    }

    void sendContainerLaunchFailedMsg(ContainerId containerId, Throwable t) {
        this.getContext().containerLaunchFailed(containerId, t == null ? "" : t.getMessage());
    }
}

