/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.Message;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.service.AbstractService;
import org.apache.tez.common.GuavaShim;
import org.apache.tez.service.TezTestServiceProtocolBlockingPB;
import org.apache.tez.service.impl.TezTestServiceProtocolClientImpl;
import org.apache.tez.test.service.rpc.TezTestServiceProtocolProtos;

public class TezTestServiceCommunicator
extends AbstractService {
    private final ConcurrentMap<String, TezTestServiceProtocolBlockingPB> hostProxies;
    private final ListeningExecutorService executor;

    public TezTestServiceCommunicator(int numThreads) {
        super(TezTestServiceCommunicator.class.getSimpleName());
        ExecutorService localExecutor = Executors.newFixedThreadPool(numThreads, new ThreadFactoryBuilder().setNameFormat("TezTestServiceCommunicator #%2d").build());
        this.hostProxies = new ConcurrentHashMap<String, TezTestServiceProtocolBlockingPB>();
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)localExecutor);
    }

    public void serviceStop() {
        this.executor.shutdownNow();
    }

    public void runContainer(TezTestServiceProtocolProtos.RunContainerRequestProto request, String host, int port, final ExecuteRequestCallback<TezTestServiceProtocolProtos.RunContainerResponseProto> callback) {
        ListenableFuture future = this.executor.submit((Callable)new RunContainerCallable(request, host, port));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<TezTestServiceProtocolProtos.RunContainerResponseProto>(){

            public void onSuccess(TezTestServiceProtocolProtos.RunContainerResponseProto result) {
                callback.setResponse(result);
            }

            public void onFailure(Throwable t) {
                callback.indicateError(t);
            }
        }, (Executor)GuavaShim.directExecutor());
    }

    public void submitWork(TezTestServiceProtocolProtos.SubmitWorkRequestProto request, String host, int port, final ExecuteRequestCallback<TezTestServiceProtocolProtos.SubmitWorkResponseProto> callback) {
        ListenableFuture future = this.executor.submit((Callable)new SubmitWorkCallable(request, host, port));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<TezTestServiceProtocolProtos.SubmitWorkResponseProto>(){

            public void onSuccess(TezTestServiceProtocolProtos.SubmitWorkResponseProto result) {
                callback.setResponse(result);
            }

            public void onFailure(Throwable t) {
                callback.indicateError(t);
            }
        }, (Executor)GuavaShim.directExecutor());
    }

    private TezTestServiceProtocolBlockingPB getProxy(String hostname, int port) {
        TezTestServiceProtocolBlockingPB proxyOld;
        String hostId = this.getHostIdentifier(hostname, port);
        TezTestServiceProtocolBlockingPB proxy = (TezTestServiceProtocolBlockingPB)this.hostProxies.get(hostId);
        if (proxy == null && (proxyOld = this.hostProxies.putIfAbsent(hostId, proxy = new TezTestServiceProtocolClientImpl(this.getConfig(), hostname, port))) != null) {
            proxy = proxyOld;
        }
        return proxy;
    }

    private String getHostIdentifier(String hostname, int port) {
        return hostname + ":" + port;
    }

    public static interface ExecuteRequestCallback<T extends Message> {
        public void setResponse(T var1);

        public void indicateError(Throwable var1);
    }

    private class SubmitWorkCallable
    implements Callable<TezTestServiceProtocolProtos.SubmitWorkResponseProto> {
        final String hostname;
        final int port;
        final TezTestServiceProtocolProtos.SubmitWorkRequestProto request;

        private SubmitWorkCallable(TezTestServiceProtocolProtos.SubmitWorkRequestProto request, String hostname, int port) {
            this.hostname = hostname;
            this.port = port;
            this.request = request;
        }

        @Override
        public TezTestServiceProtocolProtos.SubmitWorkResponseProto call() throws Exception {
            return TezTestServiceCommunicator.this.getProxy(this.hostname, this.port).submitWork(null, this.request);
        }
    }

    private class RunContainerCallable
    implements Callable<TezTestServiceProtocolProtos.RunContainerResponseProto> {
        final String hostname;
        final int port;
        final TezTestServiceProtocolProtos.RunContainerRequestProto request;

        private RunContainerCallable(TezTestServiceProtocolProtos.RunContainerRequestProto request, String hostname, int port) {
            this.hostname = hostname;
            this.port = port;
            this.request = request;
        }

        @Override
        public TezTestServiceProtocolProtos.RunContainerResponseProto call() throws Exception {
            return TezTestServiceCommunicator.this.getProxy(this.hostname, this.port).runContainer(null, this.request);
        }
    }
}

