/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.tez.common.counters.DAGCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.oldrecords.TaskAttemptReport;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.records.TaskAttemptIDAware;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.api.impl.TezEvent;

public interface TaskAttempt
extends TaskAttemptIDAware {
    public Task getTask();

    public TaskAttemptReport getReport();

    public List<String> getDiagnostics();

    public TaskAttemptTerminationCause getTerminationCause();

    public TezCounters getCounters();

    public float getProgress();

    public TaskAttemptState getState();

    public TaskAttemptState getStateNoLock();

    public void setLastEventSent(TezEvent var1);

    public boolean isFinished();

    public ContainerId getAssignedContainerID();

    public Container getAssignedContainer();

    public String getAssignedContainerMgrAddress();

    public NodeId getNodeId();

    public String getNodeHttpAddress();

    public String getNodeRackName();

    public long getLaunchTime();

    public long getScheduleTime();

    public long getFinishTime();

    public static class TaskAttemptStatus {
        public TezTaskAttemptID id;
        public TaskAttemptState state;
        public float progress;
        public TezCounters counters;
        private AtomicBoolean localitySet = new AtomicBoolean(false);

        public TaskAttemptStatus(TezTaskAttemptID id) {
            this.id = id;
        }

        public void setLocalityCounter(DAGCounter localityCounter) {
            if (!this.localitySet.get()) {
                this.localitySet.set(true);
                if (this.counters == null) {
                    this.counters = new TezCounters();
                }
                if (localityCounter != null) {
                    this.counters.findCounter((Enum)localityCounter).increment(1L);
                }
            }
        }
    }
}

