/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.logging.impl;

import java.util.HashMap;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.dag.DAGState;
import org.apache.tez.dag.app.dag.VertexState;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.events.AMLaunchedEvent;
import org.apache.tez.dag.history.events.AMStartedEvent;
import org.apache.tez.dag.history.events.AppLaunchedEvent;
import org.apache.tez.dag.history.events.ContainerLaunchedEvent;
import org.apache.tez.dag.history.events.ContainerStoppedEvent;
import org.apache.tez.dag.history.events.DAGCommitStartedEvent;
import org.apache.tez.dag.history.events.DAGFinishedEvent;
import org.apache.tez.dag.history.events.DAGInitializedEvent;
import org.apache.tez.dag.history.events.DAGKillRequestEvent;
import org.apache.tez.dag.history.events.DAGRecoveredEvent;
import org.apache.tez.dag.history.events.DAGStartedEvent;
import org.apache.tez.dag.history.events.DAGSubmittedEvent;
import org.apache.tez.dag.history.events.TaskAttemptFinishedEvent;
import org.apache.tez.dag.history.events.TaskAttemptStartedEvent;
import org.apache.tez.dag.history.events.TaskFinishedEvent;
import org.apache.tez.dag.history.events.TaskStartedEvent;
import org.apache.tez.dag.history.events.VertexCommitStartedEvent;
import org.apache.tez.dag.history.events.VertexConfigurationDoneEvent;
import org.apache.tez.dag.history.events.VertexFinishedEvent;
import org.apache.tez.dag.history.events.VertexGroupCommitFinishedEvent;
import org.apache.tez.dag.history.events.VertexGroupCommitStartedEvent;
import org.apache.tez.dag.history.events.VertexInitializedEvent;
import org.apache.tez.dag.history.events.VertexStartedEvent;
import org.apache.tez.dag.history.logging.impl.HistoryEventJsonConversion;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHistoryEventJsonConversion {
    private ApplicationAttemptId applicationAttemptId;
    private ApplicationId applicationId;
    private String user = "user";
    private Random random = new Random();
    private TezDAGID tezDAGID;
    private TezVertexID tezVertexID;
    private TezTaskID tezTaskID;
    private TezTaskAttemptID tezTaskAttemptID;
    private DAGProtos.DAGPlan dagPlan;
    private ContainerId containerId;
    private NodeId nodeId;

    @Before
    public void setup() {
        this.applicationId = ApplicationId.newInstance((long)9999L, (int)1);
        this.applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)this.applicationId, (int)1);
        this.tezDAGID = TezDAGID.getInstance((ApplicationId)this.applicationId, (int)this.random.nextInt());
        this.tezVertexID = TezVertexID.getInstance((TezDAGID)this.tezDAGID, (int)this.random.nextInt());
        this.tezTaskID = TezTaskID.getInstance((TezVertexID)this.tezVertexID, (int)this.random.nextInt());
        this.tezTaskAttemptID = TezTaskAttemptID.getInstance((TezTaskID)this.tezTaskID, (int)this.random.nextInt());
        this.dagPlan = DAGProtos.DAGPlan.newBuilder().setName("DAGPlanMock").build();
        this.containerId = ContainerId.newInstance((ApplicationAttemptId)this.applicationAttemptId, (int)111);
        this.nodeId = NodeId.newInstance((String)"node", (int)13435);
    }

    @Test(timeout=5000L)
    public void testHandlerExists() throws JSONException {
        for (HistoryEventType eventType : HistoryEventType.values()) {
            DAGCommitStartedEvent event = null;
            switch (eventType) {
                case APP_LAUNCHED: {
                    event = new AppLaunchedEvent(this.applicationId, (long)this.random.nextInt(), (long)this.random.nextInt(), this.user, new Configuration(false), null);
                    break;
                }
                case AM_LAUNCHED: {
                    event = new AMLaunchedEvent(this.applicationAttemptId, (long)this.random.nextInt(), (long)this.random.nextInt(), this.user);
                    break;
                }
                case AM_STARTED: {
                    event = new AMStartedEvent(this.applicationAttemptId, (long)this.random.nextInt(), this.user);
                    break;
                }
                case DAG_SUBMITTED: {
                    event = new DAGSubmittedEvent(this.tezDAGID, (long)this.random.nextInt(), this.dagPlan, this.applicationAttemptId, null, this.user, null, null, "Q_" + eventType.name());
                    break;
                }
                case DAG_INITIALIZED: {
                    event = new DAGInitializedEvent(this.tezDAGID, (long)this.random.nextInt(), this.user, this.dagPlan.getName(), null);
                    break;
                }
                case DAG_STARTED: {
                    event = new DAGStartedEvent(this.tezDAGID, (long)this.random.nextInt(), this.user, this.dagPlan.getName());
                    break;
                }
                case DAG_FINISHED: {
                    event = new DAGFinishedEvent(this.tezDAGID, (long)this.random.nextInt(), (long)this.random.nextInt(), DAGState.ERROR, null, null, this.user, this.dagPlan.getName(), null, this.applicationAttemptId, this.dagPlan);
                    break;
                }
                case VERTEX_INITIALIZED: {
                    event = new VertexInitializedEvent(this.tezVertexID, "v1", (long)this.random.nextInt(), (long)this.random.nextInt(), this.random.nextInt(), "proc", null, null, null);
                    break;
                }
                case VERTEX_STARTED: {
                    event = new VertexStartedEvent(this.tezVertexID, (long)this.random.nextInt(), (long)this.random.nextInt());
                    break;
                }
                case VERTEX_CONFIGURE_DONE: {
                    event = new VertexConfigurationDoneEvent(this.tezVertexID, 0L, 1, null, null, null, true);
                    break;
                }
                case VERTEX_FINISHED: {
                    event = new VertexFinishedEvent(this.tezVertexID, "v1", 1, (long)this.random.nextInt(), (long)this.random.nextInt(), (long)this.random.nextInt(), (long)this.random.nextInt(), (long)this.random.nextInt(), VertexState.ERROR, null, null, null, null, null);
                    break;
                }
                case TASK_STARTED: {
                    event = new TaskStartedEvent(this.tezTaskID, "v1", (long)this.random.nextInt(), (long)this.random.nextInt());
                    break;
                }
                case TASK_FINISHED: {
                    event = new TaskFinishedEvent(this.tezTaskID, "v1", (long)this.random.nextInt(), (long)this.random.nextInt(), this.tezTaskAttemptID, TaskState.FAILED, null, null, 0);
                    break;
                }
                case TASK_ATTEMPT_STARTED: {
                    event = new TaskAttemptStartedEvent(this.tezTaskAttemptID, "v1", (long)this.random.nextInt(), this.containerId, this.nodeId, null, null, "nodeHttpAddress");
                    break;
                }
                case TASK_ATTEMPT_FINISHED: {
                    event = new TaskAttemptFinishedEvent(this.tezTaskAttemptID, "v1", (long)this.random.nextInt(), (long)this.random.nextInt(), TaskAttemptState.KILLED, null, TaskAttemptTerminationCause.TERMINATED_BY_CLIENT, null, null, null, null, 0L, null, 0L, this.containerId, this.nodeId, null, null, "nodeHttpAddress");
                    break;
                }
                case CONTAINER_LAUNCHED: {
                    event = new ContainerLaunchedEvent(this.containerId, (long)this.random.nextInt(), this.applicationAttemptId);
                    break;
                }
                case CONTAINER_STOPPED: {
                    event = new ContainerStoppedEvent(this.containerId, (long)this.random.nextInt(), -1, this.applicationAttemptId);
                    break;
                }
                case DAG_COMMIT_STARTED: {
                    event = new DAGCommitStartedEvent();
                    break;
                }
                case VERTEX_COMMIT_STARTED: {
                    event = new VertexCommitStartedEvent();
                    break;
                }
                case VERTEX_GROUP_COMMIT_STARTED: {
                    event = new VertexGroupCommitStartedEvent();
                    break;
                }
                case VERTEX_GROUP_COMMIT_FINISHED: {
                    event = new VertexGroupCommitFinishedEvent();
                    break;
                }
                case DAG_RECOVERED: {
                    event = new DAGRecoveredEvent(this.applicationAttemptId, this.tezDAGID, this.dagPlan.getName(), this.user, 1L, null);
                    break;
                }
                case DAG_KILL_REQUEST: {
                    event = new DAGKillRequestEvent();
                    break;
                }
                default: {
                    Assert.fail((String)("Unhandled event type " + eventType));
                }
            }
            if (event == null || !event.isHistoryEvent()) continue;
            JSONObject json = HistoryEventJsonConversion.convertToJson((HistoryEvent)event);
            if (eventType != HistoryEventType.DAG_SUBMITTED) continue;
            try {
                Assert.assertEquals((Object)("Q_" + eventType.name()), (Object)json.getJSONObject("otherinfo").getString("queueName"));
                Assert.assertEquals((Object)("Q_" + eventType.name()), (Object)json.getJSONObject("primaryfilters").getString("queueName"));
            }
            catch (JSONException ex) {
                Assert.fail((String)("Exception: " + ex.getMessage() + " for type: " + eventType));
            }
        }
    }

    @Test(timeout=5000L)
    public void testConvertVertexReconfigureDoneEvent() throws JSONException {
        TezVertexID vId = TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1), (int)1);
        HashMap<String, EdgeProperty> edgeMgrs = new HashMap<String, EdgeProperty>();
        edgeMgrs.put("a", EdgeProperty.create((EdgeManagerPluginDescriptor)((EdgeManagerPluginDescriptor)EdgeManagerPluginDescriptor.create((String)"a.class").setHistoryText("text")), (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"Out"), (InputDescriptor)InputDescriptor.create((String)"In")));
        VertexConfigurationDoneEvent event = new VertexConfigurationDoneEvent(vId, 0L, 1, null, edgeMgrs, null, true);
        JSONObject jsonObject = HistoryEventJsonConversion.convertToJson((HistoryEvent)event);
        Assert.assertNotNull((Object)jsonObject);
        Assert.assertEquals((Object)vId.toString(), (Object)jsonObject.getString("entity"));
        Assert.assertEquals((Object)"TEZ_VERTEX_ID", (Object)jsonObject.get("entitytype"));
        JSONArray events = jsonObject.getJSONArray("events");
        Assert.assertEquals((long)1L, (long)events.length());
        JSONObject evt = events.getJSONObject(0);
        Assert.assertEquals((Object)HistoryEventType.VERTEX_CONFIGURE_DONE.name(), (Object)evt.getString("eventtype"));
        JSONObject evtInfo = evt.getJSONObject("eventinfo");
        Assert.assertEquals((long)1L, (long)evtInfo.getInt("numTasks"));
        Assert.assertNotNull((Object)evtInfo.getJSONObject("updatedEdgeManagers"));
        JSONObject updatedEdgeMgrs = evtInfo.getJSONObject("updatedEdgeManagers");
        Assert.assertEquals((long)1L, (long)updatedEdgeMgrs.length());
        Assert.assertNotNull((Object)updatedEdgeMgrs.getJSONObject("a"));
        JSONObject updatedEdgeMgr = updatedEdgeMgrs.getJSONObject("a");
        Assert.assertEquals((Object)EdgeProperty.DataMovementType.CUSTOM.name(), (Object)updatedEdgeMgr.getString("dataMovementType"));
        Assert.assertEquals((Object)"In", (Object)updatedEdgeMgr.getString("edgeDestinationClass"));
        Assert.assertEquals((Object)"a.class", (Object)updatedEdgeMgr.getString("edgeManagerClass"));
    }
}

