/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.utils;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.client.CallerContext;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.DataSinkDescriptor;
import org.apache.tez.dag.api.DataSourceDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.GroupInputEdge;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputCommitterDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.VertexGroup;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.history.utils.DAGUtils;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.OutputCommitter;
import org.codehaus.jettison.json.JSONException;
import org.junit.Assert;
import org.junit.Test;

public class TestDAGUtils {
    private DAGProtos.DAGPlan createDAG() {
        Configuration conf = new Configuration(false);
        int dummyTaskCount = 1;
        Resource dummyTaskResource = Resource.newInstance((int)1, (int)1);
        Vertex v1 = Vertex.create((String)"vertex1", (ProcessorDescriptor)((ProcessorDescriptor)ProcessorDescriptor.create((String)"Processor").setHistoryText("vertex1 Processor HistoryText")), (int)dummyTaskCount, (Resource)dummyTaskResource);
        v1.addDataSource("input1", DataSourceDescriptor.create((InputDescriptor)((InputDescriptor)InputDescriptor.create((String)"input.class").setHistoryText("input HistoryText")), null, null));
        Vertex v2 = Vertex.create((String)"vertex2", (ProcessorDescriptor)((ProcessorDescriptor)ProcessorDescriptor.create((String)"Processor").setHistoryText("vertex2 Processor HistoryText")), (int)dummyTaskCount, (Resource)dummyTaskResource);
        Vertex v3 = Vertex.create((String)"vertex3", (ProcessorDescriptor)((ProcessorDescriptor)ProcessorDescriptor.create((String)"Processor").setHistoryText("vertex3 Processor HistoryText")), (int)dummyTaskCount, (Resource)dummyTaskResource);
        DAG dag = DAG.create((String)"testDag");
        dag.setCallerContext(CallerContext.create((String)"context1", (String)"callerId1", (String)"callerType1", (String)"desc1"));
        dag.setDAGInfo("dagInfo");
        String groupName1 = "uv12";
        VertexGroup uv12 = dag.createVertexGroup(groupName1, new Vertex[]{v1, v2});
        OutputDescriptor outDesc = (OutputDescriptor)OutputDescriptor.create((String)"output.class").setHistoryText("uvOut HistoryText");
        OutputCommitterDescriptor ocd = OutputCommitterDescriptor.create((String)OutputCommitter.class.getName());
        uv12.addDataSink("uvOut", DataSinkDescriptor.create((OutputDescriptor)outDesc, (OutputCommitterDescriptor)ocd, null));
        v3.addDataSink("uvOut", DataSinkDescriptor.create((OutputDescriptor)outDesc, (OutputCommitterDescriptor)ocd, null));
        GroupInputEdge e1 = GroupInputEdge.create((VertexGroup)uv12, (Vertex)v3, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)((OutputDescriptor)OutputDescriptor.create((String)"dummy output class").setHistoryText("Dummy History Text")), (InputDescriptor)((InputDescriptor)InputDescriptor.create((String)"dummy input class").setHistoryText("Dummy History Text"))), (InputDescriptor)((InputDescriptor)InputDescriptor.create((String)"merge.class").setHistoryText("Merge HistoryText")));
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addVertex(v3);
        dag.addEdge(e1);
        return dag.createDag(conf, null, null, null, true);
    }

    @Test(timeout=5000L)
    public void testConvertDAGPlanToATSMap() throws IOException, JSONException {
        Map e;
        DAGProtos.DAGPlan dagPlan = this.createDAG();
        HashMap<String, TezVertexID> idNameMap = new HashMap<String, TezVertexID>();
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vId1 = TezVertexID.getInstance((TezDAGID)dagId, (int)1);
        TezVertexID vId2 = TezVertexID.getInstance((TezDAGID)dagId, (int)2);
        TezVertexID vId3 = TezVertexID.getInstance((TezDAGID)dagId, (int)3);
        idNameMap.put("vertex1", vId1);
        idNameMap.put("vertex2", vId2);
        idNameMap.put("vertex3", vId3);
        Map atsMap = DAGUtils.convertDAGPlanToATSMap((DAGProtos.DAGPlan)dagPlan);
        Assert.assertTrue((boolean)atsMap.containsKey("dagName"));
        Assert.assertEquals((Object)"testDag", atsMap.get("dagName"));
        Assert.assertTrue((boolean)atsMap.containsKey("dagInfo"));
        Assert.assertTrue((boolean)atsMap.containsKey("dagContext"));
        Map contextMap = (Map)atsMap.get("dagContext");
        Assert.assertEquals((Object)"context1", contextMap.get("context"));
        Assert.assertEquals((Object)"callerId1", contextMap.get("callerId"));
        Assert.assertEquals((Object)"callerType1", contextMap.get("callerType"));
        Assert.assertEquals((Object)"desc1", contextMap.get("description"));
        Assert.assertEquals((Object)"dagInfo", atsMap.get("dagInfo"));
        Assert.assertEquals((Object)dagPlan.getName(), atsMap.get("dagName"));
        Assert.assertTrue((boolean)atsMap.containsKey("version"));
        Assert.assertEquals((Object)2, atsMap.get("version"));
        Assert.assertTrue((boolean)atsMap.containsKey("vertices"));
        Assert.assertTrue((boolean)atsMap.containsKey("edges"));
        Assert.assertTrue((boolean)atsMap.containsKey("vertexGroups"));
        Assert.assertEquals((long)3L, (long)((Collection)atsMap.get("vertices")).size());
        HashSet inEdgeIds = new HashSet();
        HashSet outEdgeIds = new HashSet();
        int additionalInputCount = 0;
        int additionalOutputCount = 0;
        for (Object o : (Collection)atsMap.get("vertices")) {
            Map v = (Map)o;
            Assert.assertTrue((boolean)v.containsKey("vertexName"));
            String vName = (String)v.get("vertexName");
            Assert.assertTrue((boolean)v.containsKey("processorClass"));
            Assert.assertTrue((boolean)v.containsKey("userPayloadAsText"));
            if (v.containsKey("inEdgeIds")) {
                inEdgeIds.addAll((Collection)v.get("inEdgeIds"));
            }
            if (v.containsKey("outEdgeIds")) {
                outEdgeIds.addAll((Collection)v.get("outEdgeIds"));
            }
            Assert.assertTrue((boolean)idNameMap.containsKey(vName));
            String procPayload = vName + " Processor HistoryText";
            Assert.assertEquals((Object)procPayload, v.get("userPayloadAsText"));
            if (v.containsKey("additionalInputs")) {
                additionalInputCount += ((Collection)v.get("additionalInputs")).size();
                for (Object input : (Collection)v.get("additionalInputs")) {
                    Map inputMap = (Map)input;
                    Assert.assertTrue((boolean)inputMap.containsKey("name"));
                    Assert.assertTrue((boolean)inputMap.containsKey("class"));
                    Assert.assertFalse((boolean)inputMap.containsKey("initializer"));
                    Assert.assertEquals((Object)"input HistoryText", inputMap.get("userPayloadAsText"));
                }
            }
            if (!v.containsKey("additionalOutputs")) continue;
            additionalOutputCount += ((Collection)v.get("additionalOutputs")).size();
            for (Object output : (Collection)v.get("additionalOutputs")) {
                Map outputMap = (Map)output;
                Assert.assertTrue((boolean)outputMap.containsKey("name"));
                Assert.assertTrue((boolean)outputMap.containsKey("class"));
                Assert.assertTrue((boolean)outputMap.containsKey("initializer"));
                Assert.assertEquals((Object)"uvOut HistoryText", outputMap.get("userPayloadAsText"));
            }
        }
        Assert.assertEquals((long)1L, (long)additionalInputCount);
        Assert.assertEquals((long)3L, (long)additionalOutputCount);
        Assert.assertEquals((long)2L, (long)inEdgeIds.size());
        Assert.assertEquals((long)2L, (long)outEdgeIds.size());
        for (Object o : (Collection)atsMap.get("edges")) {
            e = (Map)o;
            Assert.assertTrue((boolean)inEdgeIds.contains(e.get("edgeId")));
            Assert.assertTrue((boolean)outEdgeIds.contains(e.get("edgeId")));
            Assert.assertTrue((boolean)e.containsKey("inputVertexName"));
            Assert.assertTrue((boolean)e.containsKey("outputVertexName"));
            Assert.assertEquals((Object)EdgeProperty.DataMovementType.SCATTER_GATHER.name(), e.get("dataMovementType"));
            Assert.assertEquals((Object)EdgeProperty.DataSourceType.PERSISTED.name(), e.get("dataSourceType"));
            Assert.assertEquals((Object)EdgeProperty.SchedulingType.SEQUENTIAL.name(), e.get("schedulingType"));
            Assert.assertEquals((Object)"dummy output class", e.get("edgeSourceClass"));
            Assert.assertEquals((Object)"dummy input class", e.get("edgeDestinationClass"));
            Assert.assertEquals((Object)"Dummy History Text", e.get("outputUserPayloadAsText"));
            Assert.assertEquals((Object)"Dummy History Text", e.get("inputUserPayloadAsText"));
        }
        for (Object o : (Collection)atsMap.get("vertexGroups")) {
            e = (Map)o;
            Assert.assertEquals((Object)"uv12", e.get("groupName"));
            Assert.assertTrue((boolean)e.containsKey("groupMembers"));
            Assert.assertTrue((boolean)e.containsKey("outputs"));
            Assert.assertTrue((boolean)e.containsKey("edgeMergedInputs"));
        }
    }
}

