/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.launcher;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.tez.dag.app.launcher.TezLocalCacheManager;
import org.junit.Assert;
import org.junit.Test;

public class TestTezLocalCacheManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManager() throws URISyntaxException, IOException {
        HashMap<String, LocalResource> resources = new HashMap<String, LocalResource>();
        LocalResource resourceOne = TestTezLocalCacheManager.createFile("content-one");
        LocalResource resourceTwo = TestTezLocalCacheManager.createFile("content-two");
        resources.put("file-one", resourceOne);
        resources.put("file-two", resourceTwo);
        resources.put("file-three", resourceTwo);
        resources.put("some-subdir/file-three", resourceTwo);
        TezLocalCacheManager manager = new TezLocalCacheManager(resources, new Configuration());
        try {
            manager.localize();
            Assert.assertEquals((Object)"content-one", (Object)new String(Files.readAllBytes(Paths.get("./file-one", new String[0]))));
            Assert.assertEquals((Object)"content-two", (Object)new String(Files.readAllBytes(Paths.get("./file-two", new String[0]))));
            Assert.assertEquals((Object)"content-two", (Object)new String(Files.readAllBytes(Paths.get("./file-three", new String[0]))));
        }
        finally {
            manager.cleanup();
        }
        Assert.assertFalse((boolean)Files.exists(Paths.get("./file-one", new String[0]), new LinkOption[0]));
        Assert.assertFalse((boolean)Files.exists(Paths.get("./file-two", new String[0]), new LinkOption[0]));
        Assert.assertFalse((boolean)Files.exists(Paths.get("./file-three", new String[0]), new LinkOption[0]));
    }

    private static LocalResource createFile(String content) throws IOException {
        FileContext fs = FileContext.getLocalFSFileContext();
        java.nio.file.Path tempFile = Files.createTempFile("test-cache-manager", ".txt", new FileAttribute[0]);
        File temp = tempFile.toFile();
        temp.deleteOnExit();
        Path p = new Path("file:///" + tempFile.toAbsolutePath().toString());
        Files.write(tempFile, content.getBytes(), new OpenOption[0]);
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        LocalResource ret = (LocalResource)recordFactory.newRecordInstance(LocalResource.class);
        URL yarnUrlFromPath = ConverterUtils.getYarnUrlFromPath((Path)p);
        ret.setResource(yarnUrlFromPath);
        ret.setSize((long)content.getBytes().length);
        ret.setType(LocalResourceType.FILE);
        ret.setVisibility(LocalResourceVisibility.PRIVATE);
        ret.setTimestamp(fs.getFileStatus(p).getModificationTime());
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalizeRootDirectory() throws URISyntaxException, IOException {
        HashMap<String, LocalResource> resources = new HashMap<String, LocalResource>();
        LocalResource resourceOne = TestTezLocalCacheManager.createFile("content-one");
        resources.put("file-one", resourceOne);
        TezLocalCacheManager manager = new TezLocalCacheManager(resources, new Configuration());
        try {
            Assert.assertFalse((boolean)Files.exists(Paths.get("./file-one", new String[0]), new LinkOption[0]));
            manager.localize();
            Assert.assertTrue((boolean)Files.exists(Paths.get("./file-one", new String[0]), new LinkOption[0]));
        }
        finally {
            manager.cleanup();
            Assert.assertFalse((boolean)Files.exists(Paths.get("./file-one", new String[0]), new LinkOption[0]));
        }
        Configuration conf = new Configuration();
        conf.set("tez.local.cache.root.folder", "target");
        manager = new TezLocalCacheManager(resources, conf);
        try {
            Assert.assertFalse((boolean)Files.exists(Paths.get("./file-one", new String[0]), new LinkOption[0]));
            Assert.assertFalse((boolean)Files.exists(Paths.get("./target/file-one", new String[0]), new LinkOption[0]));
            manager.localize();
            Assert.assertFalse((boolean)Files.exists(Paths.get("./file-one", new String[0]), new LinkOption[0]));
            Assert.assertTrue((boolean)Files.exists(Paths.get("./target/file-one", new String[0]), new LinkOption[0]));
        }
        finally {
            manager.cleanup();
            Assert.assertFalse((boolean)Files.exists(Paths.get("./target/file-one", new String[0]), new LinkOption[0]));
        }
    }
}

