/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.speculation.legacy;

import org.apache.tez.dag.app.dag.speculation.legacy.DataStatistics;
import org.junit.Assert;
import org.junit.Test;

public class TestDataStatistics {
    private static final double TOL = 0.001;

    @Test(timeout=5000L)
    public void testEmptyDataStatistics() throws Exception {
        DataStatistics statistics = new DataStatistics();
        Assert.assertEquals((double)0.0, (double)statistics.count(), (double)0.001);
        Assert.assertEquals((double)9.223372036854776E18, (double)statistics.mean(), (double)0.001);
        Assert.assertEquals((double)0.0, (double)statistics.var(), (double)0.001);
        Assert.assertEquals((double)0.0, (double)statistics.std(), (double)0.001);
        Assert.assertEquals((double)9.223372036854776E18, (double)statistics.outlier(1.0f), (double)0.001);
    }

    @Test(timeout=5000L)
    public void testSingleEntryDataStatistics() throws Exception {
        DataStatistics statistics = new DataStatistics(17.29);
        Assert.assertEquals((double)1.0, (double)statistics.count(), (double)0.001);
        Assert.assertEquals((double)17.29, (double)statistics.mean(), (double)0.001);
        Assert.assertEquals((double)0.0, (double)statistics.var(), (double)0.001);
        Assert.assertEquals((double)0.0, (double)statistics.std(), (double)0.001);
        Assert.assertEquals((double)17.29, (double)statistics.outlier(1.0f), (double)0.001);
    }

    @Test(timeout=5000L)
    public void testMutiEntryDataStatistics() throws Exception {
        DataStatistics statistics = new DataStatistics();
        statistics.add(17.0);
        statistics.add(29.0);
        Assert.assertEquals((double)2.0, (double)statistics.count(), (double)0.001);
        Assert.assertEquals((double)23.0, (double)statistics.mean(), (double)0.001);
        Assert.assertEquals((double)36.0, (double)statistics.var(), (double)0.001);
        Assert.assertEquals((double)6.0, (double)statistics.std(), (double)0.001);
        Assert.assertEquals((double)29.0, (double)statistics.outlier(1.0f), (double)0.001);
    }

    @Test(timeout=5000L)
    public void testUpdateStatistics() throws Exception {
        DataStatistics statistics = new DataStatistics(17.0);
        statistics.add(29.0);
        Assert.assertEquals((double)2.0, (double)statistics.count(), (double)0.001);
        Assert.assertEquals((double)23.0, (double)statistics.mean(), (double)0.001);
        Assert.assertEquals((double)36.0, (double)statistics.var(), (double)0.001);
        statistics.updateStatistics(17.0, 29.0);
        Assert.assertEquals((double)2.0, (double)statistics.count(), (double)0.001);
        Assert.assertEquals((double)29.0, (double)statistics.mean(), (double)0.001);
        Assert.assertEquals((double)0.0, (double)statistics.var(), (double)0.001);
    }
}

