/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.dag.api.EntityDescriptor;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.InputInitializerDescriptor;
import org.apache.tez.dag.api.RootInputLeafOutput;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.dag.RootInputInitializerManager;
import org.apache.tez.dag.app.dag.StateChangeNotifier;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.hadoop.shim.DefaultHadoopShim;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputInitializer;
import org.apache.tez.runtime.api.InputInitializerContext;
import org.apache.tez.runtime.api.events.InputInitializerEvent;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestRootInputInitializerManager {
    @Test(timeout=5000L)
    public void testEventBeforeSuccess() throws Exception {
        InputDescriptor id = (InputDescriptor)Mockito.mock(InputDescriptor.class);
        InputInitializerDescriptor iid = (InputInitializerDescriptor)Mockito.mock(InputInitializerDescriptor.class);
        RootInputLeafOutput rootInput = new RootInputLeafOutput("InputName", (EntityDescriptor)id, (EntityDescriptor)iid);
        InputInitializer initializer = (InputInitializer)Mockito.mock(InputInitializer.class);
        InputInitializerContext initializerContext = (InputInitializerContext)Mockito.mock(InputInitializerContext.class);
        Vertex vertex = (Vertex)Mockito.mock(Vertex.class);
        StateChangeNotifier stateChangeNotifier = (StateChangeNotifier)Mockito.mock(StateChangeNotifier.class);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        RootInputInitializerManager.InitializerWrapper initializerWrapper = new RootInputInitializerManager.InitializerWrapper(rootInput, initializer, initializerContext, vertex, stateChangeNotifier, appContext);
        ApplicationId appId = ApplicationId.newInstance((long)1000L, (int)1);
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID srcVertexId = TezVertexID.getInstance((TezDAGID)dagId, (int)2);
        TezTaskID srcTaskId1 = TezTaskID.getInstance((TezVertexID)srcVertexId, (int)3);
        Vertex srcVertex = (Vertex)Mockito.mock(Vertex.class);
        Task srcTask1 = (Task)Mockito.mock(Task.class);
        ((Task)Mockito.doReturn((Object)TaskState.RUNNING).when((Object)srcTask1)).getState();
        ((Vertex)Mockito.doReturn((Object)srcTask1).when((Object)srcVertex)).getTask(srcTaskId1.getId());
        Mockito.when((Object)appContext.getCurrentDAG().getVertex((String)Mockito.any(String.class))).thenReturn((Object)srcVertex);
        String srcVertexName = "srcVertexName";
        LinkedList eventList = Lists.newLinkedList();
        TezTaskAttemptID srcTaskAttemptId11 = TezTaskAttemptID.getInstance((TezTaskID)srcTaskId1, (int)1);
        EventMetaData sourceInfo11 = new EventMetaData(EventMetaData.EventProducerConsumerType.PROCESSOR, srcVertexName, null, srcTaskAttemptId11);
        InputInitializerEvent e1 = InputInitializerEvent.create((String)"fakeVertex", (String)"fakeInput", null);
        TezEvent te1 = new TezEvent((Event)e1, sourceInfo11);
        eventList.add(te1);
        initializerWrapper.handleInputInitializerEvents((Collection)eventList);
        ((InputInitializer)Mockito.verify((Object)initializer, (VerificationMode)Mockito.never())).handleInputInitializerEvent((List)Mockito.any());
        eventList.clear();
        initializerWrapper.onTaskSucceeded(srcVertexName, srcTaskId1, srcTaskAttemptId11.getId());
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(List.class);
        ((InputInitializer)Mockito.verify((Object)initializer, (VerificationMode)Mockito.times((int)1))).handleInputInitializerEvent((List)argumentCaptor.capture());
        List invokedEvents = (List)argumentCaptor.getValue();
        Assert.assertEquals((long)1L, (long)invokedEvents.size());
        Mockito.reset((Object[])new InputInitializer[]{initializer});
        TezTaskAttemptID srcTaskAttemptId12 = TezTaskAttemptID.getInstance((TezTaskID)srcTaskId1, (int)2);
        EventMetaData sourceInfo12 = new EventMetaData(EventMetaData.EventProducerConsumerType.PROCESSOR, srcVertexName, null, srcTaskAttemptId12);
        InputInitializerEvent e2 = InputInitializerEvent.create((String)"fakeVertex", (String)"fakeInput", null);
        TezEvent te2 = new TezEvent((Event)e2, sourceInfo12);
        eventList.add(te2);
        initializerWrapper.handleInputInitializerEvents((Collection)eventList);
        ((InputInitializer)Mockito.verify((Object)initializer, (VerificationMode)Mockito.never())).handleInputInitializerEvent((List)Mockito.any());
        eventList.clear();
        Mockito.reset((Object[])new InputInitializer[]{initializer});
        initializerWrapper.onTaskSucceeded(srcVertexName, srcTaskId1, srcTaskAttemptId12.getId());
        ((InputInitializer)Mockito.verify((Object)initializer, (VerificationMode)Mockito.never())).handleInputInitializerEvent((List)argumentCaptor.capture());
    }

    @Test(timeout=5000L)
    public void testSuccessBeforeEvent() throws Exception {
        InputDescriptor id = (InputDescriptor)Mockito.mock(InputDescriptor.class);
        InputInitializerDescriptor iid = (InputInitializerDescriptor)Mockito.mock(InputInitializerDescriptor.class);
        RootInputLeafOutput rootInput = new RootInputLeafOutput("InputName", (EntityDescriptor)id, (EntityDescriptor)iid);
        InputInitializer initializer = (InputInitializer)Mockito.mock(InputInitializer.class);
        InputInitializerContext initializerContext = (InputInitializerContext)Mockito.mock(InputInitializerContext.class);
        Vertex vertex = (Vertex)Mockito.mock(Vertex.class);
        StateChangeNotifier stateChangeNotifier = (StateChangeNotifier)Mockito.mock(StateChangeNotifier.class);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        RootInputInitializerManager.InitializerWrapper initializerWrapper = new RootInputInitializerManager.InitializerWrapper(rootInput, initializer, initializerContext, vertex, stateChangeNotifier, appContext);
        ApplicationId appId = ApplicationId.newInstance((long)1000L, (int)1);
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID srcVertexId = TezVertexID.getInstance((TezDAGID)dagId, (int)2);
        TezTaskID srcTaskId1 = TezTaskID.getInstance((TezVertexID)srcVertexId, (int)3);
        Vertex srcVertex = (Vertex)Mockito.mock(Vertex.class);
        Task srcTask1 = (Task)Mockito.mock(Task.class);
        ((Task)Mockito.doReturn((Object)TaskState.RUNNING).when((Object)srcTask1)).getState();
        ((Vertex)Mockito.doReturn((Object)srcTask1).when((Object)srcVertex)).getTask(srcTaskId1.getId());
        Mockito.when((Object)appContext.getCurrentDAG().getVertex((String)Mockito.any(String.class))).thenReturn((Object)srcVertex);
        String srcVertexName = "srcVertexName";
        LinkedList eventList = Lists.newLinkedList();
        TezTaskAttemptID srcTaskAttemptId11 = TezTaskAttemptID.getInstance((TezTaskID)srcTaskId1, (int)1);
        EventMetaData sourceInfo11 = new EventMetaData(EventMetaData.EventProducerConsumerType.PROCESSOR, srcVertexName, null, srcTaskAttemptId11);
        InputInitializerEvent e1 = InputInitializerEvent.create((String)"fakeVertex", (String)"fakeInput", null);
        TezEvent te1 = new TezEvent((Event)e1, sourceInfo11);
        eventList.add(te1);
        initializerWrapper.handleInputInitializerEvents((Collection)eventList);
        ((InputInitializer)Mockito.verify((Object)initializer, (VerificationMode)Mockito.never())).handleInputInitializerEvent((List)Mockito.any());
        eventList.clear();
        initializerWrapper.onTaskSucceeded(srcVertexName, srcTaskId1, srcTaskAttemptId11.getId());
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(List.class);
        ((InputInitializer)Mockito.verify((Object)initializer, (VerificationMode)Mockito.times((int)1))).handleInputInitializerEvent((List)argumentCaptor.capture());
        List invokedEvents = (List)argumentCaptor.getValue();
        Assert.assertEquals((long)1L, (long)invokedEvents.size());
        Mockito.reset((Object[])new InputInitializer[]{initializer});
        TezTaskAttemptID srcTaskAttemptId12 = TezTaskAttemptID.getInstance((TezTaskID)srcTaskId1, (int)2);
        initializerWrapper.onTaskSucceeded(srcVertexName, srcTaskId1, srcTaskAttemptId12.getId());
        ((InputInitializer)Mockito.verify((Object)initializer, (VerificationMode)Mockito.never())).handleInputInitializerEvent((List)Mockito.any());
        EventMetaData sourceInfo12 = new EventMetaData(EventMetaData.EventProducerConsumerType.PROCESSOR, srcVertexName, null, srcTaskAttemptId12);
        InputInitializerEvent e2 = InputInitializerEvent.create((String)"fakeVertex", (String)"fakeInput", null);
        TezEvent te2 = new TezEvent((Event)e2, sourceInfo12);
        eventList.add(te2);
        initializerWrapper.handleInputInitializerEvents((Collection)eventList);
        ((InputInitializer)Mockito.verify((Object)initializer, (VerificationMode)Mockito.never())).handleInputInitializerEvent((List)Mockito.any());
    }

    @Test(timeout=5000L)
    public void testCorrectUgiUsage() throws TezException, InterruptedException {
        Vertex vertex = (Vertex)Mockito.mock(Vertex.class);
        ((Vertex)Mockito.doReturn((Object)Mockito.mock(TezVertexID.class)).when((Object)vertex)).getVertexId();
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        ((AppContext)Mockito.doReturn((Object)new DefaultHadoopShim()).when((Object)appContext)).getHadoopShim();
        ((AppContext)Mockito.doReturn((Object)Mockito.mock(EventHandler.class)).when((Object)appContext)).getEventHandler();
        UserGroupInformation dagUgi = UserGroupInformation.createRemoteUser((String)"fakeuser");
        StateChangeNotifier stateChangeNotifier = (StateChangeNotifier)Mockito.mock(StateChangeNotifier.class);
        RootInputInitializerManager rootInputInitializerManager = new RootInputInitializerManager(vertex, appContext, dagUgi, stateChangeNotifier);
        InputDescriptor id = (InputDescriptor)Mockito.mock(InputDescriptor.class);
        InputInitializerDescriptor iid = InputInitializerDescriptor.create((String)InputInitializerForUgiTest.class.getName());
        RootInputLeafOutput rootInput = new RootInputLeafOutput("InputName", (EntityDescriptor)id, (EntityDescriptor)iid);
        rootInputInitializerManager.runInputInitializers(Collections.singletonList(rootInput));
        InputInitializerForUgiTest.awaitInitialize();
        Assert.assertEquals((Object)dagUgi, (Object)InputInitializerForUgiTest.ctorUgi);
        Assert.assertEquals((Object)dagUgi, (Object)InputInitializerForUgiTest.initializeUgi);
    }

    public static class InputInitializerForUgiTest
    extends InputInitializer {
        static volatile UserGroupInformation ctorUgi;
        static volatile UserGroupInformation initializeUgi;
        static boolean initialized;
        static final Object initializeSync;

        public InputInitializerForUgiTest(InputInitializerContext initializerContext) {
            super(initializerContext);
            try {
                ctorUgi = UserGroupInformation.getCurrentUser();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Event> initialize() throws Exception {
            initializeUgi = UserGroupInformation.getCurrentUser();
            Object object = initializeSync;
            synchronized (object) {
                initialized = true;
                initializeSync.notify();
            }
            return null;
        }

        public void handleInputInitializerEvent(List<InputInitializerEvent> events) throws Exception {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void awaitInitialize() throws InterruptedException {
            Object object = initializeSync;
            synchronized (object) {
                while (!initialized) {
                    initializeSync.wait();
                }
            }
        }

        static {
            initialized = false;
            initializeSync = new Object();
        }
    }
}

