/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.tez.client.TezApiVersionInfo;
import org.apache.tez.common.ContainerContext;
import org.apache.tez.common.ContainerTask;
import org.apache.tez.common.GuavaShim;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.NamedEntityDescriptor;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerLauncherContextImpl;
import org.apache.tez.dag.app.DAGAppMaster;
import org.apache.tez.dag.app.MockClock;
import org.apache.tez.dag.app.TaskCommunicatorManager;
import org.apache.tez.dag.app.TezTaskCommunicatorImpl;
import org.apache.tez.dag.app.launcher.ContainerLauncherManager;
import org.apache.tez.dag.app.rm.ContainerLauncherEvent;
import org.apache.tez.dag.history.HistoryEventHandler;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.events.TaskAttemptCompletedEvent;
import org.apache.tez.runtime.api.events.TaskStatusUpdateEvent;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.runtime.api.impl.TaskStatistics;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.runtime.api.impl.TezHeartbeatRequest;
import org.apache.tez.runtime.api.impl.TezHeartbeatResponse;
import org.apache.tez.serviceplugins.api.ContainerLaunchRequest;
import org.apache.tez.serviceplugins.api.ContainerLauncher;
import org.apache.tez.serviceplugins.api.ContainerLauncherContext;
import org.apache.tez.serviceplugins.api.ContainerStopRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockDAGAppMaster
extends DAGAppMaster {
    private static final Logger LOG = LoggerFactory.getLogger(MockDAGAppMaster.class);
    MockContainerLauncher containerLauncher;
    private final AtomicBoolean launcherGoFlag;
    boolean initFailFlag;
    boolean startFailFlag;
    boolean recoveryFatalError = false;
    EventsDelegate eventsDelegate;
    CountersDelegate countersDelegate;
    StatisticsDelegate statsDelegate;
    ContainerDelegate containerDelegate;
    long launcherSleepTime = 1L;
    boolean doSleep = true;
    int handlerConcurrency = 1;
    int numConcurrentContainers = 1;
    ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
    AtomicLong heartbeatCpu = new AtomicLong(0L);
    AtomicLong heartbeatTime = new AtomicLong(0L);
    AtomicLong numHearbeats = new AtomicLong(0L);

    public MockDAGAppMaster(ApplicationAttemptId applicationAttemptId, ContainerId containerId, String nmHost, int nmPort, int nmHttpPort, Clock clock, long appSubmitTime, boolean isSession, String workingDirectory, String[] localDirs, String[] logDirs, AtomicBoolean launcherGoFlag, boolean initFailFlag, boolean startFailFlag, Credentials credentials, String jobUserName, int handlerConcurrency, int numConcurrentContainers) {
        super(applicationAttemptId, containerId, nmHost, nmPort, nmHttpPort, clock, appSubmitTime, isSession, workingDirectory, localDirs, logDirs, new TezApiVersionInfo().getVersion(), credentials, jobUserName, null);
        this.shutdownHandler = new MockDAGAppMasterShutdownHandler();
        this.launcherGoFlag = launcherGoFlag;
        this.initFailFlag = initFailFlag;
        this.startFailFlag = startFailFlag;
        Preconditions.checkArgument((handlerConcurrency > 0 ? 1 : 0) != 0);
        this.handlerConcurrency = handlerConcurrency;
        this.numConcurrentContainers = numConcurrentContainers;
    }

    protected ContainerLauncherManager createContainerLauncherManager(List<NamedEntityDescriptor> containerLauncherDescirptors, boolean isLocal) throws UnknownHostException {
        UserPayload userPayload;
        try {
            userPayload = TezUtils.createUserPayloadFromConf((Configuration)new Configuration(false));
        }
        catch (IOException e) {
            throw new TezUncheckedException((Throwable)e);
        }
        ContainerLauncherManager clManager = new ContainerLauncherManager(this.getContext());
        ContainerLauncherContextImpl containerLauncherContext = new ContainerLauncherContextImpl(this.getContext(), clManager, this.getTaskCommunicatorManager(), userPayload, 0);
        this.containerLauncher = new MockContainerLauncher(this.launcherGoFlag, (ContainerLauncherContext)containerLauncherContext);
        clManager.setContainerLauncher((ContainerLauncher)this.containerLauncher);
        return clManager;
    }

    protected HistoryEventHandler createHistoryEventHandler(AppContext appContext) {
        return new MockHistoryEventHandler(appContext);
    }

    public MockContainerLauncher getContainerLauncher() {
        return this.containerLauncher;
    }

    public MockDAGAppMasterShutdownHandler getShutdownHandler() {
        return (MockDAGAppMasterShutdownHandler)this.shutdownHandler;
    }

    public void clearStats() {
        this.heartbeatCpu.set(0L);
        this.heartbeatTime.set(0L);
        this.numHearbeats.set(0L);
    }

    public synchronized void serviceInit(Configuration conf) throws Exception {
        conf.setInt("tez.am.inline.task.execution.max-tasks", this.numConcurrentContainers);
        super.serviceInit(conf);
        if (this.initFailFlag) {
            throw new Exception("FailInit");
        }
    }

    public synchronized void serviceStart() throws Exception {
        super.serviceStart();
        if (this.startFailFlag) {
            throw new Exception("FailStart");
        }
    }

    public class MockDAGAppMasterShutdownHandler
    extends DAGAppMaster.DAGAppMasterShutdownHandler {
        public AtomicInteger shutdownInvoked;
        public AtomicInteger shutdownInvokedWithoutDelay;

        public MockDAGAppMasterShutdownHandler() {
            super((DAGAppMaster)MockDAGAppMaster.this);
            this.shutdownInvoked = new AtomicInteger(0);
            this.shutdownInvokedWithoutDelay = new AtomicInteger(0);
        }

        public void shutdown() {
            this.shutdownInvokedWithoutDelay.incrementAndGet();
        }

        public void shutdown(boolean now) {
            this.shutdownInvoked.incrementAndGet();
        }

        public boolean wasShutdownInvoked() {
            return this.shutdownInvoked.get() > 0 || this.shutdownInvokedWithoutDelay.get() > 0;
        }
    }

    public class MockHistoryEventHandler
    extends HistoryEventHandler {
        public MockHistoryEventHandler(AppContext context) {
            super(context);
        }

        public boolean hasRecoveryFailed() {
            return MockDAGAppMaster.this.recoveryFatalError;
        }
    }

    public class MockContainerLauncher
    extends ContainerLauncher
    implements Runnable {
        BlockingQueue<ContainerLauncherEvent> eventQueue;
        Thread eventHandlingThread;
        ListeningExecutorService executorService;
        Map<ContainerId, ContainerData> containers;
        ArrayBlockingQueue<Worker> workers;
        TaskCommunicatorManager taskCommunicatorManager;
        TezTaskCommunicatorImpl taskCommunicator;
        AtomicBoolean startScheduling;
        AtomicBoolean goFlag;
        boolean updateProgress;
        LinkedBlockingQueue<ContainerData> containersToProcess;
        Map<TezTaskID, Integer> preemptedTasks;
        Map<TezTaskAttemptID, Integer> tasksWithStatusUpdates;

        public MockContainerLauncher(AtomicBoolean goFlag, ContainerLauncherContext containerLauncherContext) {
            super(containerLauncherContext);
            this.eventQueue = new LinkedBlockingQueue<ContainerLauncherEvent>();
            this.containers = Maps.newConcurrentMap();
            this.startScheduling = new AtomicBoolean(true);
            this.updateProgress = true;
            this.containersToProcess = new LinkedBlockingQueue();
            this.preemptedTasks = Maps.newConcurrentMap();
            this.tasksWithStatusUpdates = Maps.newConcurrentMap();
            this.goFlag = goFlag;
        }

        public void start() throws Exception {
            this.taskCommunicatorManager = (TaskCommunicatorManager)MockDAGAppMaster.this.getTaskCommunicatorManager();
            this.taskCommunicator = (TezTaskCommunicatorImpl)this.taskCommunicatorManager.getTaskCommunicator(0).getTaskCommunicator();
            this.eventHandlingThread = new Thread(this);
            this.eventHandlingThread.start();
            ExecutorService rawExecutor = Executors.newFixedThreadPool(MockDAGAppMaster.this.handlerConcurrency, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("MockLauncherExecutionThread [%d]").build());
            this.executorService = MoreExecutors.listeningDecorator((ExecutorService)rawExecutor);
            int numWorkers = MockDAGAppMaster.this.numConcurrentContainers * 2;
            this.workers = new ArrayBlockingQueue(numWorkers);
            for (int i = 0; i < numWorkers; ++i) {
                this.workers.add(new Worker());
            }
        }

        public void shutdown() throws Exception {
            if (this.eventHandlingThread != null) {
                this.eventHandlingThread.interrupt();
                this.eventHandlingThread.join(2000L);
            }
            if (this.executorService != null) {
                this.executorService.shutdownNow();
            }
        }

        public void launchContainer(ContainerLaunchRequest launchRequest) {
            this.launch(launchRequest);
        }

        public void stopContainer(ContainerStopRequest stopRequest) {
            this.stop(stopRequest);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitToGo() {
            if (this.goFlag == null) {
                return;
            }
            AtomicBoolean atomicBoolean = this.goFlag;
            synchronized (atomicBoolean) {
                this.goFlag.set(true);
                this.goFlag.notify();
                try {
                    this.goFlag.wait();
                }
                catch (InterruptedException e) {
                    throw new TezUncheckedException((Throwable)e);
                }
            }
        }

        public void startScheduling(boolean value) {
            this.startScheduling.set(value);
        }

        public void updateProgress(boolean value) {
            this.updateProgress = value;
        }

        public Map<ContainerId, ContainerData> getContainers() {
            return this.containers;
        }

        public void preemptContainerForTask(TezTaskID tId, int uptoVersion) {
            this.preemptedTasks.put(tId, uptoVersion);
        }

        public void preemptContainer(ContainerData cData) {
            MockDAGAppMaster.this.getTaskSchedulerManager().containerCompleted(0, null, ContainerStatus.newInstance((ContainerId)cData.cId, null, (String)"Preempted", (int)-102));
            cData.clear();
        }

        public void setStatusUpdatesForTask(TezTaskAttemptID tId, int numUpdates) {
            this.tasksWithStatusUpdates.put(tId, numUpdates);
        }

        void stop(ContainerStopRequest event) {
            this.containers.remove(event.getContainerId());
            if (MockDAGAppMaster.this.containerDelegate != null) {
                MockDAGAppMaster.this.containerDelegate.stop(event);
            }
            this.getContext().containerStopRequested(event.getContainerId());
        }

        void launch(ContainerLaunchRequest event) {
            ContainerData cData = new ContainerData(event.getContainerId(), event.getContainerLaunchContext());
            this.containers.put(event.getContainerId(), cData);
            this.containersToProcess.add(cData);
            if (MockDAGAppMaster.this.containerDelegate != null) {
                MockDAGAppMaster.this.containerDelegate.launch(event);
            }
            this.getContext().containerLaunched(event.getContainerId());
        }

        public void waitTillContainersLaunched() throws InterruptedException {
            while (this.containers.isEmpty()) {
                Thread.sleep(50L);
            }
        }

        void incrementTime(long inc) {
            Clock clock = MockDAGAppMaster.this.getContext().getClock();
            if (clock instanceof MockClock) {
                ((MockClock)clock).incrementTime(inc);
            }
        }

        @Override
        public void run() {
            Thread.currentThread().setName("MockLauncher");
            LOG.info("Waiting to go");
            this.waitToGo();
            LOG.info("Signal to go");
            try {
                while (true) {
                    if (!this.startScheduling.get()) {
                        Thread.sleep(MockDAGAppMaster.this.launcherSleepTime);
                        continue;
                    }
                    this.incrementTime(1000L);
                    ContainerData cData = this.containersToProcess.take();
                    if (!cData.remove.get()) {
                        Worker worker = (Worker)this.workers.remove();
                        worker.setContainerData(cData);
                        ListenableFuture future = this.executorService.submit((Callable)worker);
                        Futures.addCallback((ListenableFuture)future, (FutureCallback)worker.getCallback(), (Executor)GuavaShim.directExecutor());
                    } else {
                        this.containers.remove(cData.cId);
                    }
                    if (!MockDAGAppMaster.this.doSleep) continue;
                    Thread.sleep(MockDAGAppMaster.this.launcherSleepTime);
                }
            }
            catch (InterruptedException ie) {
                LOG.warn("Exception in mock container launcher thread", (Throwable)ie);
                return;
            }
        }

        private void doHeartbeat(TezHeartbeatRequest request, ContainerData cData) throws Exception {
            long startTime = System.nanoTime();
            long startCpuTime = MockDAGAppMaster.this.threadMxBean.getCurrentThreadCpuTime();
            TezHeartbeatResponse response = this.taskCommunicator.getUmbilical().heartbeat(request);
            if (response.shouldDie()) {
                cData.remove();
            } else {
                cData.nextFromEventId = response.getNextFromEventId();
                cData.nextPreRoutedFromEventId = response.getNextPreRoutedEventId();
                if (!response.getEvents().isEmpty()) {
                    long stopTime = System.nanoTime();
                    long stopCpuTime = MockDAGAppMaster.this.threadMxBean.getCurrentThreadCpuTime();
                    MockDAGAppMaster.this.heartbeatTime.addAndGet((stopTime - startTime) / 1000L);
                    MockDAGAppMaster.this.heartbeatCpu.addAndGet((stopCpuTime - startCpuTime) / 1000L);
                    MockDAGAppMaster.this.numHearbeats.incrementAndGet();
                }
            }
        }

        class Worker
        implements Callable<Void> {
            volatile ContainerData cData;
            WorkerCallback callback = new WorkerCallback();

            Worker() {
            }

            WorkerCallback getCallback() {
                return this.callback;
            }

            void setContainerData(ContainerData cData) {
                this.cData = cData;
            }

            @Override
            public Void call() throws Exception {
                try {
                    if (this.cData.taId == null) {
                        ContainerTask cTask = MockContainerLauncher.this.taskCommunicator.getUmbilical().getTask(new ContainerContext(this.cData.cIdStr));
                        if (cTask != null) {
                            if (cTask.shouldDie()) {
                                this.cData.remove();
                            } else {
                                this.cData.taId = cTask.getTaskSpec().getTaskAttemptID();
                                this.cData.vName = cTask.getTaskSpec().getVertexName();
                                this.cData.taskSpec = cTask.getTaskSpec();
                            }
                        }
                    } else if (!this.cData.completed) {
                        Integer version = MockContainerLauncher.this.preemptedTasks.get(this.cData.taId.getTaskID());
                        Integer updatesToMake = MockContainerLauncher.this.tasksWithStatusUpdates.get(this.cData.taId);
                        if (this.cData.numUpdates == 0 || updatesToMake != null && this.cData.numUpdates < updatesToMake) {
                            ArrayList events = Lists.newArrayListWithCapacity((int)(this.cData.taskSpec.getOutputs().size() + 1));
                            if (this.cData.numUpdates == 0 && MockDAGAppMaster.this.eventsDelegate != null) {
                                MockDAGAppMaster.this.eventsDelegate.getEvents(this.cData.taskSpec, events, MockDAGAppMaster.this.getContext().getClock().getTime());
                            }
                            TezCounters counters = null;
                            if (MockDAGAppMaster.this.countersDelegate != null) {
                                counters = MockDAGAppMaster.this.countersDelegate.getCounters(this.cData.taskSpec);
                            }
                            TaskStatistics stats = null;
                            if (MockDAGAppMaster.this.statsDelegate != null) {
                                stats = MockDAGAppMaster.this.statsDelegate.getStatistics(this.cData.taskSpec);
                            }
                            ++this.cData.numUpdates;
                            float maxUpdates = updatesToMake != null ? (float)updatesToMake.intValue() : 1.0f;
                            float progress = MockContainerLauncher.this.updateProgress ? (float)this.cData.numUpdates / maxUpdates : 0.0f;
                            events.add(new TezEvent((Event)new TaskStatusUpdateEvent(counters, progress, stats, false), new EventMetaData(EventMetaData.EventProducerConsumerType.SYSTEM, this.cData.vName, "", this.cData.taId), MockDAGAppMaster.this.getContext().getClock().getTime()));
                            TezHeartbeatRequest request = new TezHeartbeatRequest((long)this.cData.numUpdates, (List)events, this.cData.nextPreRoutedFromEventId, this.cData.cIdStr, this.cData.taId, this.cData.nextFromEventId, 50000, 0L);
                            MockContainerLauncher.this.doHeartbeat(request, this.cData);
                        } else if (version != null && this.cData.taId.getId() <= version) {
                            MockContainerLauncher.this.preemptContainer(this.cData);
                        } else {
                            this.cData.completed = true;
                            List<TezEvent> events = Collections.singletonList(new TezEvent((Event)new TaskAttemptCompletedEvent(), new EventMetaData(EventMetaData.EventProducerConsumerType.SYSTEM, this.cData.vName, "", this.cData.taId), MockDAGAppMaster.this.getContext().getClock().getTime()));
                            TezHeartbeatRequest request = new TezHeartbeatRequest((long)(++this.cData.numUpdates), events, this.cData.nextPreRoutedFromEventId, this.cData.cIdStr, this.cData.taId, this.cData.nextFromEventId, 10000, 0L);
                            MockContainerLauncher.this.doHeartbeat(request, this.cData);
                            this.cData.clear();
                        }
                    }
                }
                catch (Exception e) {
                    LOG.warn("Exception in mock container launcher thread for cId: " + this.cData.cIdStr, (Throwable)e);
                    this.cData.remove();
                }
                return null;
            }

            class WorkerCallback
            implements FutureCallback<Void> {
                WorkerCallback() {
                }

                public void onSuccess(Void arg) {
                    this.completeOperation();
                }

                public void onFailure(Throwable t) {
                    LOG.error("Unexpected error during processing", t);
                    Worker.this.cData.remove();
                    this.completeOperation();
                }

                void completeOperation() {
                    MockContainerLauncher.this.workers.add(Worker.this);
                    MockContainerLauncher.this.containersToProcess.add(Worker.this.cData);
                }
            }
        }

        public class ContainerData {
            ContainerId cId;
            TezTaskAttemptID taId;
            String vName;
            TaskSpec taskSpec;
            ContainerLaunchContext launchContext;
            int numUpdates = 0;
            int nextFromEventId = 0;
            int nextPreRoutedFromEventId = 0;
            boolean completed;
            String cIdStr;
            AtomicBoolean remove = new AtomicBoolean(false);

            public ContainerData(ContainerId cId, ContainerLaunchContext context) {
                this.cId = cId;
                this.cIdStr = cId.toString();
                this.launchContext = context;
            }

            void remove() {
                this.remove.set(true);
            }

            void clear() {
                this.taId = null;
                this.vName = null;
                this.taskSpec = null;
                this.completed = false;
                this.launchContext = null;
                this.numUpdates = 0;
                this.nextFromEventId = 0;
                this.nextPreRoutedFromEventId = 0;
                this.cIdStr = null;
                this.remove.set(false);
            }
        }
    }

    public static interface ContainerDelegate {
        public void stop(ContainerStopRequest var1);

        public void launch(ContainerLaunchRequest var1);
    }

    public static interface EventsDelegate {
        public void getEvents(TaskSpec var1, List<TezEvent> var2, long var3);
    }

    public static interface CountersDelegate {
        public TezCounters getCounters(TaskSpec var1);
    }

    public static interface StatisticsDelegate {
        public TaskStatistics getStatistics(TaskSpec var1);
    }
}

