/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.recovery.records.RecoveryProtos;

public class AMStartedEvent
implements HistoryEvent {
    private ApplicationAttemptId applicationAttemptId;
    private long startTime;
    private String user;

    public AMStartedEvent() {
    }

    public AMStartedEvent(ApplicationAttemptId appAttemptId, long startTime, String user) {
        this.applicationAttemptId = appAttemptId;
        this.startTime = startTime;
        this.user = user;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.AM_STARTED;
    }

    @Override
    public boolean isRecoveryEvent() {
        return false;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public String toString() {
        return "appAttemptId=" + this.applicationAttemptId + ", startTime=" + this.startTime;
    }

    public RecoveryProtos.AMStartedProto toProto() {
        return RecoveryProtos.AMStartedProto.newBuilder().setApplicationAttemptId(this.applicationAttemptId.toString()).setStartTime(this.startTime).build();
    }

    public void fromProto(RecoveryProtos.AMStartedProto proto) {
        this.applicationAttemptId = ConverterUtils.toApplicationAttemptId((String)proto.getApplicationAttemptId());
        this.startTime = proto.getStartTime();
    }

    @Override
    public void toProtoStream(CodedOutputStream outputStream) throws IOException {
        outputStream.writeMessageNoTag((MessageLite)this.toProto());
    }

    @Override
    public void fromProtoStream(CodedInputStream inputStream) throws IOException {
        RecoveryProtos.AMStartedProto proto = (RecoveryProtos.AMStartedProto)inputStream.readMessage(RecoveryProtos.AMStartedProto.PARSER, ExtensionRegistryLite.getEmptyRegistry());
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.applicationAttemptId;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getUser() {
        return this.user;
    }
}

