/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.TaskCommunicatorManagerInterface;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEventType;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEventUserServiceFatalError;
import org.apache.tez.dag.app.launcher.ContainerLauncherManager;
import org.apache.tez.dag.app.rm.container.AMContainerEvent;
import org.apache.tez.dag.app.rm.container.AMContainerEventCompleted;
import org.apache.tez.dag.app.rm.container.AMContainerEventLaunchFailed;
import org.apache.tez.dag.app.rm.container.AMContainerEventLaunched;
import org.apache.tez.dag.app.rm.container.AMContainerEventStopFailed;
import org.apache.tez.dag.app.rm.container.AMContainerEventType;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.events.ContainerLaunchedEvent;
import org.apache.tez.serviceplugins.api.ContainerLauncherContext;
import org.apache.tez.serviceplugins.api.DagInfo;
import org.apache.tez.serviceplugins.api.ServicePluginError;
import org.apache.tez.serviceplugins.api.TaskAttemptEndReason;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerLauncherContextImpl
implements ContainerLauncherContext {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerLauncherContextImpl.class);
    private final AppContext context;
    private final ContainerLauncherManager containerLauncherManager;
    private final TaskCommunicatorManagerInterface tal;
    private final UserPayload initialUserPayload;
    private final int containerLauncherIndex;

    public ContainerLauncherContextImpl(AppContext appContext, ContainerLauncherManager containerLauncherManager, TaskCommunicatorManagerInterface tal, UserPayload initialUserPayload, int containerLauncherIndex) {
        Objects.requireNonNull(appContext, "AppContext cannot be null");
        Objects.requireNonNull(appContext, "ContainerLauncherManager cannot be null");
        Objects.requireNonNull(tal, "TaskCommunicator cannot be null");
        this.context = appContext;
        this.containerLauncherManager = containerLauncherManager;
        this.tal = tal;
        this.initialUserPayload = initialUserPayload;
        this.containerLauncherIndex = containerLauncherIndex;
    }

    public void containerLaunched(ContainerId containerId) {
        this.context.getEventHandler().handle((Event)new AMContainerEventLaunched(containerId));
        ContainerLaunchedEvent lEvt = new ContainerLaunchedEvent(containerId, this.context.getClock().getTime(), this.context.getApplicationAttemptId());
        this.context.getHistoryHandler().handle(new DAGHistoryEvent(null, lEvt));
    }

    public void containerLaunchFailed(ContainerId containerId, String diagnostics) {
        this.context.getEventHandler().handle((Event)new AMContainerEventLaunchFailed(containerId, diagnostics));
    }

    public void containerStopRequested(ContainerId containerId) {
        this.context.getEventHandler().handle((Event)new AMContainerEvent(containerId, AMContainerEventType.C_NM_STOP_SENT));
    }

    public void containerStopFailed(ContainerId containerId, String diagnostics) {
        this.context.getEventHandler().handle((Event)new AMContainerEventStopFailed(containerId, diagnostics));
    }

    public void containerCompleted(ContainerId containerId, int exitStatus, String diagnostics, TaskAttemptEndReason endReason) {
        this.context.getEventHandler().handle((Event)new AMContainerEventCompleted(containerId, exitStatus, diagnostics, TezUtilsInternal.fromTaskAttemptEndReason((TaskAttemptEndReason)endReason)));
    }

    public UserPayload getInitialUserPayload() {
        return this.initialUserPayload;
    }

    public int getNumNodes(String sourceName) {
        int sourceIndex = this.context.getTaskScheduerIdentifier(sourceName);
        int numNodes = this.context.getNodeTracker().getNumNodes(sourceIndex);
        return numNodes;
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.context.getApplicationAttemptId();
    }

    @Nullable
    public DagInfo getCurrentDagInfo() {
        return this.context.getCurrentDAG();
    }

    public Object getTaskCommunicatorMetaInfo(String taskCommName) {
        int taskCommId = this.context.getTaskCommunicatorIdentifier(taskCommName);
        try {
            return this.tal.getTaskCommunicator(taskCommId).getMetaInfo();
        }
        catch (Exception e) {
            String msg = "Error in retrieving meta-info from TaskCommunicator, communicatorName=" + this.context.getTaskCommunicatorName(taskCommId);
            LOG.error(msg, (Throwable)e);
            this.context.getEventHandler().handle((Event)new DAGAppMasterEventUserServiceFatalError(DAGAppMasterEventType.TASK_COMMUNICATOR_SERVICE_FATAL_ERROR, msg, e));
            return null;
        }
    }

    public void reportError(ServicePluginError servicePluginError, String message, DagInfo dagInfo) {
        Objects.requireNonNull(servicePluginError, "ServiceError must be specified");
        this.containerLauncherManager.reportError(this.containerLauncherIndex, servicePluginError, message, dagInfo);
    }
}

