/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.hadoop.yarn.util.Clock;

public class MockClock
implements Clock {
    long time;
    Collection<MockClockListener> listeners = new LinkedList<MockClockListener>();

    public MockClock() {
        this(1000L);
    }

    public MockClock(long initTime) {
        this.time = initTime;
    }

    public long getTime() {
        return this.time;
    }

    public void incrementTime(long inc) {
        this.time += inc;
        for (MockClockListener listener : this.listeners) {
            listener.onTimeUpdated(this.time);
        }
    }

    public void register(MockClockListener listener) {
        this.listeners.add(listener);
    }

    public static interface MockClockListener {
        public void onTimeUpdated(long var1);
    }
}

