/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.NamedEntityDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezConstants;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerHeartbeatHandler;
import org.apache.tez.dag.app.TaskAttemptEventInfo;
import org.apache.tez.dag.app.TaskCommunicatorManager;
import org.apache.tez.dag.app.TaskHeartbeatHandler;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventAttemptFailed;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventAttemptKilled;
import org.apache.tez.dag.app.rm.container.AMContainer;
import org.apache.tez.dag.app.rm.container.AMContainerMap;
import org.apache.tez.dag.app.rm.container.AMContainerTask;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.TaskFailureType;
import org.apache.tez.runtime.api.events.TaskAttemptFailedEvent;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.serviceplugins.api.TaskAttemptEndReason;
import org.apache.tez.serviceplugins.api.TaskHeartbeatRequest;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestTaskCommunicatorManager2 {
    @Test(timeout=5000L)
    public void testTaskAttemptFailedKilled() throws IOException, TezException {
        TaskCommunicatorManagerWrapperForTest wrapper = new TaskCommunicatorManagerWrapperForTest();
        TaskSpec taskSpec1 = wrapper.createTaskSpec();
        AMContainerTask amContainerTask1 = new AMContainerTask(taskSpec1, null, null, false, 10);
        TaskSpec taskSpec2 = wrapper.createTaskSpec();
        AMContainerTask amContainerTask2 = new AMContainerTask(taskSpec2, null, null, false, 10);
        ContainerId containerId1 = wrapper.createContainerId(1);
        wrapper.registerRunningContainer(containerId1);
        wrapper.registerTaskAttempt(containerId1, amContainerTask1);
        ContainerId containerId2 = wrapper.createContainerId(2);
        wrapper.registerRunningContainer(containerId2);
        wrapper.registerTaskAttempt(containerId2, amContainerTask2);
        wrapper.getTaskCommunicatorManager().taskFailed(amContainerTask1.getTask().getTaskAttemptID(), TaskFailureType.NON_FATAL, TaskAttemptEndReason.COMMUNICATION_ERROR, "Diagnostics1");
        wrapper.getTaskCommunicatorManager().taskKilled(amContainerTask2.getTask().getTaskAttemptID(), TaskAttemptEndReason.EXECUTOR_BUSY, "Diagnostics2");
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)wrapper.getEventHandler(), (VerificationMode)Mockito.times((int)2))).handle((Event)argumentCaptor.capture());
        Assert.assertTrue((boolean)(argumentCaptor.getAllValues().get(0) instanceof TaskAttemptEventAttemptFailed));
        Assert.assertTrue((boolean)(argumentCaptor.getAllValues().get(1) instanceof TaskAttemptEventAttemptKilled));
        TaskAttemptEventAttemptFailed failedEvent = (TaskAttemptEventAttemptFailed)argumentCaptor.getAllValues().get(0);
        TaskAttemptEventAttemptKilled killedEvent = (TaskAttemptEventAttemptKilled)argumentCaptor.getAllValues().get(1);
        Assert.assertEquals((Object)"Diagnostics1", (Object)failedEvent.getDiagnosticInfo());
        Assert.assertEquals((Object)TaskAttemptTerminationCause.COMMUNICATION_ERROR, (Object)failedEvent.getTerminationCause());
        Assert.assertEquals((Object)"Diagnostics2", (Object)killedEvent.getDiagnosticInfo());
        Assert.assertEquals((Object)TaskAttemptTerminationCause.SERVICE_BUSY, (Object)killedEvent.getTerminationCause());
    }

    @Test(timeout=5000L)
    public void testTaskAttemptFailureViaHeartbeat() throws IOException, TezException {
        TaskCommunicatorManagerWrapperForTest wrapper = new TaskCommunicatorManagerWrapperForTest();
        TaskSpec taskSpec1 = wrapper.createTaskSpec();
        AMContainerTask amContainerTask1 = new AMContainerTask(taskSpec1, null, null, false, 10);
        TaskSpec taskSpec2 = wrapper.createTaskSpec();
        AMContainerTask amContainerTask2 = new AMContainerTask(taskSpec2, null, null, false, 10);
        ContainerId containerId1 = wrapper.createContainerId(1);
        wrapper.registerRunningContainer(containerId1);
        wrapper.registerTaskAttempt(containerId1, amContainerTask1);
        ContainerId containerId2 = wrapper.createContainerId(2);
        wrapper.registerRunningContainer(containerId2);
        wrapper.registerTaskAttempt(containerId2, amContainerTask2);
        LinkedList<TezEvent> events = new LinkedList<TezEvent>();
        EventMetaData sourceInfo1 = new EventMetaData(EventMetaData.EventProducerConsumerType.PROCESSOR, "testVertex", null, taskSpec1.getTaskAttemptID());
        TaskAttemptFailedEvent failedEvent1 = new TaskAttemptFailedEvent("non-fatal test error", TaskFailureType.NON_FATAL);
        TezEvent failedEventT1 = new TezEvent((org.apache.tez.runtime.api.Event)failedEvent1, sourceInfo1);
        events.add(failedEventT1);
        TaskHeartbeatRequest taskHeartbeatRequest1 = new TaskHeartbeatRequest(containerId1.toString(), taskSpec1.getTaskAttemptID(), events, 0, 0, 0);
        wrapper.getTaskCommunicatorManager().heartbeat(taskHeartbeatRequest1);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)wrapper.getEventHandler(), (VerificationMode)Mockito.times((int)1))).handle((Event)argumentCaptor.capture());
        Assert.assertTrue((boolean)(argumentCaptor.getAllValues().get(0) instanceof TaskAttemptEventAttemptFailed));
        TaskAttemptEventAttemptFailed failedEvent = (TaskAttemptEventAttemptFailed)argumentCaptor.getAllValues().get(0);
        Assert.assertEquals((Object)TaskFailureType.NON_FATAL, (Object)failedEvent.getTaskFailureType());
        Assert.assertTrue((boolean)failedEvent.getDiagnosticInfo().contains("non-fatal"));
        events.clear();
        Mockito.reset((Object[])new EventHandler[]{wrapper.getEventHandler()});
        EventMetaData sourceInfo2 = new EventMetaData(EventMetaData.EventProducerConsumerType.PROCESSOR, "testVertex", null, taskSpec2.getTaskAttemptID());
        TaskAttemptFailedEvent failedEvent2 = new TaskAttemptFailedEvent("-fatal- test error", TaskFailureType.FATAL);
        TezEvent failedEventT2 = new TezEvent((org.apache.tez.runtime.api.Event)failedEvent2, sourceInfo2);
        events.add(failedEventT2);
        TaskHeartbeatRequest taskHeartbeatRequest2 = new TaskHeartbeatRequest(containerId2.toString(), taskSpec2.getTaskAttemptID(), events, 0, 0, 0);
        wrapper.getTaskCommunicatorManager().heartbeat(taskHeartbeatRequest2);
        argumentCaptor = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)wrapper.getEventHandler(), (VerificationMode)Mockito.times((int)1))).handle((Event)argumentCaptor.capture());
        Assert.assertTrue((boolean)(argumentCaptor.getAllValues().get(0) instanceof TaskAttemptEventAttemptFailed));
        failedEvent = (TaskAttemptEventAttemptFailed)argumentCaptor.getAllValues().get(0);
        Assert.assertEquals((Object)TaskFailureType.FATAL, (Object)failedEvent.getTaskFailureType());
        Assert.assertTrue((boolean)failedEvent.getDiagnosticInfo().contains("-fatal-"));
    }

    @Test(timeout=5000L)
    public void testTaskAttemptFailureViaContext() throws IOException, TezException {
        TaskCommunicatorManagerWrapperForTest wrapper = new TaskCommunicatorManagerWrapperForTest();
        TaskSpec taskSpec1 = wrapper.createTaskSpec();
        AMContainerTask amContainerTask1 = new AMContainerTask(taskSpec1, null, null, false, 10);
        TaskSpec taskSpec2 = wrapper.createTaskSpec();
        AMContainerTask amContainerTask2 = new AMContainerTask(taskSpec2, null, null, false, 10);
        ContainerId containerId1 = wrapper.createContainerId(1);
        wrapper.registerRunningContainer(containerId1);
        wrapper.registerTaskAttempt(containerId1, amContainerTask1);
        ContainerId containerId2 = wrapper.createContainerId(2);
        wrapper.registerRunningContainer(containerId2);
        wrapper.registerTaskAttempt(containerId2, amContainerTask2);
        wrapper.getTaskCommunicatorManager().taskFailed(taskSpec1.getTaskAttemptID(), TaskFailureType.NON_FATAL, TaskAttemptEndReason.CONTAINER_EXITED, "--non-fatal--");
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)wrapper.getEventHandler(), (VerificationMode)Mockito.times((int)1))).handle((Event)argumentCaptor.capture());
        Assert.assertTrue((boolean)(argumentCaptor.getAllValues().get(0) instanceof TaskAttemptEventAttemptFailed));
        TaskAttemptEventAttemptFailed failedEvent = (TaskAttemptEventAttemptFailed)argumentCaptor.getAllValues().get(0);
        Assert.assertEquals((Object)TaskFailureType.NON_FATAL, (Object)failedEvent.getTaskFailureType());
        Assert.assertTrue((boolean)failedEvent.getDiagnosticInfo().contains("--non-fatal--"));
        Mockito.reset((Object[])new EventHandler[]{wrapper.getEventHandler()});
        wrapper.getTaskCommunicatorManager().taskFailed(taskSpec2.getTaskAttemptID(), TaskFailureType.FATAL, TaskAttemptEndReason.OTHER, "--fatal--");
        argumentCaptor = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)wrapper.getEventHandler(), (VerificationMode)Mockito.times((int)1))).handle((Event)argumentCaptor.capture());
        Assert.assertTrue((boolean)(argumentCaptor.getAllValues().get(0) instanceof TaskAttemptEventAttemptFailed));
        failedEvent = (TaskAttemptEventAttemptFailed)argumentCaptor.getAllValues().get(0);
        Assert.assertEquals((Object)TaskFailureType.FATAL, (Object)failedEvent.getTaskFailureType());
        Assert.assertTrue((boolean)failedEvent.getDiagnosticInfo().contains("--fatal--"));
    }

    private static class TaskCommunicatorManagerWrapperForTest {
        ApplicationId appId = ApplicationId.newInstance((long)1000L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)this.appId, (int)1);
        Credentials credentials = new Credentials();
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        DAG dag = (DAG)Mockito.mock(DAG.class);
        Vertex vertex = (Vertex)Mockito.mock(Vertex.class);
        TezDAGID dagId;
        TezVertexID vertexId;
        AMContainerMap amContainerMap = (AMContainerMap)Mockito.mock(AMContainerMap.class);
        Map<ApplicationAccessType, String> appAcls = new HashMap<ApplicationAccessType, String>();
        Configuration conf = new TezConfiguration();
        UserPayload userPayload;
        TaskCommunicatorManager taskCommunicatorManager;
        private AtomicInteger taskIdCounter = new AtomicInteger(0);

        TaskCommunicatorManagerWrapperForTest() throws IOException, TezException {
            this.dagId = TezDAGID.getInstance((ApplicationId)this.appId, (int)1);
            this.vertexId = TezVertexID.getInstance((TezDAGID)this.dagId, (int)100);
            ((AppContext)Mockito.doReturn((Object)this.eventHandler).when((Object)this.appContext)).getEventHandler();
            ((AppContext)Mockito.doReturn((Object)this.dag).when((Object)this.appContext)).getCurrentDAG();
            ((DAG)Mockito.doReturn((Object)this.vertex).when((Object)this.dag)).getVertex((TezVertexID)Mockito.eq((Object)this.vertexId));
            ((Vertex)Mockito.doReturn((Object)new TaskAttemptEventInfo(0, new LinkedList(), 0)).when((Object)this.vertex)).getTaskAttemptTezEvents((TezTaskAttemptID)Mockito.any(), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt());
            ((AppContext)Mockito.doReturn((Object)this.appAttemptId).when((Object)this.appContext)).getApplicationAttemptId();
            ((AppContext)Mockito.doReturn((Object)this.credentials).when((Object)this.appContext)).getAppCredentials();
            ((AppContext)Mockito.doReturn(this.appAcls).when((Object)this.appContext)).getApplicationACLs();
            ((AppContext)Mockito.doReturn((Object)this.amContainerMap).when((Object)this.appContext)).getAllContainers();
            ((AppContext)Mockito.doReturn((Object)new SystemClock()).when((Object)this.appContext)).getClock();
            NodeId nodeId = NodeId.newInstance((String)"localhost", (int)0);
            AMContainer amContainer = (AMContainer)Mockito.mock(AMContainer.class);
            Container container = (Container)Mockito.mock(Container.class);
            ((Container)Mockito.doReturn((Object)nodeId).when((Object)container)).getNodeId();
            ((AMContainerMap)Mockito.doReturn((Object)amContainer).when((Object)this.amContainerMap)).get((ContainerId)Mockito.any());
            ((AMContainer)Mockito.doReturn((Object)container).when((Object)amContainer)).getContainer();
            this.userPayload = TezUtils.createUserPayloadFromConf((Configuration)this.conf);
            this.taskCommunicatorManager = new TaskCommunicatorManager(this.appContext, (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), (ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (List)Lists.newArrayList((Object[])new NamedEntityDescriptor[]{new NamedEntityDescriptor(TezConstants.getTezYarnServicePluginName(), null).setUserPayload(this.userPayload)}));
        }

        TaskCommunicatorManager getTaskCommunicatorManager() {
            return this.taskCommunicatorManager;
        }

        EventHandler getEventHandler() {
            return this.eventHandler;
        }

        private void registerRunningContainer(ContainerId containerId) {
            this.taskCommunicatorManager.registerRunningContainer(containerId, 0);
        }

        private void registerTaskAttempt(ContainerId containerId, AMContainerTask amContainerTask) {
            this.taskCommunicatorManager.registerTaskAttempt(amContainerTask, containerId, 0);
        }

        private TaskSpec createTaskSpec() {
            TaskSpec taskSpec = (TaskSpec)Mockito.mock(TaskSpec.class);
            TezTaskID taskId = TezTaskID.getInstance((TezVertexID)this.vertexId, (int)this.taskIdCounter.incrementAndGet());
            TezTaskAttemptID taskAttemptId = TezTaskAttemptID.getInstance((TezTaskID)taskId, (int)0);
            ((TaskSpec)Mockito.doReturn((Object)taskAttemptId).when((Object)taskSpec)).getTaskAttemptID();
            return taskSpec;
        }

        private ContainerId createContainerId(int id) {
            ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)this.appId, (int)1);
            ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)id);
            return containerId;
        }
    }
}

