/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common.web;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.http.HttpServer2;
import org.apache.tez.common.TezUtilsInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ProfileServlet.class);
    private static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    private static final String ALLOWED_METHODS = "GET";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private static final String CONTENT_TYPE_TEXT = "text/plain; charset=utf-8";
    private static final String ASYNC_PROFILER_HOME_ENV = "ASYNC_PROFILER_HOME";
    private static final String ASYNC_PROFILER_HOME_SYSTEM_PROPERTY = "async.profiler.home";
    private static final String PROFILER_SCRIPT = "/profiler.sh";
    private static final int DEFAULT_DURATION_SECONDS = 10;
    private static final AtomicInteger ID_GEN = new AtomicInteger(0);
    public static final String OUTPUT_DIR = System.getProperty("java.io.tmpdir") + "/prof-output";
    private final Lock profilerLock = new ReentrantLock();
    private Integer pid;
    private String asyncProfilerHome = ProfileServlet.getAsyncProfilerHome();
    private transient Process process;

    public ProfileServlet() {
        this.pid = TezUtilsInternal.getPid();
        LOG.info("Servlet process PID: {} asyncProfilerHome: {}", (Object)this.pid, (Object)this.asyncProfilerHome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintStream out;
        block20: {
            response.setContentType("text/plain; charset=UTF-8");
            out = new PrintStream((OutputStream)response.getOutputStream(), false, "UTF-8");
            if (!HttpServer2.isInstrumentationAccessAllowed((ServletContext)this.getServletContext(), (HttpServletRequest)request, (HttpServletResponse)response)) {
                response.setStatus(401);
                this.setResponseHeader(response);
                out.println("Unauthorized: Instrumentation access is not allowed!");
                out.close();
                return;
            }
            if (this.asyncProfilerHome == null || this.asyncProfilerHome.trim().isEmpty()) {
                response.setStatus(500);
                this.setResponseHeader(response);
                out.println("ASYNC_PROFILER_HOME env is not set");
                out.close();
                return;
            }
            this.pid = this.getInteger(request, "pid", this.pid);
            if (this.pid == null) {
                response.setStatus(500);
                this.setResponseHeader(response);
                out.println("'pid' query parameter unspecified or unable to determine PID of current process.");
                out.close();
                return;
            }
            int duration = this.getInteger(request, "duration", 10);
            Output output = this.getOutput(request);
            Event event = this.getEvent(request);
            Long interval = this.getLong(request, "interval");
            Integer jstackDepth = this.getInteger(request, "jstackdepth", null);
            Long bufsize = this.getLong(request, "bufsize");
            boolean thread = request.getParameterMap().containsKey("thread");
            boolean simple = request.getParameterMap().containsKey("simple");
            Integer width = this.getInteger(request, "width", null);
            Integer height = this.getInteger(request, "height", null);
            Double minwidth = this.getMinWidth(request);
            boolean reverse = request.getParameterMap().containsKey("reverse");
            if (this.process == null || !this.process.isAlive()) {
                try {
                    int lockTimeoutSecs = 3;
                    if (this.profilerLock.tryLock(lockTimeoutSecs, TimeUnit.SECONDS)) {
                        try {
                            File outputFile = new File(OUTPUT_DIR, "async-prof-pid-" + this.pid + "-" + event.name().toLowerCase() + "-" + ID_GEN.incrementAndGet() + "." + output.name().toLowerCase());
                            ArrayList<String> cmd = new ArrayList<String>();
                            cmd.add(this.asyncProfilerHome + PROFILER_SCRIPT);
                            cmd.add("-e");
                            cmd.add(event.getInternalName());
                            cmd.add("-d");
                            cmd.add("" + duration);
                            cmd.add("-o");
                            cmd.add(output.name().toLowerCase());
                            cmd.add("-f");
                            cmd.add(outputFile.getAbsolutePath());
                            if (interval != null) {
                                cmd.add("-i");
                                cmd.add(interval.toString());
                            }
                            if (jstackDepth != null) {
                                cmd.add("-j");
                                cmd.add(jstackDepth.toString());
                            }
                            if (bufsize != null) {
                                cmd.add("-b");
                                cmd.add(bufsize.toString());
                            }
                            if (thread) {
                                cmd.add("-t");
                            }
                            if (simple) {
                                cmd.add("-s");
                            }
                            if (width != null) {
                                cmd.add("--width");
                                cmd.add(width.toString());
                            }
                            if (height != null) {
                                cmd.add("--height");
                                cmd.add(height.toString());
                            }
                            if (minwidth != null) {
                                cmd.add("--minwidth");
                                cmd.add(minwidth.toString());
                            }
                            if (reverse) {
                                cmd.add("--reverse");
                            }
                            cmd.add(this.pid.toString());
                            this.process = new ProcessBuilder(cmd).start();
                            this.setResponseHeader(response);
                            response.setStatus(202);
                            String relativeUrl = "/prof-output";
                            int refreshDelay = this.getInteger(request, "refreshDelay", 0);
                            response.setHeader("Refresh", duration + refreshDelay + "; URL=" + relativeUrl + "?file=" + outputFile.getName());
                            out.println("Profiled PID: " + this.pid);
                            out.println("Started [" + event.getInternalName() + "] profiling. This page will automatically redirect to " + relativeUrl + " after " + duration + " seconds.\n\ncommand:\n" + Joiner.on((String)" ").join(cmd));
                            out.flush();
                            break block20;
                        }
                        finally {
                            this.profilerLock.unlock();
                        }
                    }
                    this.setResponseHeader(response);
                    response.setStatus(500);
                    out.println("Unable to acquire lock. Another instance of profiler might be running.");
                    LOG.warn("Unable to acquire lock in {} seconds. Another instance of profiler might be running.", (Object)lockTimeoutSecs);
                }
                catch (InterruptedException e) {
                    LOG.warn("Interrupted while acquiring profile lock.", (Throwable)e);
                    response.setStatus(500);
                }
            } else {
                this.setResponseHeader(response);
                response.setStatus(500);
                out.println("Another instance of profiler is already running.");
            }
        }
        out.close();
    }

    private Integer getInteger(HttpServletRequest req, String param, Integer defaultValue) {
        String value = req.getParameter(param);
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private Long getLong(HttpServletRequest req, String param) {
        String value = req.getParameter(param);
        if (value != null) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private Double getMinWidth(HttpServletRequest req) {
        String value = req.getParameter("minwidth");
        if (value != null) {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private Event getEvent(HttpServletRequest req) {
        String eventArg = req.getParameter("event");
        if (eventArg != null) {
            Event event = Event.fromInternalName(eventArg);
            return event == null ? Event.CPU : event;
        }
        return Event.CPU;
    }

    private Output getOutput(HttpServletRequest req) {
        String outputArg = req.getParameter("output");
        if (outputArg != null) {
            try {
                return Output.valueOf(outputArg.trim().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Output format value is invalid, returning with default SVG");
                return Output.SVG;
            }
        }
        return Output.SVG;
    }

    private void setResponseHeader(HttpServletResponse response) {
        response.setHeader(ACCESS_CONTROL_ALLOW_METHODS, ALLOWED_METHODS);
        response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        response.setContentType(CONTENT_TYPE_TEXT);
    }

    public static String getAsyncProfilerHome() {
        String asyncProfilerHome = System.getenv(ASYNC_PROFILER_HOME_ENV);
        if (asyncProfilerHome == null || asyncProfilerHome.trim().isEmpty()) {
            asyncProfilerHome = System.getProperty(ASYNC_PROFILER_HOME_SYSTEM_PROPERTY);
        }
        return asyncProfilerHome;
    }

    static enum Output {
        SUMMARY,
        TRACES,
        FLAT,
        COLLAPSED,
        SVG,
        TREE,
        JFR;

    }

    static enum Event {
        CPU("cpu"),
        ALLOC("alloc"),
        LOCK("lock"),
        PAGE_FAULTS("page-faults"),
        CONTEXT_SWITCHES("context-switches"),
        CYCLES("cycles"),
        INSTRUCTIONS("instructions"),
        CACHE_REFERENCES("cache-references"),
        CACHE_MISSES("cache-misses"),
        BRANCHES("branches"),
        BRANCH_MISSES("branch-misses"),
        BUS_CYCLES("bus-cycles"),
        L1_DCACHE_LOAD_MISSES("L1-dcache-load-misses"),
        LLC_LOAD_MISSES("LLC-load-misses"),
        DTLB_LOAD_MISSES("dTLB-load-misses"),
        MEM_BREAKPOINT("mem:breakpoint"),
        TRACE_TRACEPOINT("trace:tracepoint");

        private final String internalName;

        private Event(String internalName) {
            this.internalName = internalName;
        }

        public String getInternalName() {
            return this.internalName;
        }

        public static Event fromInternalName(String name) {
            for (Event event : Event.values()) {
                if (!event.getInternalName().equalsIgnoreCase(name)) continue;
                return event;
            }
            return null;
        }
    }
}

