/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.util.ResourceCalculatorProcessTree;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.util.TezMxBeanResourceCalculator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestTezMxBeanResourceCalculator {
    private ResourceCalculatorProcessTree resourceCalculator;

    @Before
    public void setup() throws Exception {
        TezConfiguration conf = new TezConfiguration();
        conf.set("tez.task.resource.calculator.process-tree.class", TezMxBeanResourceCalculator.class.getName());
        Class clazz = conf.getClass("tez.task.resource.calculator.process-tree.class", null, ResourceCalculatorProcessTree.class);
        this.resourceCalculator = ResourceCalculatorProcessTree.getResourceCalculatorProcessTree((String)"", (Class)clazz, (Configuration)conf);
    }

    @After
    public void teardown() {
        this.resourceCalculator = null;
    }

    @Test(timeout=5000L)
    public void testResourceCalculator() {
        Assert.assertTrue((boolean)(this.resourceCalculator instanceof TezMxBeanResourceCalculator));
        Assert.assertTrue((this.resourceCalculator.getCumulativeCpuTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.resourceCalculator.getVirtualMemorySize() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.resourceCalculator.getRssMemorySize() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.resourceCalculator.getProcessTreeDump().equals(""));
        Assert.assertTrue((boolean)this.resourceCalculator.checkPidPgrpidForMatch());
    }
}

