/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.records.DAGProtos;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class TestTezUtils {
    @Test(timeout=2000L)
    public void testByteStringToAndFromConf() throws IOException {
        Configuration conf = this.getConf();
        Assert.assertEquals((long)conf.size(), (long)6L);
        ByteString bsConf = TezUtils.createByteStringFromConf((Configuration)conf);
        conf.clear();
        Assert.assertEquals((long)conf.size(), (long)0L);
        conf = TezUtils.createConfFromByteString((ByteString)bsConf);
        Assert.assertEquals((long)conf.size(), (long)6L);
        this.checkConf(conf);
    }

    private String constructLargeValue() {
        int largeSizeMinimum = 0x4000000;
        String alphaString = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        int largeSize = (largeSizeMinimum + "ABCDEFGHIJKLMNOPQRSTUVWXYZ".length() - 1) / "ABCDEFGHIJKLMNOPQRSTUVWXYZ".length();
        Assert.assertTrue(((largeSize *= "ABCDEFGHIJKLMNOPQRSTUVWXYZ".length()) >= "ABCDEFGHIJKLMNOPQRSTUVWXYZ".length() ? 1 : 0) != 0);
        StringBuilder sb = new StringBuilder(largeSize);
        while (sb.length() < largeSize) {
            sb.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        }
        String largeValue = sb.toString();
        Assert.assertEquals((long)largeSize, (long)largeValue.length());
        return largeValue;
    }

    private ByteString createByteString(Configuration conf, String largeValue) throws IOException {
        conf.set("testLargeValue", largeValue);
        Assert.assertEquals((long)conf.size(), (long)7L);
        return TezUtils.createByteStringFromConf((Configuration)conf);
    }

    @Test(timeout=20000L)
    public void testByteStringToAndFromLargeConf() throws IOException {
        Configuration conf = this.getConf();
        String largeValue = this.constructLargeValue();
        ByteString bsConf = this.createByteString(conf, largeValue);
        conf.clear();
        Assert.assertEquals((long)conf.size(), (long)0L);
        conf = TezUtils.createConfFromByteString((ByteString)bsConf);
        Assert.assertEquals((long)conf.size(), (long)7L);
        this.checkConf(conf);
        Assert.assertEquals((Object)conf.get("testLargeValue"), (Object)largeValue);
    }

    @Test(timeout=20000L)
    public void testByteStringAddToLargeConf() throws IOException {
        Configuration conf = this.getConf();
        String largeValue = this.constructLargeValue();
        ByteString bsConf = this.createByteString(conf, largeValue);
        conf.clear();
        Assert.assertEquals((long)conf.size(), (long)0L);
        TezUtils.addToConfFromByteString((Configuration)conf, (ByteString)bsConf);
        Assert.assertEquals((long)conf.size(), (long)7L);
        this.checkConf(conf);
        Assert.assertEquals((Object)conf.get("testLargeValue"), (Object)largeValue);
    }

    @Test(timeout=2000L)
    public void testPayloadToAndFromConf() throws IOException {
        Configuration conf = this.getConf();
        Assert.assertEquals((long)conf.size(), (long)6L);
        UserPayload bConf = TezUtils.createUserPayloadFromConf((Configuration)conf);
        conf.clear();
        Assert.assertEquals((long)conf.size(), (long)0L);
        conf = TezUtils.createConfFromUserPayload((UserPayload)bConf);
        Assert.assertEquals((long)conf.size(), (long)6L);
        this.checkConf(conf);
    }

    @Test(timeout=2000L)
    public void testCleanVertexName() {
        String testString = "special characters & spaces and longer than 40 characters";
        Assert.assertTrue((testString.length() > 40 ? 1 : 0) != 0);
        String cleaned = TezUtilsInternal.cleanVertexName((String)testString);
        Assert.assertTrue((cleaned.length() <= 40 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)cleaned.contains("\\s+"));
        Assert.assertTrue((boolean)cleaned.matches("\\w+"));
    }

    @Test(timeout=2000L)
    public void testBitSetToByteArray() {
        BitSet bitSet = this.createBitSet(0);
        byte[] bytes = TezUtilsInternal.toByteArray((BitSet)bitSet);
        Assert.assertEquals((long)bytes.length, (long)((bitSet.length() + 7) / 8));
        bitSet = this.createBitSet(1000);
        bytes = TezUtilsInternal.toByteArray((BitSet)bitSet);
        Assert.assertEquals((long)bytes.length, (long)((bitSet.length() + 7) / 8));
    }

    @Test(timeout=2000L)
    public void testBitSetFromByteArray() {
        BitSet bitSet = this.createBitSet(0);
        byte[] bytes = TezUtilsInternal.toByteArray((BitSet)bitSet);
        Assert.assertEquals((long)TezUtilsInternal.fromByteArray((byte[])bytes).cardinality(), (long)bitSet.cardinality());
        Assert.assertTrue((boolean)TezUtilsInternal.fromByteArray((byte[])bytes).equals(bitSet));
        bitSet = this.createBitSet(1);
        bytes = TezUtilsInternal.toByteArray((BitSet)bitSet);
        Assert.assertEquals((long)TezUtilsInternal.fromByteArray((byte[])bytes).cardinality(), (long)bitSet.cardinality());
        Assert.assertTrue((boolean)TezUtilsInternal.fromByteArray((byte[])bytes).equals(bitSet));
        bitSet = this.createBitSet(1000);
        bytes = TezUtilsInternal.toByteArray((BitSet)bitSet);
        Assert.assertEquals((long)TezUtilsInternal.fromByteArray((byte[])bytes).cardinality(), (long)bitSet.cardinality());
        Assert.assertTrue((boolean)TezUtilsInternal.fromByteArray((byte[])bytes).equals(bitSet));
    }

    @Test(timeout=2000L)
    public void testBitSetConversion() {
        for (int i = 0; i < 16; ++i) {
            BitSet bitSet = this.createBitSetWithSingleEntry(i);
            byte[] bytes = TezUtilsInternal.toByteArray((BitSet)bitSet);
            BitSet deseraialized = TezUtilsInternal.fromByteArray((byte[])bytes);
            Assert.assertEquals((Object)bitSet, (Object)deseraialized);
            Assert.assertEquals((long)bitSet.cardinality(), (long)deseraialized.cardinality());
            Assert.assertEquals((long)1L, (long)deseraialized.cardinality());
        }
    }

    private BitSet createBitSet(int size) {
        BitSet bitSet = new BitSet();
        int bitsToEnable = (int)((double)size * 0.1);
        Random rnd = new Random();
        for (int i = 0; i < bitsToEnable; ++i) {
            bitSet.set(rnd.nextInt(size));
        }
        return bitSet;
    }

    private BitSet createBitSetWithSingleEntry(int bitToSet) {
        BitSet bitSet = new BitSet();
        bitSet.set(bitToSet);
        return bitSet;
    }

    private Configuration getConf() {
        Configuration conf = new Configuration(false);
        conf.set("test1", "value1");
        conf.setBoolean("test2", true);
        conf.setDouble("test3", 1.2345);
        conf.setInt("test4", 34567);
        conf.setLong("test5", 1234567890L);
        conf.setStrings("test6", new String[]{"S1", "S2", "S3"});
        return conf;
    }

    private void checkConf(Configuration conf) {
        Assert.assertEquals((Object)conf.get("test1"), (Object)"value1");
        Assert.assertTrue((boolean)conf.getBoolean("test2", false));
        Assert.assertEquals((double)conf.getDouble("test3", 0.0), (double)1.2345, (double)1.0E-15);
        Assert.assertEquals((long)conf.getInt("test4", 0), (long)34567L);
        Assert.assertEquals((long)conf.getLong("test5", 0L), (long)1234567890L);
        String[] tmp = conf.getStrings("test6");
        Assert.assertEquals((long)tmp.length, (long)3L);
        Assert.assertEquals((Object)tmp[0], (Object)"S1");
        Assert.assertEquals((Object)tmp[1], (Object)"S2");
        Assert.assertEquals((Object)tmp[2], (Object)"S3");
    }

    private void checkJSONConfigObj(JSONObject confObject) throws JSONException {
        Assert.assertNotNull((Object)confObject);
        Assert.assertEquals((Object)"value1", (Object)confObject.getString("test1"));
        Assert.assertEquals((Object)"true", (Object)confObject.getString("test2"));
        Assert.assertEquals((Object)"1.2345", (Object)confObject.getString("test3"));
        Assert.assertEquals((Object)"34567", (Object)confObject.getString("test4"));
        Assert.assertEquals((Object)"1234567890", (Object)confObject.getString("test5"));
        Assert.assertEquals((Object)"S1,S2,S3", (Object)confObject.getString("test6"));
    }

    @Test(timeout=2000L)
    public void testConvertToHistoryText() throws JSONException {
        Configuration conf = this.getConf();
        String confToJson = TezUtils.convertToHistoryText((Configuration)conf);
        JSONObject jsonObject = new JSONObject(confToJson);
        Assert.assertFalse((boolean)jsonObject.has("desc"));
        Assert.assertTrue((boolean)jsonObject.has("config"));
        JSONObject confObject = jsonObject.getJSONObject("config");
        this.checkJSONConfigObj(confObject);
        String desc = "desc123";
        confToJson = TezUtils.convertToHistoryText((String)desc, (Configuration)conf);
        jsonObject = new JSONObject(confToJson);
        Assert.assertTrue((boolean)jsonObject.has("desc"));
        String descFromJson = jsonObject.getString("desc");
        Assert.assertEquals((Object)desc, (Object)descFromJson);
        Assert.assertTrue((boolean)jsonObject.has("config"));
        confObject = jsonObject.getJSONObject("config");
        this.checkJSONConfigObj(confObject);
    }

    @Test(timeout=2000L)
    public void testConvertToHistoryTextWithReplaceVars() throws JSONException {
        Configuration conf = this.getConf();
        conf.set("user", "user1");
        conf.set("location", "/tmp/${user}/");
        String location = "/tmp/user1/";
        Assert.assertEquals((Object)location, (Object)conf.get("location"));
        String confToJson = TezUtils.convertToHistoryText((Configuration)conf);
        JSONObject jsonObject = new JSONObject(confToJson);
        Assert.assertFalse((boolean)jsonObject.has("desc"));
        Assert.assertTrue((boolean)jsonObject.has("config"));
        JSONObject confObject = jsonObject.getJSONObject("config");
        this.checkJSONConfigObj(confObject);
        Assert.assertEquals((Object)"user1", (Object)confObject.getString("user"));
        Assert.assertEquals((Object)location, (Object)confObject.getString("location"));
        String desc = "desc123";
        confToJson = TezUtils.convertToHistoryText((String)desc, (Configuration)conf);
        jsonObject = new JSONObject(confToJson);
        Assert.assertTrue((boolean)jsonObject.has("desc"));
        String descFromJson = jsonObject.getString("desc");
        Assert.assertEquals((Object)desc, (Object)descFromJson);
        Assert.assertTrue((boolean)jsonObject.has("config"));
        confObject = jsonObject.getJSONObject("config");
        this.checkJSONConfigObj(confObject);
        Assert.assertEquals((Object)"user1", (Object)confObject.getString("user"));
        Assert.assertEquals((Object)location, (Object)confObject.getString("location"));
    }

    @Test(timeout=5000L)
    public void testPopulateConfProtoFromEntries() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("nonNullKey", "value");
        map.put("nullKey", null);
        DAGProtos.ConfigurationProto.Builder confBuilder = DAGProtos.ConfigurationProto.newBuilder();
        TezUtils.populateConfProtoFromEntries(map.entrySet(), (DAGProtos.ConfigurationProto.Builder)confBuilder);
        Assert.assertEquals((long)confBuilder.getConfKeyValuesList().size(), (long)1L);
    }
}

