/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.auxservices;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.tez.auxservices.ShuffleHandler;
import org.apache.tez.client.TezClient;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.examples.OrderedWordCount;
import org.apache.tez.test.MiniTezCluster;
import org.apache.tez.test.TestTezJobs;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestShuffleHandlerJobs {
    private static final Logger LOG = LoggerFactory.getLogger(TestShuffleHandlerJobs.class);
    protected static MiniTezCluster tezCluster;
    protected static MiniDFSCluster dfsCluster;
    private static Configuration conf;
    private static FileSystem remoteFs;
    private static int NUM_NMS;
    private static int NUM_DNS;

    @BeforeClass
    public static void setup() throws IOException {
        try {
            conf.setInt("yarn.resourcemanager.am.max-attempts", 1);
            conf.setInt("yarn.nodemanager.container-manager.thread-count", 22);
            dfsCluster = new MiniDFSCluster.Builder(conf).numDataNodes(NUM_DNS).format(true).build();
            remoteFs = dfsCluster.getFileSystem();
        }
        catch (IOException io) {
            throw new RuntimeException("problem starting mini dfs cluster", io);
        }
        if (!new File(MiniTezCluster.APPJAR).exists()) {
            LOG.info("MRAppJar " + MiniTezCluster.APPJAR + " not found. Not running test.");
            return;
        }
        if (tezCluster == null) {
            tezCluster = new MiniTezCluster(TestShuffleHandlerJobs.class.getName(), NUM_NMS, 1, 1);
            Configuration conf = new Configuration();
            conf.set("yarn.nodemanager.aux-services", "tez_shuffle");
            String serviceStr = String.format("yarn.nodemanager.aux-services.%s.class", "tez_shuffle");
            conf.set(serviceStr, ShuffleHandler.class.getName());
            conf.setInt("tez.shuffle.port", 0);
            conf.set("fs.defaultFS", remoteFs.getUri().toString());
            conf.setLong("yarn.nodemanager.delete.debug-delay-sec", 0L);
            tezCluster.init(conf);
            tezCluster.start();
        }
    }

    @AfterClass
    public static void tearDown() {
        if (tezCluster != null) {
            tezCluster.stop();
            tezCluster = null;
        }
        if (dfsCluster != null) {
            dfsCluster.shutdown();
            dfsCluster = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testOrderedWordCount() throws Exception {
        String inputDirStr = "/tmp/owc-input/";
        Path inputDir = new Path(inputDirStr);
        Path stagingDirPath = new Path("/tmp/owc-staging-dir");
        remoteFs.mkdirs(inputDir);
        remoteFs.mkdirs(stagingDirPath);
        TestTezJobs.generateOrderedWordCountInput((Path)inputDir, (FileSystem)remoteFs);
        String outputDirStr = "/tmp/owc-output/";
        Path outputDir = new Path(outputDirStr);
        TezConfiguration tezConf = new TezConfiguration(tezCluster.getConfig());
        tezConf.set("tez.staging-dir", stagingDirPath.toString());
        tezConf.set("tez.am.shuffle.auxiliary-service.id", "tez_shuffle");
        tezConf.setBoolean("tez.am.dag.cleanup.on.completion", true);
        tezConf.setBoolean("tez.am.mode.session", true);
        tezConf.setBoolean("tez.runtime.optimize.local.fetch", false);
        tezConf.setBoolean("tez.am.container.reuse.enabled", false);
        TezClient tezSession = TezClient.create((String)"WordCountTest", (TezConfiguration)tezConf);
        tezSession.start();
        try {
            final OrderedWordCount job = new OrderedWordCount();
            Assert.assertTrue((String)"OrderedWordCount failed", (job.run(tezConf, new String[]{"-counter", inputDirStr, outputDirStr, "10"}, tezSession) == 0 ? 1 : 0) != 0);
            TestTezJobs.verifyOutput((Path)outputDir, (FileSystem)remoteFs);
            tezSession.stop();
            ClientRMService rmService = tezCluster.getResourceManager().getClientRMService();
            boolean isAppComplete = false;
            while (!isAppComplete) {
                GetApplicationReportResponse resp = rmService.getApplicationReport(new GetApplicationReportRequest(){

                    public ApplicationId getApplicationId() {
                        return job.getAppId();
                    }

                    public void setApplicationId(ApplicationId applicationId) {
                    }
                });
                if (resp.getApplicationReport().getYarnApplicationState() == YarnApplicationState.FINISHED) {
                    isAppComplete = true;
                }
                Thread.sleep(100L);
            }
            for (int i = 0; i < NUM_NMS; ++i) {
                String appPath = tezCluster.getTestWorkDir() + "/" + this.getClass().getName() + "-localDir-nm-" + i + "_0/usercache/" + UserGroupInformation.getCurrentUser().getUserName() + "/appcache/" + job.getAppId();
                String dagPathStr = appPath + "/dag_1";
                File fs = new File(dagPathStr);
                Assert.assertFalse((boolean)fs.exists());
                fs = new File(appPath);
                Assert.assertTrue((boolean)fs.exists());
            }
        }
        finally {
            remoteFs.delete(stagingDirPath, true);
        }
    }

    static {
        conf = new Configuration();
        NUM_NMS = 5;
        NUM_DNS = 5;
    }
}

