/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import java.io.File;
import java.util.HashMap;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.tez.common.TezYARNUtils;
import org.apache.tez.dag.api.TezConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class TestTezYARNUtils {
    @Test(timeout=5000L)
    public void testAuxClasspath() {
        Configuration conf = new Configuration(false);
        conf.set("tez.cluster.additional.classpath.prefix", "foobar");
        String classpath = TezYARNUtils.getFrameworkClasspath((Configuration)conf, (boolean)true);
        Assert.assertTrue((boolean)classpath.contains("foobar"));
        Assert.assertTrue((classpath.indexOf("foobar") < classpath.indexOf("tezlib") ? 1 : 0) != 0);
        Assert.assertTrue((classpath.indexOf("foobar") < classpath.indexOf(ApplicationConstants.Environment.PWD.$()) ? 1 : 0) != 0);
    }

    @Test(timeout=20000L)
    public void testUserClasspathFirstFalse() {
        Configuration conf = new Configuration(false);
        conf.setBoolean("tez.user.classpath.first", false);
        conf.set("tez.cluster.additional.classpath.prefix", "foobar");
        String classpath = TezYARNUtils.getFrameworkClasspath((Configuration)conf, (boolean)true);
        Assert.assertTrue((boolean)classpath.contains("foobar"));
        Assert.assertTrue((classpath.indexOf("foobar") > classpath.indexOf("tezlib") ? 1 : 0) != 0);
        Assert.assertTrue((classpath.indexOf("foobar") > classpath.indexOf(ApplicationConstants.Environment.PWD.$()) ? 1 : 0) != 0);
    }

    @Test(timeout=5000L)
    public void testBasicArchiveClasspath() {
        Configuration conf = new Configuration(false);
        String classpath = TezYARNUtils.getFrameworkClasspath((Configuration)conf, (boolean)true);
        Assert.assertTrue((boolean)classpath.contains(ApplicationConstants.Environment.PWD.$()));
        Assert.assertTrue((boolean)classpath.contains(ApplicationConstants.Environment.PWD.$() + File.separator + "*"));
        Assert.assertTrue((boolean)classpath.contains("tezlib" + File.separator + "*"));
        Assert.assertTrue((boolean)classpath.contains("tezlib" + File.separator + "lib" + File.separator + "*"));
        Assert.assertTrue((!classpath.contains(ApplicationConstants.Environment.HADOOP_CONF_DIR.$()) ? 1 : 0) != 0);
        Assert.assertTrue((classpath.indexOf(ApplicationConstants.Environment.PWD.$()) < classpath.indexOf("tezlib") ? 1 : 0) != 0);
    }

    @Test(timeout=5000L)
    public void testNoHadoopConfInClasspath() {
        Configuration conf = new Configuration(false);
        conf.setBoolean("tez.classpath.add-hadoop-conf", true);
        String classpath = TezYARNUtils.getFrameworkClasspath((Configuration)conf, (boolean)true);
        Assert.assertTrue((boolean)classpath.contains(ApplicationConstants.Environment.PWD.$()));
        Assert.assertTrue((boolean)classpath.contains(ApplicationConstants.Environment.PWD.$() + File.separator + "*"));
        Assert.assertTrue((boolean)classpath.contains("tezlib" + File.separator + "*"));
        Assert.assertTrue((boolean)classpath.contains("tezlib" + File.separator + "lib" + File.separator + "*"));
        Assert.assertTrue((boolean)classpath.contains(ApplicationConstants.Environment.HADOOP_CONF_DIR.$()));
        Assert.assertTrue((classpath.indexOf(ApplicationConstants.Environment.PWD.$()) < classpath.indexOf("tezlib") ? 1 : 0) != 0);
        Assert.assertTrue((classpath.indexOf("tezlib") < classpath.indexOf(ApplicationConstants.Environment.HADOOP_CONF_DIR.$()) ? 1 : 0) != 0);
    }

    @Test(timeout=5000L)
    public void testSetupDefaultEnvironment() {
        Configuration conf = new Configuration(false);
        conf.set("tez.am.launch.env", "LD_LIBRARY_PATH=USER_PATH,USER_KEY=USER_VALUE");
        conf.set("tez.am.launch.cluster-default.env", "LD_LIBRARY_PATH=DEFAULT_PATH,DEFAULT_KEY=DEFAULT_VALUE");
        TreeMap environment = new TreeMap();
        TezYARNUtils.setupDefaultEnv(environment, (Configuration)conf, (String)"tez.am.launch.env", (String)"", (String)"tez.am.launch.cluster-default.env", (String)TezConfiguration.TEZ_AM_LAUNCH_CLUSTER_DEFAULT_ENV_DEFAULT, (boolean)false);
        String value1 = (String)environment.get("USER_KEY");
        Assert.assertEquals((String)"User env should merge with default env", (Object)"USER_VALUE", (Object)value1);
        String value2 = (String)environment.get("DEFAULT_KEY");
        Assert.assertEquals((String)"User env should merge with default env", (Object)"DEFAULT_VALUE", (Object)value2);
        String value3 = (String)environment.get("LD_LIBRARY_PATH");
        Assert.assertEquals((String)"User env should append default env", (Object)(ApplicationConstants.Environment.PWD.$() + File.pathSeparator + "USER_PATH" + File.pathSeparator + "DEFAULT_PATH"), (Object)value3);
    }

    @Test(timeout=5000L)
    public void testTezLibUrisClasspath() {
        Configuration conf = new Configuration(false);
        conf.set("tez.lib.uris.classpath", "foobar");
        String classpath = TezYARNUtils.getFrameworkClasspath((Configuration)conf, (boolean)true);
        Assert.assertTrue((boolean)classpath.contains("foobar"));
        Assert.assertTrue((boolean)classpath.contains(ApplicationConstants.Environment.PWD.$()));
        Assert.assertTrue((classpath.indexOf("foobar") > classpath.indexOf(ApplicationConstants.Environment.PWD.$()) ? 1 : 0) != 0);
    }

    @Test
    public void testSetEnvFromInputString() {
        HashMap<String, String> environment = new HashMap<String, String>();
        environment.put("JAVA_HOME", "/path/jdk");
        String goodEnv = "a1=1,b_2=2,_c=3,d=4,e=,f_win=%JAVA_HOME%,g_nix=$JAVA_HOME";
        TezYARNUtils.appendToEnvFromInputString(environment, (String)goodEnv, (String)File.pathSeparator);
        Assert.assertEquals((Object)"1", environment.get("a1"));
        Assert.assertEquals((Object)"2", environment.get("b_2"));
        Assert.assertEquals((Object)"3", environment.get("_c"));
        Assert.assertEquals((Object)"4", environment.get("d"));
        Assert.assertEquals((Object)"", environment.get("e"));
        if (Shell.WINDOWS) {
            Assert.assertEquals((Object)"$JAVA_HOME", environment.get("g_nix"));
            Assert.assertEquals((Object)"/path/jdk", environment.get("f_win"));
        } else {
            Assert.assertEquals((Object)"/path/jdk", environment.get("g_nix"));
            Assert.assertEquals((Object)"%JAVA_HOME%", environment.get("f_win"));
        }
        String badEnv = "0=,1,,2=a=b,3=a=,4==,5==a,==,c-3=3,=";
        environment.clear();
        TezYARNUtils.appendToEnvFromInputString(environment, (String)badEnv, (String)File.pathSeparator);
        Assert.assertEquals((long)environment.size(), (long)0L);
        environment.clear();
        TezYARNUtils.appendToEnvFromInputString(environment, (String)"b1,e1==,e2=a1=a2,b2", (String)File.pathSeparator);
        Assert.assertEquals((Object)"=", environment.get("e1"));
        Assert.assertEquals((Object)"a1=a2", environment.get("e2"));
    }
}

