/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.serviceplugins.api;

import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.common.Preconditions;
import org.apache.tez.serviceplugins.api.ContainerLauncherDescriptor;
import org.apache.tez.serviceplugins.api.TaskCommunicatorDescriptor;
import org.apache.tez.serviceplugins.api.TaskSchedulerDescriptor;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class ServicePluginsDescriptor {
    private final boolean enableContainers;
    private final boolean enableUber;
    private TaskSchedulerDescriptor[] taskSchedulerDescriptors;
    private ContainerLauncherDescriptor[] containerLauncherDescriptors;
    private TaskCommunicatorDescriptor[] taskCommunicatorDescriptors;

    private ServicePluginsDescriptor(boolean enableContainers, boolean enableUber, TaskSchedulerDescriptor[] taskSchedulerDescriptors, ContainerLauncherDescriptor[] containerLauncherDescriptors, TaskCommunicatorDescriptor[] taskCommunicatorDescriptors) {
        this.enableContainers = enableContainers;
        this.enableUber = enableUber;
        Preconditions.checkArgument(taskSchedulerDescriptors == null || taskSchedulerDescriptors.length > 0, "TaskSchedulerDescriptors should either not be specified or at least 1 should be provided");
        this.taskSchedulerDescriptors = taskSchedulerDescriptors;
        Preconditions.checkArgument(containerLauncherDescriptors == null || containerLauncherDescriptors.length > 0, "ContainerLauncherDescriptor should either not be specified or at least 1 should be provided");
        this.containerLauncherDescriptors = containerLauncherDescriptors;
        Preconditions.checkArgument(taskCommunicatorDescriptors == null || taskCommunicatorDescriptors.length > 0, "TaskCommunicatorDescriptors should either not be specified or at least 1 should be provided");
        this.taskCommunicatorDescriptors = taskCommunicatorDescriptors;
    }

    public static ServicePluginsDescriptor create(TaskSchedulerDescriptor[] taskSchedulerDescriptor, ContainerLauncherDescriptor[] containerLauncherDescriptors, TaskCommunicatorDescriptor[] taskCommunicatorDescriptors) {
        return new ServicePluginsDescriptor(true, false, taskSchedulerDescriptor, containerLauncherDescriptors, taskCommunicatorDescriptors);
    }

    public static ServicePluginsDescriptor create(boolean enableUber, TaskSchedulerDescriptor[] taskSchedulerDescriptor, ContainerLauncherDescriptor[] containerLauncherDescriptors, TaskCommunicatorDescriptor[] taskCommunicatorDescriptors) {
        return new ServicePluginsDescriptor(true, enableUber, taskSchedulerDescriptor, containerLauncherDescriptors, taskCommunicatorDescriptors);
    }

    public static ServicePluginsDescriptor create(boolean enableContainers, boolean enableUber, TaskSchedulerDescriptor[] taskSchedulerDescriptor, ContainerLauncherDescriptor[] containerLauncherDescriptors, TaskCommunicatorDescriptor[] taskCommunicatorDescriptors) {
        return new ServicePluginsDescriptor(enableContainers, enableUber, taskSchedulerDescriptor, containerLauncherDescriptors, taskCommunicatorDescriptors);
    }

    public static ServicePluginsDescriptor create(boolean enableUber) {
        return new ServicePluginsDescriptor(true, enableUber, null, null, null);
    }

    @InterfaceAudience.Private
    public boolean areContainersEnabled() {
        return this.enableContainers;
    }

    @InterfaceAudience.Private
    public boolean isUberEnabled() {
        return this.enableUber;
    }

    @InterfaceAudience.Private
    public TaskSchedulerDescriptor[] getTaskSchedulerDescriptors() {
        return this.taskSchedulerDescriptors;
    }

    @InterfaceAudience.Private
    public ContainerLauncherDescriptor[] getContainerLauncherDescriptors() {
        return this.containerLauncherDescriptors;
    }

    @InterfaceAudience.Private
    public TaskCommunicatorDescriptor[] getTaskCommunicatorDescriptors() {
        return this.taskCommunicatorDescriptors;
    }

    public String toString() {
        return "ServicePluginsDescriptor{enableContainers=" + this.enableContainers + ", enableUber=" + this.enableUber + ", taskSchedulerDescriptors=" + Arrays.toString(this.taskSchedulerDescriptors) + ", containerLauncherDescriptors=" + Arrays.toString(this.containerLauncherDescriptors) + ", taskCommunicatorDescriptors=" + Arrays.toString(this.taskCommunicatorDescriptors) + "}";
    }
}

