/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.UserPayload;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestEntityDescriptor {
    public void verifyResults(InputDescriptor entityDescriptor, InputDescriptor deserialized, UserPayload payload, String confVal) throws IOException {
        Assert.assertEquals((Object)entityDescriptor.getClassName(), (Object)deserialized.getClassName());
        Assert.assertNull((Object)deserialized.getHistoryText());
        Assert.assertArrayEquals((byte[])payload.deepCopyAsArray(), (byte[])deserialized.getUserPayload().deepCopyAsArray());
        Configuration deserializedConf = TezUtils.createConfFromUserPayload((UserPayload)deserialized.getUserPayload());
        Assert.assertEquals((Object)confVal, (Object)deserializedConf.get("testKey"));
    }

    public void testSingularWrite(InputDescriptor entityDescriptor, InputDescriptor deserialized, UserPayload payload, String confVal) throws IOException {
        DataOutputBuffer out = new DataOutputBuffer();
        entityDescriptor.write((DataOutput)out);
        out.close();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(out.getData().length);
        bos.write(out.getData());
        ((InputDescriptor)Mockito.verify((Object)entityDescriptor)).writeSingular((DataOutput)Mockito.eq((Object)out), (ByteBuffer)Mockito.any());
        deserialized.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bos.toByteArray())));
        this.verifyResults(entityDescriptor, deserialized, payload, confVal);
    }

    public void testSegmentedWrite(InputDescriptor entityDescriptor, InputDescriptor deserialized, UserPayload payload, String confVal) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        entityDescriptor.write((DataOutput)out);
        out.close();
        ((InputDescriptor)Mockito.verify((Object)entityDescriptor)).writeSegmented((DataOutput)Mockito.eq((Object)out), (ByteBuffer)Mockito.any());
        deserialized.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bos.toByteArray())));
        this.verifyResults(entityDescriptor, deserialized, payload, confVal);
    }

    @Test(timeout=3000L)
    public void testEntityDescriptorHadoopSerialization() throws IOException {
        Configuration conf = new Configuration(true);
        String confVal = RandomStringUtils.random((int)10000, (boolean)true, (boolean)true);
        conf.set("testKey", confVal);
        UserPayload payload = TezUtils.createUserPayloadFromConf((Configuration)conf);
        InputDescriptor deserialized = InputDescriptor.create((String)"dummy");
        InputDescriptor entityDescriptor = (InputDescriptor)((InputDescriptor)InputDescriptor.create((String)"inputClazz").setUserPayload(payload)).setHistoryText("Bar123");
        InputDescriptor entityDescriptorLivingInFear = (InputDescriptor)Mockito.spy((Object)entityDescriptor);
        this.testSingularWrite(entityDescriptorLivingInFear, deserialized, payload, confVal);
        payload = UserPayload.create((ByteBuffer)payload.getPayload());
        entityDescriptor = (InputDescriptor)((InputDescriptor)InputDescriptor.create((String)"inputClazz").setUserPayload(payload)).setHistoryText("Bar123");
        entityDescriptorLivingInFear = (InputDescriptor)Mockito.spy((Object)entityDescriptor);
        this.testSegmentedWrite(entityDescriptorLivingInFear, deserialized, payload, confVal);
    }
}

