/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.hadoop.shim;

import org.apache.hadoop.conf.Configuration;
import org.apache.tez.hadoop.shim.DefaultHadoopShim;
import org.apache.tez.hadoop.shim.HadoopShim;
import org.apache.tez.hadoop.shim.HadoopShim25_26_27Provider;
import org.apache.tez.hadoop.shim.HadoopShim27;
import org.apache.tez.hadoop.shim.HadoopShimsLoader;
import org.junit.Assert;
import org.junit.Test;

public class TestHadoop25_26_27ShimProvider {
    @Test
    public void testShimProvider() {
        HadoopShim25_26_27Provider provider = new HadoopShim25_26_27Provider();
        Assert.assertNull((Object)provider.createHadoopShim("foo", 2, 2));
        Assert.assertNull((Object)provider.createHadoopShim("foo", 2, 1));
        Assert.assertNull((Object)provider.createHadoopShim("foo", 2, 3));
        Assert.assertNull((Object)provider.createHadoopShim("foo", 2, 8));
        Assert.assertNull((Object)provider.createHadoopShim("foo", 3, 3));
        Assert.assertNotNull((Object)provider.createHadoopShim("foo", 2, 5));
        Assert.assertNotNull((Object)provider.createHadoopShim("foo", 2, 6));
        Assert.assertNotNull((Object)provider.createHadoopShim("foo", 2, 7));
        Assert.assertEquals(HadoopShim27.class, provider.createHadoopShim("foo", 2, 7).getClass());
    }

    @Test
    public void testLoaderOverride() {
        Configuration conf = new Configuration(false);
        conf.set("tez.hadoop.shim.provider.class", HadoopShim25_26_27Provider.class.getName());
        conf.set("tez.hadoop.shim.hadoop.version.override", "2.7.0");
        HadoopShimsLoader loader = new HadoopShimsLoader(conf, true);
        HadoopShim shim = loader.getHadoopShim();
        Assert.assertNotNull((Object)shim);
        Assert.assertEquals(HadoopShim27.class, shim.getClass());
    }

    @Test
    public void testInvalidVersion() {
        Configuration conf = new Configuration(false);
        conf.set("tez.hadoop.shim.hadoop.version.override", "2.9.0");
        HadoopShimsLoader loader = new HadoopShimsLoader(conf, true);
        HadoopShim shim = loader.getHadoopShim();
        Assert.assertNotNull((Object)shim);
        Assert.assertEquals(DefaultHadoopShim.class, shim.getClass());
    }

    @Test
    public void testLoaderOverrideInvalidVersion() {
        Configuration conf = new Configuration(false);
        conf.set("tez.hadoop.shim.provider.class", HadoopShim25_26_27Provider.class.getName());
        conf.set("tez.hadoop.shim.hadoop.version.override", "2.1.0");
        HadoopShimsLoader loader = new HadoopShimsLoader(conf, true);
        HadoopShim shim = loader.getHadoopShim();
        Assert.assertNotNull((Object)shim);
        Assert.assertEquals(DefaultHadoopShim.class, shim.getClass());
    }
}

