/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.conftool;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.apache.tez.conftool.Security;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

final class ConfTool {
    public static final String KEEP_ALIVE = "tez.runtime.shuffle.keep-alive.enabled";
    public static final String SSL = "tez.runtime.shuffle.ssl.enable";
    public static final String HEADERS = "tez.ui.tomcat.response.headers.file";
    private static final Logger LOG = Logger.getLogger(ConfTool.class);
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String PROPERTY = "property";
    private static final String CONFIGURATION = "configuration";
    private static final String TRUE = "true";
    private static final String EMPTY = "";

    private ConfTool() {
    }

    static void setEncryption(String pathToTezSite, Security security) throws TransformerException, IOException, SAXException, ParserConfigurationException {
        Document doc = ConfTool.readDocument(pathToTezSite);
        LOG.info((Object)String.format("Reading tez-site.xml from path : %s", pathToTezSite));
        switch (security) {
            case CUSTOM: {
                return;
            }
            case MAPRSASL: {
                ConfTool.set(doc, SSL, TRUE);
                ConfTool.set(doc, KEEP_ALIVE, TRUE);
                break;
            }
            case NONE: {
                ConfTool.removeProperty(doc, SSL);
                ConfTool.removeProperty(doc, KEEP_ALIVE);
                break;
            }
            default: {
                return;
            }
        }
        ConfTool.saveToFile(doc, pathToTezSite);
    }

    static void setHeaders(String pathToTezSite, Security security, String headers) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        Document doc = ConfTool.readDocument(pathToTezSite);
        LOG.info((Object)String.format("Reading tez-site.xml from path : %s", pathToTezSite));
        switch (security) {
            case CUSTOM: {
                return;
            }
            case MAPRSASL: {
                ConfTool.set(doc, HEADERS, headers);
                break;
            }
            case NONE: {
                ConfTool.removeProperty(doc, HEADERS);
                break;
            }
            default: {
                return;
            }
        }
        ConfTool.saveToFile(doc, pathToTezSite);
    }

    @VisibleForTesting
    static Document readDocument(String pathToTezSite) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setIgnoringComments(true);
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        return docBuilder.parse(pathToTezSite);
    }

    @VisibleForTesting
    static void set(Document doc, String property, String value) {
        if (ConfTool.propertyExists(doc, property)) {
            LOG.info((Object)String.format("Property %s exists in xml file", property));
            ConfTool.setProperty(doc, property, value);
        } else {
            LOG.info((Object)String.format("Property %s does not exist in xml file", property));
            ConfTool.addProperty(doc, property, value);
        }
    }

    @VisibleForTesting
    static String getProperty(Document doc, String property) {
        Node configuration = ConfTool.getConfigurationNode(doc);
        NodeList properties = configuration.getChildNodes();
        int length = properties.getLength();
        for (int i = 0; i <= length - 1; ++i) {
            Node node = properties.item(i);
            NodeList nameValueDesc = node.getChildNodes();
            int childLength = nameValueDesc.getLength();
            for (int j = 0; j <= childLength - 1; ++j) {
                Node childNode = nameValueDesc.item(j);
                if (!NAME.equals(childNode.getNodeName()) || !property.equals(childNode.getTextContent())) continue;
                return ConfTool.readValue(nameValueDesc);
            }
        }
        return EMPTY;
    }

    @VisibleForTesting
    static boolean propertyExists(Document doc, String property) {
        LOG.info((Object)String.format("Checking that property exists in tez-site.xml : %s", property));
        Node configuration = ConfTool.getConfigurationNode(doc);
        NodeList properties = configuration.getChildNodes();
        int length = properties.getLength();
        for (int i = 0; i <= length - 1; ++i) {
            Node node = properties.item(i);
            NodeList nameValueDesc = node.getChildNodes();
            int childLength = nameValueDesc.getLength();
            for (int j = 0; j <= childLength - 1; ++j) {
                Node childNode = nameValueDesc.item(j);
                if (!NAME.equals(childNode.getNodeName()) || !property.equals(childNode.getTextContent())) continue;
                return true;
            }
        }
        return false;
    }

    private static Node getConfigurationNode(Document doc) {
        NodeList nodes = doc.getChildNodes();
        int length = nodes.getLength();
        for (int i = 0; i <= length - 1; ++i) {
            Node node = nodes.item(i);
            if (!CONFIGURATION.equals(node.getNodeName())) continue;
            return node;
        }
        throw new IllegalArgumentException("No <configuration> tag");
    }

    private static void addProperty(Document doc, String property, String value) {
        LOG.info((Object)String.format("Adding property to tez-site.xml: %s = %s", property, value));
        Element element = doc.createElement(PROPERTY);
        ConfTool.addName(doc, element, property);
        ConfTool.addValue(doc, element, value);
        ConfTool.getConfigurationNode(doc).appendChild(element);
    }

    static void removeProperty(Document doc, String property) {
        LOG.info((Object)String.format("Removing property from tez-site.xml: %s", property));
        Node configuration = ConfTool.getConfigurationNode(doc);
        NodeList childNodes = configuration.getChildNodes();
        int length = childNodes.getLength();
        for (int i = 0; i <= length - 1; ++i) {
            Node node = childNodes.item(i);
            NodeList nameValueDesc = node.getChildNodes();
            int childLength = nameValueDesc.getLength();
            for (int j = 0; j <= childLength - 1; ++j) {
                Node childNode = nameValueDesc.item(j);
                if (!NAME.equals(childNode.getNodeName()) || !property.equals(childNode.getTextContent())) continue;
                if (node.getNextSibling() != null && node.getNextSibling().getNodeType() == 3 && node.getNextSibling().getNodeValue().trim().isEmpty()) {
                    configuration.removeChild(node.getNextSibling());
                }
                configuration.removeChild(node);
                return;
            }
        }
    }

    private static void setProperty(Document doc, String property, String value) {
        LOG.info((Object)String.format("Setting value to existing property in xml file: %s = %s", property, value));
        Node configuration = ConfTool.getConfigurationNode(doc);
        NodeList properties = configuration.getChildNodes();
        int length = properties.getLength();
        for (int i = 0; i <= length - 1; ++i) {
            Node node = properties.item(i);
            NodeList nameValueDesc = node.getChildNodes();
            int childLength = nameValueDesc.getLength();
            for (int j = 0; j <= childLength - 1; ++j) {
                Node childNode = nameValueDesc.item(j);
                if (!NAME.equals(childNode.getNodeName()) || !property.equals(childNode.getTextContent())) continue;
                ConfTool.writeValue(nameValueDesc, value);
            }
        }
    }

    private static void addName(Document doc, Node node, String property) {
        Element element = doc.createElement(NAME);
        element.appendChild(doc.createTextNode(property));
        node.appendChild(element);
    }

    private static void addValue(Document doc, Node property, String value) {
        Element name = doc.createElement(VALUE);
        name.appendChild(doc.createTextNode(value));
        property.appendChild(name);
    }

    private static String readValue(NodeList nameValueDesc) {
        int childLength = nameValueDesc.getLength();
        for (int j = 0; j <= childLength - 1; ++j) {
            Node childNode = nameValueDesc.item(j);
            if (!VALUE.equals(childNode.getNodeName())) continue;
            return childNode.getTextContent();
        }
        return EMPTY;
    }

    private static void writeValue(NodeList nameValueDesc, String value) {
        int childLength = nameValueDesc.getLength();
        for (int j = 0; j <= childLength - 1; ++j) {
            Node childNode = nameValueDesc.item(j);
            if (!VALUE.equals(childNode.getNodeName())) continue;
            childNode.setTextContent(value);
        }
    }

    private static void saveToFile(Document doc, String filepath) throws TransformerException {
        ConfTool.removeEmptyText(doc.getDocumentElement());
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(new File(filepath));
        transformer.transform(source, result);
    }

    private static void removeEmptyText(Node node) {
        Node child = node.getFirstChild();
        while (child != null) {
            Node sibling = child.getNextSibling();
            if (child.getNodeType() == 3) {
                if (child.getTextContent().trim().isEmpty()) {
                    node.removeChild(child);
                }
            } else {
                ConfTool.removeEmptyText(child);
            }
            child = sibling;
        }
    }
}

