/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import com.google.common.io.Files;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.spark.TestUtils$;
import org.apache.spark.api.python.PythonUtils$;
import org.apache.spark.deploy.yarn.BaseYarnClusterSuite;
import org.apache.spark.deploy.yarn.ExecutorEnvTestApp$;
import org.apache.spark.deploy.yarn.SparkContextTimeoutApp$;
import org.apache.spark.deploy.yarn.YarnAddJarTest$;
import org.apache.spark.deploy.yarn.YarnClasspathTest$;
import org.apache.spark.deploy.yarn.YarnClusterDriver$;
import org.apache.spark.deploy.yarn.YarnClusterDriverUseSparkHadoopUtilConf$;
import org.apache.spark.deploy.yarn.YarnClusterDriverWithFailure$;
import org.apache.spark.deploy.yarn.YarnLauncherTestApp$;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.launcher.SparkLauncher;
import org.apache.spark.tags.ExtendedYarnTest;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.exceptions.TestFailedException;
import org.scalatest.matchers.should.Matchers$;
import org.scalatest.time.Span$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ExtendedYarnTest
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001B\f\u0019\u0001\rBQ\u0001\u000b\u0001\u0005\u0002%Bqa\u000b\u0001C\u0002\u0013%A\u0006\u0003\u0004;\u0001\u0001\u0006I!\f\u0005\u0006w\u0001!\t\u0005\u0010\u0005\b\r\u0002\u0011\r\u0011\"\u0003-\u0011\u00199\u0005\u0001)A\u0005[!9\u0001\n\u0001b\u0001\n\u0013a\u0003BB%\u0001A\u0003%Q\u0006C\u0003K\u0001\u0011%1\nC\u0004Z\u0001E\u0005I\u0011\u0002.\t\u000b\u0015\u0004A\u0011\u00024\t\u000b=\u0004A\u0011\u00029\t\u000fa\u0004\u0011\u0013!C\u00055\"9\u0011\u0010AI\u0001\n\u0013Q\b\"\u0002?\u0001\t\u0013i\b\u0002CA\u0003\u0001E\u0005I\u0011\u0002.\t\u0011\u0005\u001d\u0001!%A\u0005\niCq!!\u0003\u0001\t\u0013\tY\u0001C\u0004\u0002\u0010\u0001!I!!\u0005\t\u000f\u0005U\u0001\u0001\"\u0001\u0002\u0018!9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0002\u0002CA\u001c\u0001E\u0005I\u0011\u0001>\u0003!e\u000b'O\\\"mkN$XM]*vSR,'BA\r\u001b\u0003\u0011I\u0018M\u001d8\u000b\u0005ma\u0012A\u00023fa2|\u0017P\u0003\u0002\u001e=\u0005)1\u000f]1sW*\u0011q\u0004I\u0001\u0007CB\f7\r[3\u000b\u0003\u0005\n1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0013\u0011\u0005\u00152S\"\u0001\r\n\u0005\u001dB\"\u0001\u0006\"bg\u0016L\u0016M\u001d8DYV\u001cH/\u001a:Tk&$X-\u0001\u0004=S:LGO\u0010\u000b\u0002UA\u0011Q\u0005A\u0001\u0015af$\bn\u001c8Fq\u0016\u001cW\u000f^1cY\u0016\u0004\u0016\r\u001e5\u0016\u00035\u0002\"AL\u001c\u000f\u0005=*\u0004C\u0001\u00194\u001b\u0005\t$B\u0001\u001a#\u0003\u0019a$o\\8u})\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\u00051\u0001K]3eK\u001aL!\u0001O\u001d\u0003\rM#(/\u001b8h\u0015\t14'A\u000bqsRDwN\\#yK\u000e,H/\u00192mKB\u000bG\u000f\u001b\u0011\u0002\u001b9,w/W1s]\u000e{gNZ5h)\u0005i\u0004C\u0001 E\u001b\u0005y$B\u0001!B\u0003\u0011\u0019wN\u001c4\u000b\u0005e\u0011%BA\"\u001f\u0003\u0019A\u0017\rZ8pa&\u0011Qi\u0010\u0002\u00123\u0006\u0014hnQ8oM&<WO]1uS>t\u0017a\u0003+F'R{\u0006+\u0017$J\u0019\u0016\u000bA\u0002V#T)~\u0003\u0016LR%M\u000b\u0002\nQ\u0002V#T)~\u0003\u0016,T(E+2+\u0015A\u0004+F'R{\u0006+W'P\tVcU\tI\u0001\u0011i\u0016\u001cHOQ1tS\u000eL\u0016M\u001d8BaB$2\u0001\u0014)V!\tie*D\u00014\u0013\ty5G\u0001\u0003V]&$\b\"B)\n\u0001\u0004\u0011\u0016AC2mS\u0016tG/T8eKB\u0011QjU\u0005\u0003)N\u0012qAQ8pY\u0016\fg\u000eC\u0004A\u0013A\u0005\t\u0019\u0001,\u0011\t9:V&L\u0005\u00031f\u00121!T1q\u0003i!Xm\u001d;CCNL7-W1s]\u0006\u0003\b\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0005Y&F\u0001,]W\u0005i\u0006C\u00010d\u001b\u0005y&B\u00011b\u0003%)hn\u00195fG.,GM\u0003\u0002cg\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005\u0011|&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\t3M]3bi\u0016T\u0015M],ji\"|%/[4j]\u0006d'+Z:pkJ\u001cWMR5mKR\tq\r\u0005\u0002i[6\t\u0011N\u0003\u0002kW\u0006\u0019a.\u001a;\u000b\u00031\fAA[1wC&\u0011a.\u001b\u0002\u0004+Jc\u0015A\u0004;fgR<\u0016\u000e\u001e5BI\u0012T\u0015M\u001d\u000b\u0006\u0019F\u0014HO\u001e\u0005\u0006#2\u0001\rA\u0015\u0005\u0006g2\u0001\r!L\u0001\bU\u0006\u0014\b+\u0019;i\u0011\u001d)H\u0002%AA\u0002Y\u000b\u0011\"\u001a=ue\u0006\u001cuN\u001c4\t\u000f]d\u0001\u0013!a\u0001%\u0006)R\r\u001f9fGR,\u00050Z2vi>\u0014h)Y5mkJ,\u0017\u0001\u0007;fgR<\u0016\u000e\u001e5BI\u0012T\u0015M\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005AB/Z:u/&$\b.\u00113e\u0015\u0006\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0003mT#A\u0015/\u0002\u0017Q,7\u000f\u001e)z'B\f'o\u001b\u000b\u0006\u0019z|\u0018\u0011\u0001\u0005\u0006#>\u0001\rA\u0015\u0005\bk>\u0001\n\u00111\u0001W\u0011!\t\u0019a\u0004I\u0001\u0002\u00041\u0016\u0001C3yiJ\fWI\u001c<\u0002+Q,7\u000f\u001e)z'B\f'o\u001b\u0013eK\u001a\fW\u000f\u001c;%e\u0005)B/Z:u!f\u001c\u0006/\u0019:lI\u0011,g-Y;mi\u0012\u001a\u0014!\u0006;fgR,6/Z\"mCN\u001c\b+\u0019;i\r&\u00148\u000f\u001e\u000b\u0004\u0019\u00065\u0001\"B)\u0013\u0001\u0004\u0011\u0016a\u0004;fgR,\u00050Z2vi>\u0014XI\u001c<\u0015\u00071\u000b\u0019\u0002C\u0003R'\u0001\u0007!+\u0001\u000ede\u0016\fG/Z#naRL\u0018J^=TKR$\u0018N\\4t\r&dW-\u0006\u0002\u0002\u001aA!\u00111DA\u0011\u001b\t\tiBC\u0002\u0002 -\f!![8\n\t\u0005\r\u0012Q\u0004\u0002\u0005\r&dW-A\u000euKN$\u0018J^=TKR$\u0018N\\4t\t&\u001cHO]5ckRLwN\u001c\u000b\n\u0019\u0006%\u00121FA\u0018\u0003gAQ!U\u000bA\u0002ICa!!\f\u0016\u0001\u0004i\u0013aD5wsN+G\u000f^5oON\u0004\u0016\r\u001e5\t\r\u0005ER\u00031\u0001.\u0003\u0005*\u0007\u0010]3di\u0016$\u0017J^=TKR$\u0018N\\4t!J,g-\u001b=P]\u0012\u0013\u0018N^3s\u0011!\t)$\u0006I\u0001\u0002\u0004\u0011\u0016a\u00039sK\u001aL\u00070T1uG\"\fQ\u0005^3ti&3\u0018pU3ui&twm\u001d#jgR\u0014\u0018NY;uS>tG\u0005Z3gCVdG\u000f\n\u001b)\u0007\u0001\tY\u0004\u0005\u0003\u0002>\u0005\rSBAA \u0015\r\t\t\u0005H\u0001\u0005i\u0006<7/\u0003\u0003\u0002F\u0005}\"\u0001E#yi\u0016tG-\u001a3ZCJtG+Z:u\u0001")
public class YarnClusterSuite
extends BaseYarnClusterSuite {
    private final String pythonExecutablePath;
    private final String TEST_PYFILE;
    private final String TEST_PYMODULE;

    private String pythonExecutablePath() {
        return this.pythonExecutablePath;
    }

    @Override
    public YarnConfiguration newYarnConfig() {
        return new YarnConfiguration();
    }

    private String TEST_PYFILE() {
        return this.TEST_PYFILE;
    }

    private String TEST_PYMODULE() {
        return this.TEST_PYMODULE;
    }

    private void testBasicYarnApp(boolean clientMode, Map<String, String> conf) {
        File result = File.createTempFile("result", null, this.tempDir());
        boolean x$1 = clientMode;
        String x$2 = this.mainClassName(YarnClusterDriver$.MODULE$.getClass());
        Seq x$3 = (Seq)new .colon.colon((Object)result.getAbsolutePath(), (List)Nil$.MODULE$);
        Map<String, String> x$4 = conf;
        Seq<Tuple2<String, String>> x$5 = this.runSpark$default$4();
        Seq<String> x$6 = this.runSpark$default$5();
        Seq<String> x$7 = this.runSpark$default$6();
        Map<String, String> x$8 = this.runSpark$default$8();
        Option<File> x$9 = this.runSpark$default$9();
        SparkAppHandle.State finalState = this.runSpark(x$1, x$2, (Seq<String>)x$3, x$5, x$6, x$7, x$4, x$8, x$9);
        this.checkResult(finalState, result, this.checkResult$default$3(), this.checkResult$default$4());
    }

    private Map<String, String> testBasicYarnApp$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    private URL createJarWithOriginalResourceFile() {
        return TestUtils$.MODULE$.createJarWithFiles((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test.resource"), (Object)"ORIGINAL")})), this.tempDir());
    }

    private void testWithAddJar(boolean clientMode, String jarPath, Map<String, String> extraConf, boolean expectExecutorFailure) {
        File driverResult = File.createTempFile("driver", null, this.tempDir());
        File executorResult = File.createTempFile("executor", null, this.tempDir());
        boolean x$1 = clientMode;
        String x$2 = this.mainClassName(YarnClasspathTest$.MODULE$.getClass());
        Seq x$3 = (Seq)new .colon.colon((Object)driverResult.getAbsolutePath(), (List)new .colon.colon((Object)executorResult.getAbsolutePath(), (List)Nil$.MODULE$));
        Seq x$4 = (Seq)new .colon.colon((Object)jarPath, (List)Nil$.MODULE$);
        Map<String, String> x$5 = extraConf;
        Seq<Tuple2<String, String>> x$6 = this.runSpark$default$4();
        Seq<String> x$7 = this.runSpark$default$5();
        Map<String, String> x$8 = this.runSpark$default$8();
        Option<File> x$9 = this.runSpark$default$9();
        SparkAppHandle.State finalState = this.runSpark(x$1, x$2, (Seq<String>)x$3, x$6, x$7, (Seq<String>)x$4, x$5, x$8, x$9);
        this.checkResult(finalState, driverResult, "ORIGINAL", this.checkResult$default$4());
        this.checkResult(finalState, executorResult, expectExecutorFailure ? "failure" : "ORIGINAL", this.checkResult$default$4());
    }

    private Map<String, String> testWithAddJar$default$3() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    private boolean testWithAddJar$default$4() {
        return false;
    }

    private void testPySpark(boolean clientMode, Map<String, String> extraConf, Map<String, String> extraEnv) {
        SparkAppHandle.State finalState;
        File primaryPyFile = new File(this.tempDir(), "test.py");
        Files.write((CharSequence)this.TEST_PYFILE(), (File)primaryPyFile, (Charset)StandardCharsets.UTF_8);
        String sparkHome = (String)scala.sys.package$.MODULE$.props().apply((Object)"spark.test.home");
        Seq pythonPath = (Seq)new .colon.colon((Object)new StringBuilder(12).append(sparkHome).append("/python/lib/").append(PythonUtils$.MODULE$.PY4J_ZIP_NAME()).toString(), (List)new .colon.colon((Object)new StringBuilder(7).append(sparkHome).append("/python").toString(), (List)Nil$.MODULE$));
        Map extraEnvVars = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYSPARK_ARCHIVES_PATH"), (Object)((TraversableOnce)pythonPath.map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(6).append("local:").append((String)x$1).toString(), Seq$.MODULE$.canBuildFrom())).mkString(File.pathSeparator)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYTHONPATH"), (Object)pythonPath.mkString(File.pathSeparator)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYSPARK_DRIVER_PYTHON"), (Object)this.pythonExecutablePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYSPARK_PYTHON"), (Object)this.pythonExecutablePath())}))).$plus$plus(extraEnv);
        File subdir = new File(this.tempDir(), "pyModules");
        subdir.mkdir();
        File moduleDir = subdir;
        File pyModule = new File(moduleDir, "mod1.py");
        Files.write((CharSequence)this.TEST_PYMODULE(), (File)pyModule, (Charset)StandardCharsets.UTF_8);
        URL mod2Archive = TestUtils$.MODULE$.createJarWithFiles((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mod2.py"), (Object)this.TEST_PYMODULE())})), moduleDir);
        String pyFiles = ((TraversableOnce)new .colon.colon((Object)pyModule.getAbsolutePath(), (List)new .colon.colon((Object)mod2Archive.getPath(), (List)Nil$.MODULE$))).mkString(",");
        File result = File.createTempFile("result", null, this.tempDir());
        Some outFile = new Some((Object)File.createTempFile("stdout", null, this.tempDir()));
        boolean x$12 = clientMode;
        String x$2 = primaryPyFile.getAbsolutePath();
        Seq x$3 = (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"--py-files"), (Object)pyFiles), (List)Nil$.MODULE$);
        Seq x$4 = (Seq)new .colon.colon((Object)result.getAbsolutePath(), (List)Nil$.MODULE$);
        Map x$5 = extraEnvVars;
        Map<String, String> x$6 = extraConf;
        Some x$7 = outFile;
        Seq<String> x$8 = this.runSpark$default$5();
        Seq<String> x$9 = this.runSpark$default$6();
        SparkAppHandle.State x$10 = finalState = this.runSpark(x$12, x$2, (Seq<String>)x$4, (Seq<Tuple2<String, String>>)x$3, x$8, x$9, x$6, (Map<String, String>)x$5, (Option<File>)x$7);
        File x$11 = result;
        Some x$122 = outFile;
        String x$13 = this.checkResult$default$3();
        this.checkResult(x$10, x$11, x$13, (Option<File>)x$122);
    }

    private Map<String, String> testPySpark$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    private Map<String, String> testPySpark$default$3() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    private void testUseClassPathFirst(boolean clientMode) {
        URL originalJar = TestUtils$.MODULE$.createJarWithFiles((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test.resource"), (Object)"ORIGINAL")})), this.tempDir());
        URL userJar = TestUtils$.MODULE$.createJarWithFiles((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test.resource"), (Object)"OVERRIDDEN")})), this.tempDir());
        File driverResult = File.createTempFile("driver", null, this.tempDir());
        File executorResult = File.createTempFile("executor", null, this.tempDir());
        boolean x$1 = clientMode;
        String x$2 = this.mainClassName(YarnClasspathTest$.MODULE$.getClass());
        Seq x$3 = (Seq)new .colon.colon((Object)driverResult.getAbsolutePath(), (List)new .colon.colon((Object)executorResult.getAbsolutePath(), (List)Nil$.MODULE$));
        Seq x$4 = (Seq)new .colon.colon((Object)originalJar.getPath(), (List)Nil$.MODULE$);
        Seq x$5 = (Seq)new .colon.colon((Object)new StringBuilder(6).append("local:").append(userJar.getPath()).toString(), (List)Nil$.MODULE$);
        Map x$6 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.driver.userClassPathFirst"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executor.userClassPathFirst"), (Object)"true")}));
        Seq<Tuple2<String, String>> x$7 = this.runSpark$default$4();
        Map<String, String> x$8 = this.runSpark$default$8();
        Option<File> x$9 = this.runSpark$default$9();
        SparkAppHandle.State finalState = this.runSpark(x$1, x$2, (Seq<String>)x$3, x$7, (Seq<String>)x$4, (Seq<String>)x$5, (Map<String, String>)x$6, x$8, x$9);
        this.checkResult(finalState, driverResult, "OVERRIDDEN", this.checkResult$default$4());
        this.checkResult(finalState, executorResult, "OVERRIDDEN", this.checkResult$default$4());
    }

    private void testExecutorEnv(boolean clientMode) {
        File result = File.createTempFile("result", null, this.tempDir());
        boolean x$1 = clientMode;
        String x$2 = this.mainClassName(ExecutorEnvTestApp$.MODULE$.getClass());
        Seq x$3 = (Seq)new .colon.colon((Object)result.getAbsolutePath(), (List)Nil$.MODULE$);
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.appMasterEnv.TEST_ENV"), (Object)"am_val"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executorEnv.TEST_ENV"), (Object)"executor_val")}));
        Seq<Tuple2<String, String>> x$5 = this.runSpark$default$4();
        Seq<String> x$6 = this.runSpark$default$5();
        Seq<String> x$7 = this.runSpark$default$6();
        Map<String, String> x$8 = this.runSpark$default$8();
        Option<File> x$9 = this.runSpark$default$9();
        SparkAppHandle.State finalState = this.runSpark(x$1, x$2, (Seq<String>)x$3, x$5, x$6, x$7, (Map<String, String>)x$4, x$8, x$9);
        this.checkResult(finalState, result, "true", this.checkResult$default$4());
    }

    /*
     * WARNING - void declaration
     */
    public File createEmptyIvySettingsFile() {
        void var1_1;
        File emptyIvySettings = File.createTempFile("ivy", ".xml");
        Files.write((CharSequence)"<ivysettings />", (File)emptyIvySettings, (Charset)StandardCharsets.UTF_8);
        return var1_1;
    }

    public void testIvySettingsDistribution(boolean clientMode, String ivySettingsPath, String expectedIvySettingsPrefixOnDriver, boolean prefixMatch) {
        SparkAppHandle.State finalState;
        File result = File.createTempFile("result", null, this.tempDir());
        File outFile = File.createTempFile("out", null, this.tempDir());
        boolean x$1 = clientMode;
        String x$2 = this.mainClassName(YarnAddJarTest$.MODULE$.getClass());
        Seq x$3 = (Seq)new .colon.colon((Object)result.getAbsolutePath(), (List)new .colon.colon((Object)expectedIvySettingsPrefixOnDriver, (List)new .colon.colon((Object)Boolean.toString(prefixMatch), (List)Nil$.MODULE$)));
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.jars.ivySettings"), (Object)ivySettingsPath)}));
        Option x$5 = Option$.MODULE$.apply((Object)outFile);
        Seq<Tuple2<String, String>> x$6 = this.runSpark$default$4();
        Seq<String> x$7 = this.runSpark$default$5();
        Seq<String> x$8 = this.runSpark$default$6();
        Map<String, String> x$9 = this.runSpark$default$8();
        SparkAppHandle.State x$10 = finalState = this.runSpark(x$1, x$2, (Seq<String>)x$3, x$6, x$7, x$8, (Map<String, String>)x$4, x$9, (Option<File>)x$5);
        File x$11 = result;
        Option x$12 = Option$.MODULE$.apply((Object)outFile);
        String x$13 = this.checkResult$default$3();
        this.checkResult(x$10, x$11, x$13, (Option<File>)x$12);
    }

    public boolean testIvySettingsDistribution$default$4() {
        return false;
    }

    public YarnClusterSuite() {
        Option maybePath = TestUtils$.MODULE$.getAbsolutePathFromExecutable("python3");
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(maybePath.isDefined(), "maybePath.isDefined", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        this.pythonExecutablePath = (String)maybePath.get();
        this.TEST_PYFILE = new StringOps(Predef$.MODULE$.augmentString("\n    |import mod1, mod2\n    |import sys\n    |from operator import add\n    |\n    |from pyspark import SparkConf , SparkContext\n    |if __name__ == \"__main__\":\n    |    if len(sys.argv) != 2:\n    |        print >> sys.stderr, \"Usage: test.py [result file]\"\n    |        exit(-1)\n    |    sc = SparkContext(conf=SparkConf())\n    |    status = open(sys.argv[1],'w')\n    |    result = \"failure\"\n    |    rdd = sc.parallelize(range(10)).map(lambda x: x * mod1.func() * mod2.func())\n    |    cnt = rdd.count()\n    |    if cnt == 10:\n    |        result = \"success\"\n    |    status.write(result)\n    |    status.close()\n    |    sc.stop()\n    ")).stripMargin();
        this.TEST_PYMODULE = new StringOps(Predef$.MODULE$.augmentString("\n    |def func():\n    |    return 42\n    ")).stripMargin();
        this.test("run Spark in yarn-client mode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testBasicYarnApp(true, this.testBasicYarnApp$default$2()), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        this.test("run Spark in yarn-cluster mode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testBasicYarnApp(false, this.testBasicYarnApp$default$2()), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        this.test("run Spark in yarn-client mode with unmanaged am", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testBasicYarnApp(true, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.YARN_UNMANAGED_AM().key()), (Object)"true")})))), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        this.test("run Spark in yarn-client mode with different configurations, ensuring redaction", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testBasicYarnApp(true, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY().key()), (Object)"512m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_CORES().key()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY().key()), (Object)"512m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES().key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executorEnv.HADOOP_CREDSTORE_PASSWORD"), (Object)YarnClusterDriver$.MODULE$.SECRET_PASSWORD()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.appMasterEnv.HADOOP_CREDSTORE_PASSWORD"), (Object)YarnClusterDriver$.MODULE$.SECRET_PASSWORD())})))), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.test("run Spark in yarn-cluster mode with different configurations, ensuring redaction", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testBasicYarnApp(false, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY().key()), (Object)"512m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_CORES().key()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_CORES().key()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY().key()), (Object)"512m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES().key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executorEnv.HADOOP_CREDSTORE_PASSWORD"), (Object)YarnClusterDriver$.MODULE$.SECRET_PASSWORD()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.appMasterEnv.HADOOP_CREDSTORE_PASSWORD"), (Object)YarnClusterDriver$.MODULE$.SECRET_PASSWORD())})))), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        this.test("yarn-cluster should respect conf overrides in SparkHadoopUtil (SPARK-16414, SPARK-23630)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            File customConf = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            String coreSite = new StringOps(Predef$.MODULE$.augmentString("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n      |<configuration>\n      |  <property>\n      |    <name>spark.test.key</name>\n      |    <value>testvalue</value>\n      |  </property>\n      |</configuration>\n      |")).stripMargin();
            Files.write((CharSequence)coreSite, (File)new File(customConf, "core-site.xml"), (Charset)StandardCharsets.UTF_8);
            File result = File.createTempFile("result", null, this.tempDir());
            boolean x$1 = false;
            String x$2 = this.mainClassName(YarnClusterDriverUseSparkHadoopUtilConf$.MODULE$.getClass());
            Seq x$3 = (Seq)new .colon.colon((Object)"key=value", (List)new .colon.colon((Object)"spark.test.key=testvalue", (List)new .colon.colon((Object)result.getAbsolutePath(), (List)Nil$.MODULE$)));
            Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.hadoop.key"), (Object)"value")}));
            Map x$5 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_TEST_HADOOP_CONF_DIR"), (Object)customConf.getAbsolutePath())}));
            Seq<Tuple2<String, String>> x$6 = this.runSpark$default$4();
            Seq<String> x$7 = this.runSpark$default$5();
            Seq<String> x$8 = this.runSpark$default$6();
            Option<File> x$9 = this.runSpark$default$9();
            SparkAppHandle.State finalState = this.runSpark(x$1, x$2, (Seq<String>)x$3, x$6, x$7, x$8, (Map<String, String>)x$4, (Map<String, String>)x$5, x$9);
            this.checkResult(finalState, result, this.checkResult$default$3(), this.checkResult$default$4());
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        this.test("SPARK-35672: run Spark in yarn-client mode with additional jar using URI scheme 'local'", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String jarPath = this.createJarWithOriginalResourceFile().getPath();
            this.testWithAddJar(true, new StringBuilder(6).append("local:").append(jarPath).toString(), this.testWithAddJar$default$3(), this.testWithAddJar$default$4());
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        this.test("SPARK-35672: run Spark in yarn-cluster mode with additional jar using URI scheme 'local'", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String jarPath = this.createJarWithOriginalResourceFile().getPath();
            this.testWithAddJar(false, new StringBuilder(6).append("local:").append(jarPath).toString(), this.testWithAddJar$default$3(), this.testWithAddJar$default$4());
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
        this.test("SPARK-35672: run Spark in yarn-client mode with additional jar using URI scheme 'local' and gateway-replacement path", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            URL jarUrl = this.createJarWithOriginalResourceFile();
            this.testWithAddJar(true, new StringBuilder(6).append("local:").append(jarUrl.getPath()).toString(), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.GATEWAY_ROOT_PATH().key()), (Object)((Object)Paths.get(jarUrl.toURI()).getParent()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.REPLACEMENT_ROOT_PATH().key()), (Object)"/nonexistent/path/")}))), true);
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
        this.test("SPARK-35672: run Spark in yarn-cluster mode with additional jar using URI scheme 'local' and gateway-replacement path", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String jarPath = this.createJarWithOriginalResourceFile().getPath();
            String gatewayPath = "/replaceme/nonexistent/";
            this.testWithAddJar(false, new StringBuilder(6).append("local:").append(gatewayPath).append(jarPath).toString(), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.GATEWAY_ROOT_PATH().key()), (Object)gatewayPath), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.REPLACEMENT_ROOT_PATH().key()), (Object)"")}))), this.testWithAddJar$default$4());
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        this.test("SPARK-35672: run Spark in yarn-cluster mode with additional jar using URI scheme 'local' and gateway-replacement path containing an environment variable", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Path jarPath = Paths.get(this.createJarWithOriginalResourceFile().toURI());
            Map envVarConfigs = (Map)((TraversableLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PARENT"), (Object)jarPath.getParent()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"FILENAME"), (Object)jarPath.getFileName())}))).flatMap((Function1 & Serializable & scala.Serializable)envVar -> (Seq)((TraversableLike)new .colon.colon((Object)"spark.yarn.appMasterEnv.", (List)new .colon.colon((Object)"spark.executorEnv.", (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)prefix -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append((String)prefix).append(envVar._1()).toString()), (Object)envVar._2().toString()), Seq$.MODULE$.canBuildFrom()), Map$.MODULE$.canBuildFrom());
            String osSpecificEnvVar = Utils$.MODULE$.isWindows() ? "%PARENT%" : "${PARENT}";
            this.testWithAddJar(false, "local:/replaceme", (Map<String, String>)((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.GATEWAY_ROOT_PATH().key()), (Object)"/replaceme"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.REPLACEMENT_ROOT_PATH().key()), (Object)new StringBuilder(13).append(osSpecificEnvVar).append("/{{FILENAME}}").toString())}))).$plus$plus((GenTraversableOnce)envVarConfigs), this.testWithAddJar$default$4());
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
        this.test("SPARK-35672: run Spark in yarn-client mode with additional jar using URI scheme 'file'", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String jarPath = this.createJarWithOriginalResourceFile().getPath();
            this.testWithAddJar(true, new StringBuilder(5).append("file:").append(jarPath).toString(), this.testWithAddJar$default$3(), this.testWithAddJar$default$4());
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
        this.test("SPARK-35672: run Spark in yarn-cluster mode with additional jar using URI scheme 'file'", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String jarPath = this.createJarWithOriginalResourceFile().getPath();
            this.testWithAddJar(false, new StringBuilder(5).append("file:").append(jarPath).toString(), this.testWithAddJar$default$3(), this.testWithAddJar$default$4());
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
        this.test("run Spark in yarn-cluster mode unsuccessfully", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            SparkAppHandle.State finalState = this.runSpark(false, this.mainClassName(YarnClusterDriver$.MODULE$.getClass()), this.runSpark$default$3(), this.runSpark$default$4(), this.runSpark$default$5(), this.runSpark$default$6(), this.runSpark$default$7(), this.runSpark$default$8(), this.runSpark$default$9());
            return Matchers$.MODULE$.convertToAnyShouldWrapper((Object)finalState, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224), Prettifier$.MODULE$.default()).should(this.be().apply((Object)SparkAppHandle.State.FAILED));
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
        this.test("run Spark in yarn-cluster mode failure after sc initialized", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            SparkAppHandle.State finalState = this.runSpark(false, this.mainClassName(YarnClusterDriverWithFailure$.MODULE$.getClass()), this.runSpark$default$3(), this.runSpark$default$4(), this.runSpark$default$5(), this.runSpark$default$6(), this.runSpark$default$7(), this.runSpark$default$8(), this.runSpark$default$9());
            return Matchers$.MODULE$.convertToAnyShouldWrapper((Object)finalState, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229), Prettifier$.MODULE$.default()).should(this.be().apply((Object)SparkAppHandle.State.FAILED));
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
        this.test("run Python application in yarn-client mode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testPySpark(true, this.testPySpark$default$2(), this.testPySpark$default$3()), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
        this.test("run Python application in yarn-cluster mode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testPySpark(false, this.testPySpark$default$2(), this.testPySpark$default$3()), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
        this.test("run Python application in yarn-cluster mode using spark.yarn.appMasterEnv to override local envvar", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testPySpark(false, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.appMasterEnv.PYSPARK_DRIVER_PYTHON"), scala.sys.package$.MODULE$.env().getOrElse((Object)"PYSPARK_DRIVER_PYTHON", (Function0 & Serializable & scala.Serializable)() -> this.pythonExecutablePath())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.appMasterEnv.PYSPARK_PYTHON"), scala.sys.package$.MODULE$.env().getOrElse((Object)"PYSPARK_PYTHON", (Function0 & Serializable & scala.Serializable)() -> this.pythonExecutablePath()))}))), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYSPARK_DRIVER_PYTHON"), (Object)"not python"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYSPARK_PYTHON"), (Object)"not python")})))), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
        this.test("user class path first in client mode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testUseClassPathFirst(true), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        this.test("user class path first in cluster mode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testUseClassPathFirst(false), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
        this.test("monitor app using launcher library", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("YARN_CONF_DIR", this.hadoopConfDir().getAbsolutePath());
            String propsFile = this.createConfFile(this.createConfFile$default$1(), this.createConfFile$default$2());
            SparkAppHandle handle = new SparkLauncher(env).setSparkHome((String)scala.sys.package$.MODULE$.props().apply((Object)"spark.test.home")).setConf(UI$.MODULE$.UI_ENABLED().key(), "false").setPropertiesFile(propsFile).setMaster("yarn").setDeployMode("client").setAppResource("spark-internal").setMainClass(this.mainClassName(YarnLauncherTestApp$.MODULE$.getClass())).startApplication(new SparkAppHandle.Listener[0]);
            try {
                Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(3)).minutes())), Eventually$.MODULE$.interval(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).milliseconds())), (Function0 & Serializable & scala.Serializable)() -> Matchers$.MODULE$.convertToAnyShouldWrapper((Object)handle.getState(), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279), Prettifier$.MODULE$.default()).should(this.be().apply((Object)SparkAppHandle.State.RUNNING)), Retrying$.MODULE$.retryingNatureOfT(), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
                Matchers$.MODULE$.convertToStringShouldWrapper(handle.getAppId(), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282), Prettifier$.MODULE$.default()).should(this.not()).be(null, Predef$.MODULE$.$conforms());
                Matchers$.MODULE$.convertToStringShouldWrapper(handle.getAppId(), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283), Prettifier$.MODULE$.default()).should(this.startWith().apply("application_"));
                handle.stop();
                object = Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(3)).minutes())), Eventually$.MODULE$.interval(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).milliseconds())), (Function0 & Serializable & scala.Serializable)() -> Matchers$.MODULE$.convertToAnyShouldWrapper((Object)handle.getState(), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287), Prettifier$.MODULE$.default()).should(this.be().apply((Object)SparkAppHandle.State.KILLED)), Retrying$.MODULE$.retryingNatureOfT(), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
            }
            finally {
                handle.kill();
            }
            return object;
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
        this.test("running Spark in yarn-cluster mode displays driver log links", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            File log4jConf = new File(this.tempDir(), "log4j.properties");
            File logOutFile = new File(this.tempDir(), "logs");
            Files.write((CharSequence)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(244).append("rootLogger.level = debug\n         |rootLogger.appenderRef.file.ref = file\n         |appender.file.type = File\n         |appender.file.name = file\n         |appender.file.fileName = ").append(logOutFile).append("\n         |appender.file.layout.type = PatternLayout\n         |").toString())).stripMargin(), (File)log4jConf, (Charset)StandardCharsets.UTF_8);
            File confDir = new File(this.tempDir(), "conf");
            confDir.mkdir();
            File javaOptsFile = new File(confDir, "java-opts");
            Files.write((CharSequence)new StringBuilder(34).append("-Dlog4j.configurationFile=file://").append(log4jConf).append("\n").toString(), (File)javaOptsFile, (Charset)StandardCharsets.UTF_8);
            File result = File.createTempFile("result", null, this.tempDir());
            boolean x$10 = false;
            String x$11 = this.mainClassName(YarnClusterDriver$.MODULE$.getClass());
            Seq x$12 = (Seq)new .colon.colon((Object)result.getAbsolutePath(), (List)Nil$.MODULE$);
            Map x$13 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_CONF_DIR"), (Object)confDir.getAbsolutePath())}));
            Map x$14 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.CLIENT_INCLUDE_DRIVER_LOGS_LINK().key()), (Object)Boolean.toString(true))}));
            Seq<Tuple2<String, String>> x$15 = this.runSpark$default$4();
            Seq<String> x$16 = this.runSpark$default$5();
            Seq<String> x$17 = this.runSpark$default$6();
            Option<File> x$18 = this.runSpark$default$9();
            SparkAppHandle.State finalState = this.runSpark(x$10, x$11, (Seq<String>)x$12, x$15, x$16, x$17, (Map<String, String>)x$14, (Map<String, String>)x$13, x$18);
            this.checkResult(finalState, result, this.checkResult$default$3(), this.checkResult$default$4());
            String logOutput = Files.toString((File)logOutFile, (Charset)StandardCharsets.UTF_8);
            String logFilePattern = "(?s).+\\sDriver Logs \\(<NAME>\\): https?://.+/<NAME>(\\?\\S+)?\\s.+";
            Matchers$.MODULE$.convertToStringShouldWrapper(logOutput, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324), Prettifier$.MODULE$.default()).should(this.fullyMatch()).regex(logFilePattern.replace("<NAME>", "stdout"));
            return Matchers$.MODULE$.convertToStringShouldWrapper(logOutput, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325), Prettifier$.MODULE$.default()).should(this.fullyMatch()).regex(logFilePattern.replace("<NAME>", "stderr"));
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
        this.test("timeout to get SparkContext in cluster mode triggers failure", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            int timeout = 2000;
            boolean x$19 = false;
            String x$20 = this.mainClassName(SparkContextTimeoutApp$.MODULE$.getClass());
            Seq x$21 = (Seq)new .colon.colon((Object)Integer.toString(timeout * 4), (List)Nil$.MODULE$);
            Map x$22 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.AM_MAX_WAIT_TIME().key()), (Object)Integer.toString(timeout))}));
            Seq<Tuple2<String, String>> x$23 = this.runSpark$default$4();
            Seq<String> x$24 = this.runSpark$default$5();
            Seq<String> x$25 = this.runSpark$default$6();
            Map<String, String> x$26 = this.runSpark$default$8();
            Option<File> x$27 = this.runSpark$default$9();
            SparkAppHandle.State finalState = this.runSpark(x$19, x$20, (Seq<String>)x$21, x$23, x$24, x$25, (Map<String, String>)x$22, x$26, x$27);
            return Matchers$.MODULE$.convertToAnyShouldWrapper((Object)finalState, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333), Prettifier$.MODULE$.default()).should(this.be().apply((Object)SparkAppHandle.State.FAILED));
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
        this.test("executor env overwrite AM env in client mode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testExecutorEnv(true), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
        this.test("executor env overwrite AM env in cluster mode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testExecutorEnv(false), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
        this.test("SPARK-34472: ivySettings file with no scheme or file:// scheme should be localized on driver in cluster mode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            File emptyIvySettings = this.createEmptyIvySettingsFile();
            this.testIvySettingsDistribution(false, emptyIvySettings.getAbsolutePath(), emptyIvySettings.getName(), true);
            this.testIvySettingsDistribution(false, new StringBuilder(7).append("file://").append(emptyIvySettings.getAbsolutePath()).toString(), emptyIvySettings.getName(), true);
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 449));
        this.test("SPARK-34472: ivySettings file with no scheme or file:// scheme should retain user provided path in client mode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            File emptyIvySettings = this.createEmptyIvySettingsFile();
            this.testIvySettingsDistribution(true, emptyIvySettings.getAbsolutePath(), emptyIvySettings.getAbsolutePath(), this.testIvySettingsDistribution$default$4());
            this.testIvySettingsDistribution(true, new StringBuilder(7).append("file://").append(emptyIvySettings.getAbsolutePath()).toString(), new StringBuilder(7).append("file://").append(emptyIvySettings.getAbsolutePath()).toString(), this.testIvySettingsDistribution$default$4());
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 461));
        this.test("SPARK-34472: ivySettings file with non-file:// schemes should throw an error", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            File emptyIvySettings = this.createEmptyIvySettingsFile();
            TestFailedException e1 = (TestFailedException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testIvySettingsDistribution(false, new StringBuilder(8).append("local://").append(emptyIvySettings.getAbsolutePath()).toString(), "", this.testIvySettingsDistribution$default$4()), ClassTag$.MODULE$.apply(TestFailedException.class), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 473));
            String $org_scalatest_assert_macro_left = e1.getMessage();
            String $org_scalatest_assert_macro_right = "IllegalArgumentException: Scheme local not supported in spark.jars.ivySettings";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 477));
            TestFailedException e2 = (TestFailedException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testIvySettingsDistribution(false, new StringBuilder(7).append("hdfs://").append(emptyIvySettings.getAbsolutePath()).toString(), "", this.testIvySettingsDistribution$default$4()), ClassTag$.MODULE$.apply(TestFailedException.class), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 479));
            String $org_scalatest_assert_macro_left2 = e2.getMessage();
            String $org_scalatest_assert_macro_right2 = "IllegalArgumentException: Scheme hdfs not supported in spark.jars.ivySettings";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 483));
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 471));
    }
}

